<?php
/**
 * Text One Widget
 */

namespace Elementor;
class Falar_Text_Slide extends Widget_Base {

	public function get_name() {
        return 'Falar_Text_Slide';
    }

	public function get_title() {
        return __( 'Text Slide', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Text_Slide_Area',
			[
				'label' => __( 'Text Slide Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $list_items = new Repeater();

            $list_items->add_control(
				'slide_text',
				[
					'label'       => __( 'Slide Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'target',
				[
					'label'       => __( 'Target', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'text_item',
                [
                    'label' => esc_html__('Add Text Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'text_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .slider-text-area .text-slide span' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .slider-text-area .text-slide span',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $text_item = $settings['text_item'];
        ?>

        <!-- slider Text Area Start -->
        <div class="slider-text-area pb-100">
            <div class="container-fluid">
                <div class="text-slide">
                    <?php foreach($text_item as $item_text): ?>
                        <span>
                            <?php echo wp_kses_post( $item_text['slide_text'] ); ?>
                        </span>

                        <span>
                            <?php echo wp_kses_post( $item_text['target'] ); ?> 
                        </span>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <!-- slider Text Area End -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Text_Slide );