<?php
/**
 * Video Three Widget
 */

namespace Elementor;
class Falar_Video_Three extends Widget_Base {

	public function get_name() {
        return 'Falar_Video_Three';
    }

	public function get_title() {
        return __( 'Video Three', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Video_Area',
			[
				'label' => __( 'Video Three Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'video_img',
            [
                'label'       => __( 'Video Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'video_url',
            [
                'label'       => __( 'Video Url', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'video_icon',
            [
                'label'       => __( 'Video Icon', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('ti ti-player-play-filled', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

            $this->add_control(
				'shape',
				[
					'label'       => __( 'Shape', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);

        $this->end_controls_section();

        $this->start_controls_section(
			'video_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'area_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .video-warp' => 'background: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'video_btn_bg_color',
				[
					'label'     => __( 'Video Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .inner-video .video-btn' => 'background: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();
        
    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Video Warp Start -->
        <div class="video-warp">
            <div class="container">
                <div class="inner-video home-four-video">
                    <?php if( $settings['video_img']['url'] != '' ): ?>
                        <img src="<?php echo esc_url($settings['video_img']['url'] ) ?>" class="video-inage" alt="image">
                    <?php endif; ?>
                    <?php if( $settings['video_url']): ?>
                        <a class="video-btn popup-youtube" href="<?php echo wp_kses_post( $settings['video_url'] ); ?>">
                            <?php if( $settings['video_icon']): ?>
                                <div class="icon rounded-circle">
                                    <i class="<?php echo wp_kses_post( $settings['video_icon'] ); ?>"></i>
                                </div>
                            <?php endif; ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="all-shapes">
                <?php if( $settings['shape']['url'] != '' ): ?>
                    <img src="<?php echo esc_url($settings['shape']['url'] ) ?>" class="apply-shape2" alt="image">
                <?php endif; ?>
            </div>
        </div>
        <!-- Video Warp End -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Video_Three );