const { registerBlockType } = wp.blocks;
const { InspectorControls, RichText } = wp.blockEditor;
const { PanelBody, TextControl } = wp.components;
const { createElement } = wp.element;
const { __ } = wp.i18n;

const creditCardFields = createElement(
    'fieldset',
    {
        id: 'wc-teip_gateway-cc-form',
        className: 'wc-credit-card-form wc-payment-form',
        style: { background: 'transparent' },
    },
    createElement('input', {
        id: 'teip_ccno',
        name: 'ccno',
        type: 'text',
        autoComplete: 'off',
        maxLength: '16',
        placeholder: '0000 0000 0000 0000',
    }),
    createElement('input', {
        id: 'teip_mmexpdate',
        name: 'mmExpDate',
        type: 'text',
        autoComplete: 'off',
        maxLength: '2',
        placeholder: 'MM',
    }),
    createElement('input', {
        id: 'teip_yyexpdate',
        name: 'yyExpDate',
        type: 'text',
        autoComplete: 'off',
        maxLength: '2',
        placeholder: 'YY',
    }),
    createElement('input', {
        id: 'teip_cvc',
        name: 'cvc',
        type: 'password',
        autoComplete: 'off',
        maxLength: '3',
        placeholder: 'CVC',
    })
);

// Renderizando en el checkout de WooCommerce
const { Fragment } = wp.element;

registerBlockType('teip/checkout-block', {
    title: __('Teip Payment Block', 'teip-payment-gateway'),
    icon: 'smiley',
    category: 'woocommerce',
    supports: {
        align: ['wide', 'full'],
    },
    attributes: {
        content: {
            type: 'string',
            source: 'html',
            selector: 'p',
        },
        customAttribute: {
            type: 'string',
            default: 'default value',
        },
    },
    edit: ({ attributes, setAttributes }) => {
        const { content, customAttribute } = attributes;
        return createElement(Fragment, null, creditCardFields);
    },
    save: ({ attributes }) => {
        const { content, customAttribute } = attributes;
        return createElement(Fragment, null, creditCardFields);
    },
});
