<?php

function register_teip_payment_block() {
    // Registro del script del bloque
    wp_register_script(
        'teip-block-script',
        plugin_dir_url(__FILE__) . '../blocks/teip-block.js',
        array('wp-blocks', 'wp-element', 'wp-editor', 'wp-components', 'wp-i18n', 'wp-data'),
        filemtime(plugin_dir_path(__FILE__) . '../blocks/teip-block.js')
    );

    // Registro del estilo del bloque
    wp_register_style(
        'teip-block-style',
        plugin_dir_url(__FILE__) . '../blocks/teip-block.css',
        array(),
        filemtime(plugin_dir_path(__FILE__) . '../blocks/teip-block.css')
    );

    // Registro del bloque
    register_block_type('teip/checkout-block', array(
        'editor_script' => 'teip-block-script',
        'editor_style' => 'teip-block-style',
        'render_callback' => 'render_teip_payment_block',
        'attributes' => array(
            'content' => array(
                'type' => 'string',
                'source' => 'html',
                'selector' => 'p',
            ),
            'customAttribute' => array(
                'type' => 'string',
                'default' => 'default value',
            ),
        ),
    ));
}
add_action('init', 'register_teip_payment_block');


function render_teip_payment_block($attributes) {
    //if (defined('WP_DEBUG') && WP_DEBUG) {
        error_log('Renderizando el bloque de pago personalizado.');
    //}

    $content = isset($attributes['content']) ? $attributes['content'] : '';
    $customAttribute = isset($attributes['customAttribute']) ? $attributes['customAttribute'] : 'default value';

    ob_start();
    ?>
        <?php echo wp_kses_post($content); ?>
    <?php
    return ob_get_clean();
}


function enqueue_teip_block_assets() {
    error_log(plugin_dir_url(__FILE__) . '../blocks/teip-block.js');

    wp_enqueue_script(
        'teip-block-script',
        plugin_dir_url(__FILE__) . '../blocks/teip-block.js',
        array('wp-blocks', 'wp-element', 'wp-editor', 'wp-components', 'wp-i18n', 'wp-data'),
        filemtime(plugin_dir_path(__FILE__) . '../blocks/teip-block.js'),
        true
    );
    wp_enqueue_style(
        'teip-block-style',
        plugin_dir_url(__FILE__) . '../blocks/teip-block.css',
        array(),
        filemtime(plugin_dir_path(__FILE__) . '../blocks/teip-block.css')
    );
}
add_action('enqueue_block_assets', 'enqueue_teip_block_assets');
