<?php
/*
 * Plugin Name: Teip Payment Gateway
 * Plugin URI: https://teip.io/
 * Description: Teip Payment Gateway
 * Author: Teip
 * Author URI: https://teip.io/
 * Version: 1.0.0
 * Text Domain: teip-payment-gateway
 * Domain Path: /languages
 * WC requires at least: 6.0
 * WC tested up to: 8.0
 */

// Agrega la pasarela de pago
add_filter('woocommerce_payment_gateways', 'add_teip_payment_gateway');
function add_teip_payment_gateway($gateways) {
    error_log('Registrando teip payment gateway.');
    $gateways[] = 'WC_teip_Payment_Gateway';
    return $gateways;
}

function teip_payment_gateway_load_textdomain() {
    load_plugin_textdomain('teip-payment-gateway', false, basename(dirname(__FILE__)) . '/languages');
}
add_action('plugins_loaded', 'teip_payment_gateway_load_textdomain');

// Asegúrate de que WooCommerce esté activo
add_action('plugins_loaded', 'init_teip_payment_gateway');
function init_teip_payment_gateway() {
    if (!class_exists('WooCommerce')) {
        add_action('admin_notices', 'teip_payment_gateway_woocommerce_inactive_notice');
        return;
    }
    // Incluye la clase de la pasarela de pago
    require_once plugin_dir_path(__FILE__) . 'includes/class-teip-payment-gateway.php';

}

function teip_payment_gateway_woocommerce_inactive_notice() {
    echo '<div class="error"><p>' . __('WooCommerce must be installed and active for the teip Payment Gateway to function.', 'teip-payment-gateway') . '</p></div>';
}

// Activa el plugin
register_activation_hook(__FILE__, 'teip_payment_gateway_activate');
function teip_payment_gateway_activate() {
    if (!class_exists('WooCommerce')) {
        deactivate_plugins(plugin_basename(__FILE__));
        wp_die(__('Este plugin requiere WooCommerce para funcionar.','teip-payment-gateway'));
    }else{
        error_log('Renderizando el bloque de pago personalizado 3.');
    }
}

function teip_custom_checkout_validation() {
    error_log($_POST['payment_method']);
    // Verificar si el método de pago seleccionado es el nuestro
    if (isset($_POST['payment_method']) && $_POST['payment_method'] === 'teip_gateway') {
        // Validar el número de tarjeta de crédito
        if (empty($_POST['ccno'])) {
            wc_add_notice(__('El número de tarjeta de crédito es obligatorio.', 'teip-payment-gateway'), 'error');
        }
        
        // Validar el CVC
        if (empty($_POST['cvc'])) {
            wc_add_notice(__('El CVC es obligatorio.', 'teip-payment-gateway'), 'error');
        }
        
        // Puedes agregar más validaciones según sea necesario
    }
}
add_action('woocommerce_checkout_process', 'teip_custom_checkout_validation');

// Incluye la funcionalidad del bloque
require_once plugin_dir_path(__FILE__) . 'includes/teip-block.php';

/* 
// Registro de bloques de WooCommerce
function register_teip_gateway_block() {
    if ( class_exists( 'Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType' ) ) {
        $registry = Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry::instance();
        $registry->register( new WC_Gateway_Teip_Block() );
    }
}
add_action( 'woocommerce_blocks_loaded', 'register_teip_gateway_block' );


  
 */