jQuery(function ($) {
    'use strict';
	jQuery(document).on('ready', function () {

		// scrollCue
		scrollCue.init();

		// Sticky, Go To Top JS
		$(window).on('scroll', function() {
			// Header Sticky JS
			if ($(this).scrollTop() >100){  
				$('.navbar').addClass("sticky");
			}
			else{
				$('.navbar').removeClass("sticky");
			};
		});

		// Product +/-
		$(".plus-btn").on('click', function() {
			var  input = $(this).prev('input.qty');
			var val = parseInt(input.val());
			var step = input.attr('step');
			step = 'undefined' !== typeof(step) ? parseInt(step) : 1;
			input.val( val + step ).change();
		});

		$(".minus-btn").on('click', function() {
			var input = $(this).next('input.qty');
			var val = parseInt(input.val());
			var step = input.attr('step');
			step = 'undefined' !== typeof(step) ? parseInt(step) : 1;
			if (val > 0) {
				input.val( val - step ).change();
			}
		});

		$('#eventFilterOption').change(function() {
			console.log('sss');
			$('#eventFilter').submit();
		});
	

		const getPreloaderId = document.getElementById('preloader');
        if (getPreloaderId) {
            getPreloaderId.style.display = 'none';
        }

		// Counter Js
        try {
            if ("IntersectionObserver" in window) {
                let counterObserver = new IntersectionObserver(function (entries, observer) {
                    entries.forEach(function (entry) {
                        if (entry.isIntersecting) {
                        let counter = entry.target;
                        let target = parseInt(counter.innerText);
                        let step = target / 200;
                        let current = 0;
                        let timer = setInterval(function () {
                            current += step;
                            counter.innerText = Math.floor(current);
                            if (parseInt(counter.innerText) >= target) {
                            clearInterval(timer);
                            }
                        }, 10);
                        counterObserver.unobserve(counter);
                        }
                    });
                });

                let counters = document.querySelectorAll(".counter");
                    counters.forEach(function (counter) {
                    counterObserver.observe(counter);
                });
            }
        } catch {}

		// Scroll Animation
		window.addEventListener('scroll', reveal);
		function reveal(){
			var reveals = document.querySelectorAll('.reveal');
			for (var i = 0; i < reveals.length; i++){
				var win_height = window.innerHeight;
				var reveal_top = reveals[i].getBoundingClientRect().top;
				var reveal_point = 100;
				if (reveal_top < win_height - reveal_point) {
				reveals[i].classList.add('active');
				} 
			}
		}
	
		// Scroll Animation
		window.addEventListener('scroll', reveal2);
		function reveal2(){
			var reveals = document.querySelectorAll('.reveal2');
			for (var i = 0; i < reveals.length; i++){
				var win_height = window.innerHeight;
				var reveal_top = reveals[i].getBoundingClientRect().top;
				var reveal_point = 100;
				if (reveal_top < win_height - reveal_point) {
				reveals[i].classList.add('active');
				} 
			}
		}
		
		// Scroll Animation
		window.addEventListener('scroll', reveal3);
		function reveal3(){
			var reveals = document.querySelectorAll('.reveal3');
			for (var i = 0; i < reveals.length; i++){
				var win_height = window.innerHeight;
				var reveal_top = reveals[i].getBoundingClientRect().top;
				var reveal_point = 100;
				if (reveal_top < win_height - reveal_point) {
				reveals[i].classList.add('active');
				} 
			}
		}
	
		// Scroll Animation
		window.addEventListener('scroll', reveal4);
		function reveal4(){
			var reveals = document.querySelectorAll('.reveal4');
			for (var i = 0; i < reveals.length; i++){
				var win_height = window.innerHeight;
				var reveal_top = reveals[i].getBoundingClientRect().top;
				var reveal_point = 100;
				if (reveal_top < win_height - reveal_point) {
				reveals[i].classList.add('active');
				} 
			}
		}

		// Video Pused JS
		try {
			const video = document.getElementById("video");
			const circlePlayButton = document.getElementById("circle-play-b");
	
			function togglePlay() {
				if (video.paused || video.ended) {
					video.play();
				} else {
					video.pause();
				}
			}
	
			circlePlayButton.addEventListener("click", togglePlay);
			video.addEventListener("playing", function () {
				circlePlayButton.style.opacity = 0;
			});
			video.addEventListener("pause", function () {
				circlePlayButton.style.opacity = 1;
			});
	
		} catch (err) {}

		// Moving  JS
		try {
			class Button {
				constructor(node) {
					this.button = node;
					this.distance = 200;
					this.a = 160;
					this.mouseHasEntered = false;
					this.mouseIsInButtonTerritory = false;
					this.init();
					this.handleEvent();
				}
			
				init() {
					let {
						width,
						height,
						x: centerPointX,
						y: centerPointY
					} = this.button.getBoundingClientRect(); 
			
					centerPointX = centerPointX + width / 2; 
					centerPointY = centerPointY + height / 2; 
			
					this.centerPointX = centerPointX;
					this.centerPointY = centerPointY;
				}
			
				handleEvent() {
					window.addEventListener('mousemove', (e) => this.handleMove(e));
					window.addEventListener('mouseout', () => this.handleReset())
					window.addEventListener('scroll', () => this.init()); 
					buttonObjects.push({button: this.button, isHovered: this.mouseIsInButtonTerritory});
				}
			
				handleMove(e) {
					const x = e.x; 
					const y = e.y; 
			
					const leftBorderLine = this.centerPointX - this.distance;
					const rightBorderLine = this.centerPointX + this.distance;
					const topBorderLine = this.centerPointY - this.distance;
					const bottomBorderline = this.centerPointY + this.distance;
					this.xWalk = (x - this.centerPointX) / 2; 
					this.yWalk = (y - this.centerPointY) / 2; 
			
					this.mouseIsInButtonTerritory =
						x > leftBorderLine &&
						x < rightBorderLine &&
						y > topBorderLine &&
						y < bottomBorderline; 
			
			
					if (this.mouseIsInButtonTerritory) {
						if (!this.mouseHasEntered) {
							this.distance = 220;
							this.mouseHasEntered = true;
						}
						this.handleCatch();   
					} else {
						this.handleReset()
					}
			
					const index = buttonObjects.findIndex(button => button.button === this.button);
					buttonObjects[index].isHovered = this.mouseIsInButtonTerritory;
				}
			
				handleCatch() {
					this.button.style.transform = `translate(${this.xWalk}px, ${this.yWalk}px)`;
				}
			
				handleReset() {
					this.button.style.transform = `translate(${0}px, ${0}px)`;
					if (this.mouseHasEntered) this.distance = 380;
				}
			}
		
			const buttons = document.querySelectorAll('.button');
			const bubble = document.querySelector('.bubble');
			const buttonObjects = [];
			
			buttons.forEach(button => {
				const node = button.querySelector('.button__like-text');
				new Button(node);
			});

		} catch (err) {}
	

		// Check if elements with the class "search-toggler" exist
		const searchTogglers = document.querySelectorAll(".search-toggler");
        if (searchTogglers.length > 0) {
        // Attach a click event listener to each "search-toggler" element
        searchTogglers.forEach((searchToggler) => {
            searchToggler.addEventListener("click", function (e) {
            e.preventDefault();
            
            // Toggle the class "active" on elements with the class "search-popup"
            const searchPopup = document.querySelector(".search-popup");
            if (searchPopup) {
                searchPopup.classList.toggle("active");
            }

            // Remove the class "expanded" from elements with the class "mobile-nav__wrapper"
            const mobileNavWrapper = document.querySelector(".mobile-nav-wrapper");
            if (mobileNavWrapper) {
                mobileNavWrapper.classList.remove("expanded");
            }
            });
        });

		document.querySelectorAll('#myTab3 .tablinks').forEach(function(everyitem){ 	
			var tabTrigger = new bootstrap.Tab(everyitem)
			everyitem.addEventListener('mouseenter', function(){
				tabTrigger.show();
			});
			
		});

    }

	//* Magnific popup
	$('.popup-youtube, .popup-vimeo, .popup-gmaps').magnificPopup({
		disableOn: 100,
		type: 'iframe',
		mainClass: 'mfp-fade',
		removalDelay: 160,
		preloader: false,
		fixedContentPos: false
	});

	const showPopupButton = $("#showPopup");
	const closePopupButton = $("#closePopup");
	const popup = $("#popup");

	showPopupButton.on('click', function() {
		popup.addClass("active");
	});

	closePopupButton.on('click', function() {
		popup.removeClass("active");
	});

	$('.popup-gallery').magnificPopup({
		delegate: 'a',
		type: 'image',
		tLoading: 'Loading image #%curr%...',
		mainClass: 'mfp-img-mobile',
		gallery: {
			enabled: true,
			navigateByImgClick: true,
			preload: [0,1] 
		},
		image: {
			tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',
			titleSrc: function(item) {
				return item.el.attr('title') + '<small>by Marsel Van Oosten</small>';
			}
		}
	});

    });

	$( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/global', function( $scope ) {

			// Main Banner JS
			let swipeOption = {
				loop: true,
				effect: 'fade',
				autoplay: {
					delay: 4000,
					disableOnInteraction: false,
					pauseOnMouseEnter: true,
				},
				speed: 2000,
				pagination: {
					el: '.swiper-pagination2',
					clickable: true,
				},
			}
			new Swiper('.hero-slider', swipeOption);

			// Academic Slider Js
			var swiper = new Swiper(".academic-slider", {
				slidesPerView: 1,
				spaceBetween: 20,
				rewind: true,
				loop: true,
				speed:1400,
				pagination: {
					el: ".swiper-pagination2",
					clickable: true,
				},
			});
			
			// Academic Slider Js
			var swiper = new Swiper(".places-slider", {
				slidesPerView: 3,
				spaceBetween: 0,
				rewind: true,
				loop: true,
				centeredSlides: true,
				speed:1400,
				breakpoints: {
					0: {
						slidesPerView: 1
					},
					576: {
						slidesPerView: 1
					},
					768: {
						slidesPerView: 2
					},
					992: {
						slidesPerView: 3
					},
					1200: {
						slidesPerView: 3
					}
				}
			});

			// Review Slider Js
			var swiper = new Swiper(".review-slider", {
				slidesPerView: 3,
				spaceBetween: 30,
				rewind: true,
				loop: false,
				speed:1400,
				pagination: {
					el: ".swiper-pagination1",
					type: "progressbar",
				},
				breakpoints: {
					0: {
						slidesPerView: 1
					},
					576: {
						slidesPerView: 1
					},
					768: {
						slidesPerView: 2
					},
					992: {
						slidesPerView: 3
					},
					1200: {
						slidesPerView: 3
					}
				}
			});

			// Academic Slider Js
			var swiper = new Swiper(".event-slider", {
				slidesPerView: 2,
				spaceBetween: 20,
				loop: false,
				speed:1400,
				pagination: {
					el: ".swiper-pagination3",
					clickable: true,
				},
				breakpoints: {
					0: {
						slidesPerView: 1
					},
					576: {
						slidesPerView: 1
					},
					768: {
						slidesPerView: 2
					},
					992: {
						slidesPerView: 2
					},
					1200: {
						slidesPerView: 2
					}
				}
			});

			// Event Plan Slider Js
			var swiper = new Swiper(".event-plan-slider", {
				slidesPerView: 3,
				spaceBetween: 24,
				loop: true,
				speed:1400,
				navigation: {
					nextEl: ".sswiper-button-next",
					prevEl: ".sswiper-button-prev",
				},
				speed:1400,
				breakpoints: {
					0: {
						slidesPerView: 1
					},
					576: {
						slidesPerView: 1
					},
					768: {
						slidesPerView: 2
					},
					992: {
						slidesPerView: 3
					},
					1200: {
						slidesPerView: 3
					}
				}
			});

			// Event Plan Slider Js
			var swiper = new Swiper(".optional-event-slider", {
				slidesPerView: 3,
				spaceBetween: 5,
				loop: true,
				breakpoints: {
					0: {
						slidesPerView: 1
					},
					576: {
						slidesPerView: 1
					},
					768: {
						slidesPerView: 2
					},
					992: {
						slidesPerView: 3
					},
					1200: {
						slidesPerView: 3
					}
				}
			});

			// Campus Slider Js
			var swiper = new Swiper(".campus-slider", {
				slidesPerView: 2,
				spaceBetween: 10,
				loop: true,
				speed:1400,
				breakpoints: {
					0: {
						slidesPerView: 1
					},
					576: {
						slidesPerView: 1
					},
					768: {
						slidesPerView: 1
					},
					992: {
						slidesPerView: 2
					},
					1200: {
						slidesPerView: 2
					}
				}
			});

			// Management Slider Js
			var swiper = new Swiper(".management-slider", {
				slidesPerView: 5,
				spaceBetween: 24,
				loop: true,
				speed:1400,
				navigation: {
					nextEl: ".swiper-button-next",
					prevEl: ".swiper-button-prev",
				},
				breakpoints: {
					0: {
						slidesPerView: 1
					},
					576: {
						slidesPerView: 1
					},
					768: {
						slidesPerView: 3
					},
					992: {
						slidesPerView: 3
					},
					1200: {
						slidesPerView: 5
					}
				}
			});

			// History Slider Js
			var swiper = new Swiper(".history-slider", {
				slidesPerView: 5,
				spaceBetween: 22,
				loop: true,
				speed:1400,
				breakpoints: {
					0: {
						slidesPerView: 1
					},
					576: {
						slidesPerView: 1
					},
					768: {
						slidesPerView: 2
					},
					992: {
						slidesPerView: 4
					},
					1200: {
						slidesPerView: 5
					}
				}
			});

			// Four Popular Slider Js
			var swiper = new Swiper(".four-popular-slider", {
				slidesPerView: 4,
				spaceBetween: 24,
				loop: false,
				speed:1400,
				navigation: {
					nextEl: ".swiper-button-next",
					prevEl: ".swiper-button-prev",
				},
				pagination: {
					el: ".swiper-pagination",
					clickable: true,
					renderBullet: function (index, className) {
					  return '<span class="' + className + '">' + (index + 1) + "</span>";
					},
				},
				breakpoints: {
					0: {
						slidesPerView: 1
					},
					576: {
						slidesPerView: 1
					},
					768: {
						slidesPerView: 3
					},
					992: {
						slidesPerView: 3
					},
					1200: {
						slidesPerView: 4
					}
				}
			});

			// Partner Slider Js
			var swiper = new Swiper(".partner-slider", {
				slidesPerView: 7,
				spaceBetween: 24,
				loop: false,
				speed:1400,
				breakpoints: {
					0: {
						slidesPerView: 1
					},
					576: {
						slidesPerView: 1
					},
					768: {
						slidesPerView: 3
					},
					992: {
						slidesPerView: 4
					},
					1200: {
						slidesPerView: 7
					}
				}
			});

			// Event Contest Slider Js
			var swiper = new Swiper(".contest-slider", {
				slidesPerView: 2,
				spaceBetween: 24,
				loop: true,
				speed:1400,
				pagination: {
					el: ".swiper-pagination3",
					clickable: true,
				},
				breakpoints: {
					0: {
						slidesPerView: 1
					},
					576: {
						slidesPerView: 1
					},
					768: {
						slidesPerView: 2
					},
					992: {
						slidesPerView: 2
					},
					1200: {
						slidesPerView: 2
					}
				}
			});

			// Four Popular Slider Js
			var swiper = new Swiper(".home-five-hero-slider", {
				spaceBetween: 24,
				loop: false,
				speed:1400,
				navigation: {
					nextEl: ".swiper-button-next",
					prevEl: ".swiper-button-prev",
				},
				pagination: {
					el: ".swiper-pagination",
					clickable: true,
					renderBullet: function (index, className) {
					  return '<span class="' + className + '">' + (index + 1) + "</span>";
					},
				},
			});

			// Four Popular Slider Js
			var swiper = new Swiper(".five-popular-slider", {
				slidesPerView: 4,
				spaceBetween: 24,
				loop: false,
				speed:1400,
				navigation: {
					nextEl: ".swiper-button-next",
					prevEl: ".swiper-button-prev",
				},
				pagination: {
					el: ".swiper-pagination5",
					clickable: true,
					renderBullet: function (index, className) {
					  return '<span class="' + className + '">' + (index + 1) + "</span>";
					},
				},
				breakpoints: {
					0: {
						slidesPerView: 1
					},
					576: {
						slidesPerView: 1
					},
					768: {
						slidesPerView: 3
					},
					992: {
						slidesPerView: 3
					},
					1200: {
						slidesPerView: 4
					}
				}
			});

			// Five Upcoming Slider Js
			var swiper = new Swiper(".five-upcoming-slider", {
				spaceBetween: 24,
				loop: true,
				speed:1400,
				navigation: {
					nextEl: ".swiper-button-next",
					prevEl: ".swiper-button-prev",
				},
				breakpoints: {
					0: {
						slidesPerView: 1
					},
					576: {
						slidesPerView: 1
					},
					768: {
						slidesPerView: 2
					},
					992: {
						slidesPerView: 2
					},
					1200: {
						slidesPerView: 2
					}
				}
			});
		
		});

	});

	// Preloader
	$(window).on('load', function() {
		$('.preloader').addClass('preloader-deactivate');
	})


	// Go to Top
	$(function(){
		// Scroll Event
		$(window).on('scroll', function(){
			var scrolled = $(window).scrollTop();
			if (scrolled > 100) $('.go-top').addClass('active');
			if (scrolled < 100) $('.go-top').removeClass('active'); 
		});  
		// Click Event
		$('.go-top').on('click', function() {
			$("html, body").animate({ scrollTop: "0" },  100);
		});
	});


}(jQuery));


// Sidebar Menu
(function($) {
    $(document).ready(function() {
        'use strict';

        // Check screen width before executing
        if ($(window).width() <= 991) {
            $('.navbar-nav li.menu-item-has-children > a').on('click', function() {
                $(this).removeAttr('href');
                var element = $(this).parent('li');
                if (element.hasClass('open')) {
                    element.removeClass('open');
                    element.find('li').removeClass('open');
                    element.find('ul').slideUp();
                } else {
                    element.addClass('open');
                    element.children('ul').slideDown();
                    element.siblings('li').children('ul').slideUp();
                    element.siblings('li').removeClass('open');
                    element.siblings('li').find('li').removeClass('open');
                    element.siblings('li').find('ul').slideUp();
                }
            });

            $('.navbar-nav > ul > li.menu-item-has-children > a').append('<span class="holder"></span>');

            function rgbToHsl(r, g, b) {
                r /= 255, g /= 255, b /= 255;
                var max = Math.max(r, g, b),
                    min = Math.min(r, g, b);
                var h, s, l = (max + min) / 2;

                if (max == min) {
                    h = s = 0;
                } else {
                    var d = max - min;
                    s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
                    switch (max) {
                        case r:
                            h = (g - b) / d + (g < b ? 6 : 0);
                            break;
                        case g:
                            h = (b - r) / d + 2;
                            break;
                        case b:
                            h = (r - g) / d + 4;
                            break;
                    }
                    h /= 6;
                }
                return l;
            }
        }
    });
})(jQuery);
