<?php
/**
 * Falar functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Falar
 */

 define('FALAR_VERSION', time());
 define('FALAR_THEME_URI', get_template_directory_uri());
 define('FALAR_THEME_DIR', get_template_directory());
 define('FALAR_IMG',FALAR_THEME_URI . '/assets/img');
 define('FALAR_CSS',FALAR_THEME_URI . '/assets/css');
 define('FALAR_JS',FALAR_THEME_URI . '/assets/js');
 define('FALAR_FONTS',FALAR_THEME_URI . '/assets/fonts');
 
 if( !defined('FALAR_FRAMEWORK_VAR') ) define('FALAR_FRAMEWORK_VAR', 'falar_opt');
 

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function falar_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on Falar, use a find and replace
		* to change 'falar' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'falar', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support( 'post-thumbnails' );

	// Falar image size
	add_image_size( 'falar_post_thumb', 410, 410, true );
	add_image_size( 'falar_post_thumb_Two', 415, 340, true );
	add_image_size( 'falar_post_thumb_Three', 306, 360, true );

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);
}
add_action( 'after_setup_theme', 'falar_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function falar_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'falar_content_width', 640 );
}
add_action( 'after_setup_theme', 'falar_content_width', 0 );


/**
 * Enqueue scripts and styles.
 */
function falar_scripts() {
	global $falar_opt;

		// Enqueue styles	
		wp_enqueue_style( 'falar-style', get_stylesheet_uri() );
		wp_style_add_data( 'falar-style', 'rtl', 'replace' );
		
		wp_enqueue_style( 'bootstrap', 					FALAR_CSS . '/bootstrap.min.css', null, FALAR_VERSION );
		wp_enqueue_style( 'swiper-bundle', 				FALAR_CSS . '/swiper-bundle.min.css', null, FALAR_VERSION );
		wp_enqueue_style( 'scrollCue', 			        FALAR_CSS . '/scrollCue.css', null, FALAR_VERSION );
		wp_enqueue_style( 'tabler-icons', 			    FALAR_CSS . '/tabler-icons.css', null, FALAR_VERSION );
		wp_enqueue_style( 'magnific-popup', 			FALAR_CSS . '/magnific-popup.css', null, FALAR_VERSION );
		wp_enqueue_style( 'remixicon', 			        FALAR_CSS . '/remixicon.css', null, FALAR_VERSION );

		if( falar_rtl() == true ):
			wp_enqueue_style( 'rtl-woocommerce',   get_template_directory_uri() . '/assets/css/rtl/rtl-falar-woocommerce.css', null, FALAR_VERSION);
			wp_enqueue_style( 'falar-main-style',    get_template_directory_uri() . '/assets/css/rtl/rtl-falar-main-style.css', null, null);
			wp_enqueue_style( 'falar-blog',          get_template_directory_uri() . '/assets/css/rtl/rtl-falar-blog.css', null, FALAR_VERSION);
			wp_enqueue_style( 'falar-responsive',    get_template_directory_uri() . '/assets/css/rtl/rtl-falar-main-responsive.css', null, FALAR_VERSION);
		else:
			wp_enqueue_style( 'woocommerce', 			    FALAR_CSS . '/falar-woocommerce.css', null, FALAR_VERSION );
			#wp_enqueue_style( 'falar-main-style', 			FALAR_CSS . '/falar-main-style.css', null, FALAR_VERSION );
			wp_enqueue_style( 'falar-main-style', 			FALAR_CSS . '/falar-main-style.css', null, null );
			wp_enqueue_style( 'falar-blog',		            FALAR_CSS . '/falar-blog.css', null, FALAR_VERSION );
			wp_enqueue_style( 'falar-main-responsive', 		FALAR_CSS . '/falar-main-responsive.css', null, FALAR_VERSION );
		endif;

		// RTL CSS
		if( falar_rtl() == true ):
			wp_enqueue_style( 'falar-rtl', get_template_directory_uri() . '/style-rtl.css' );
		endif;

		// Enqueue scripts
		wp_enqueue_script( 'bootstrap-bundle', 			FALAR_JS . '/bootstrap.bundle.min.js', array('jquery'), FALAR_VERSION );
		wp_enqueue_script( 'swiper-bundle', 		    FALAR_JS . '/swiper-bundle.min.js', array('jquery'), FALAR_VERSION );
		wp_enqueue_script( 'ajaxchimp', 		        FALAR_JS . '/ajaxchimp.min.js', array('jquery'), FALAR_VERSION );
		wp_enqueue_script( 'magnific-popup', 		    FALAR_JS . '/jquery.magnific-popup.js', array('jquery'), FALAR_VERSION );
		wp_enqueue_script( 'scrollCue', 		        FALAR_JS . '/scrollCue.min.js', array('jquery'), FALAR_VERSION );
		wp_enqueue_script( 'falar-main', 		        FALAR_JS . '/falar-main.js', array('jquery'), FALAR_VERSION );
	

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'falar_scripts' );

if ( ! function_exists( 'falar_fonts' ) ) {
	function falar_fonts() {
		wp_enqueue_style( 'falar-work-sans', "https://fonts.googleapis.com/css2?family=Work+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap", '', '1.0.0', 'screen' );
		wp_enqueue_style( 'falar-inter', "https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap", '', '1.0.0', 'screen' );
		wp_enqueue_style( 'falar-alfa', "https://fonts.googleapis.com/css2?family=Alfa+Slab+One&display=swap", '', '1.0.0', 'screen' );
	}
}
add_action( 'wp_enqueue_scripts', 'falar_fonts' );

/**
 * Primary Menu
 */
if ( ! function_exists( 'falar_register_primary_menus' ) ) :
	function falar_register_primary_menus(){
		register_nav_menus(
			array(
				'primary' 		    => esc_html__('Primary Menu', 'falar'),
				'left_menu' 		=> esc_html__('Left Menu', 'falar'),
				'right_menu' 		=> esc_html__('Right Menu', 'falar'),
			)
		);
	}
endif;
add_action('init', 'falar_register_primary_menus');

/**
 * If page edited by elementor
 */
if ( ! function_exists( 'falar_is_elementor' ) ) :
	function falar_is_elementor(){
		if ( function_exists( 'elementor_fail_php_version' ) ):
			global $post;
			if( $post != '' ):
				return \Elementor\Plugin::$instance->documents->get($post->ID)->is_built_with_elementor();
			endif;
		endif;
	}
endif;

/**
 * Excerpt more text
 */
if ( ! function_exists( 'falar_excerpt_more' ) ) :
	function falar_excerpt_more( $more ) {
		return ' ';
	}
endif;
add_filter('excerpt_more', 'falar_excerpt_more');

/**
 * Filter the categories widget to add a span around post count
 */
if ( ! function_exists( 'falar_cat_count_span' ) ) {
	function falar_cat_count_span( $links ) {
		$links = str_replace( '</a> (', '</a><span class="post-count">(', $links );
		$links = str_replace( ')', ')</span>', $links );
		return $links;
	}
}
add_filter( 'wp_list_categories', 'falar_cat_count_span' );

// Load WooCommerce compatibility file.
if ( class_exists( 'WooCommerce' ) ) {
	require get_template_directory() . '/inc/woocommerce.php';
}

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

/**
 * Recommended
 */
require FALAR_THEME_DIR. '/lib/recommended-plugin.php';

/**
 * Load bootstrap navwalker
 */
require FALAR_THEME_DIR. '/inc/bootstrap-navwalker.php';

/**
 * Social link
*/
require FALAR_THEME_DIR. '/inc/social-link.php';

/**
 * Header content
*/
require FALAR_THEME_DIR. '/template-parts/header.php';

/**
 * Footer content
*/
require FALAR_THEME_DIR. '/template-parts/footer.php';

/**
 * Single content
*/
require FALAR_THEME_DIR. '/template-parts/single.php';

/**
 * Search content
*/
require FALAR_THEME_DIR. '/template-parts/search.php';

/**
 * Archive content
*/
require FALAR_THEME_DIR. '/template-parts/archive.php';
/**
 * Event Cat content
*/
require FALAR_THEME_DIR. '/template-parts/taxonomy-events_cat.php';

/**
 * Single Events content
*/
require FALAR_THEME_DIR. '/template-parts/single-events.php';

/**
 * Single Program content
*/
require FALAR_THEME_DIR. '/template-parts/single-program.php';

/**
 * Single Career content
*/
require FALAR_THEME_DIR. '/template-parts/single-career.php';

/**
 * Single Index content
*/
require FALAR_THEME_DIR. '/template-parts/index.php';

/**
 * Error content
*/
require FALAR_THEME_DIR. '/inc/404.php';


/**
 * Widget
 */
require FALAR_THEME_DIR. '/inc/widget.php';

/**
 * Custom style
 */
require FALAR_THEME_DIR. '/inc/custom-style.php';

/**
 * Admin dashboard style and scripts
 */
add_action( 'admin_enqueue_scripts', function() {
    global $pagenow;
    wp_enqueue_script( 'falar-admin', FALAR_JS .'/toolkit-admin.js', array('jquery'), '1.0.0', true );
    if ( $pagenow == 'admin.php' || $pagenow == 'themes.php') {
		wp_enqueue_style( 'falar-admin-dashboard', FALAR_CSS .'/admin-dashboard.min.css' );
    }
});