<?php
/**
 * Error Content
 * @package WordPress
 * @subpackage Falar
*/
if ( ! function_exists( 'falar_theme_error_content' ) ) {
	function falar_theme_error_content() {
        
        global $falar_opt;

        if ( isset( $falar_opt['error_title_not_found'] ) ):
            $title 			= $falar_opt['error_title_not_found'];
            $content 		= $falar_opt['content_not_found'];
            $button 		= $falar_opt['button_not_found'];
        endif;
        
        // Blog breadcrumb
        if( isset($falar_opt['error_title_not_found']) ) {
            $hide_banner_title  = $falar_opt['hide_banner_title'];
            $hide_breadcrumb    = $falar_opt['hide_error_breadcrumb'];
            $hide_error_banner  = $falar_opt['hide_error_banner'];
            $error_banner_shape = $falar_opt['error_banner_shape']['url'];
        } else {
            $hide_banner_title  = false;
            $hide_breadcrumb    = false;
            $hide_error_banner  = false;
            $error_banner_shape = false;
        }
        
        if( isset($falar_opt['page_title_tag']) ):
            $tag = $falar_opt['page_title_tag'];
        else:
            $tag = 'h2';
        endif;
        
        if(isset($falar_opt['error_image']['url'])):
            $error_image	= $falar_opt['error_image']['url'];
        else:
            $error_image	= '';
        endif;
        ?>
        
        <?php if( $hide_error_banner == false ): ?>
            <div class="inner-heros-warp">
                <div class="container-fluid">
                    <div class="inner-hero-content">
                        <?php if( $hide_banner_title == false ): ?>
                            <?php if($title): ?>
                                <?php if( isset($tag) ): ?>
                                    <<?php echo esc_attr( $tag ); ?>><?php echo esc_html( $title ); ?></<?php echo esc_attr( $tag ); ?>>
                                <?php else: ?>
                                    <<?php echo esc_attr( $tag ); ?>><?php esc_html_e('No Title', 'falar'); ?></<?php echo esc_attr( $tag ); ?>>
                                <?php endif; ?>
                                <?php else: ?>
                                    <h2><?php echo esc_html__('404 Error', 'falar'); ?></h2>
                            <?php endif; ?>
                        <?php endif; ?>

                        <?php if( $hide_breadcrumb == false ): ?>
                            <?php
                                if ( function_exists('yoast_breadcrumb') ) {
                                    yoast_breadcrumb( '<p class="falar-seo-breadcrumbs" id="breadcrumbs">','</p>' );
                                } else { ?>
                                    <ul class="inner-hero-list">
                                        <li class="d-inline-block position-relative text-uppercase"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'falar' ); ?></a></li>
                                        <?php if( $title != '' ): ?>
                                            <li class="d-inline-block position-relative text-uppercase active"><?php echo esc_html( $title ); ?></li>
                                            <?php else: ?>
                                                <li class="d-inline-block position-relative text-uppercase active"><?php echo esc_html_e( '404 Error', 'falar' ); ?></li>
                                        <?php endif; ?>
                                    </ul>                       
                                <?php
                            }
                        endif; 
                        ?>
                    </div>
                </div>
                <div class="all-shapes">
                    <?php if($error_banner_shape):  ?>
                        <img src="<?php echo esc_url($error_banner_shape) ?>" class="inner-page-shape1" alt="<?php echo esc_attr__( 'images', 'falar' ); ?>">
                        <?php else: ?>
                            <img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/inner-page-shape1.png') ?>" class="inner-page-shape1" alt="Shape">
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        
        <div class="not-found-area ptb-100">
            <div class="container">
                <?php if($title && $button != '' ): ?>
                    <div class="not-found-content text-center">  
                        <?php if($error_image): ?>
                            <div class="image">
                                <img src="<?php echo esc_url($error_image) ?>" alt="<?php echo esc_attr__( 'images', 'falar' ); ?>">
                            </div>
                        <?php endif; ?>
                        <h3><?php echo wp_kses( $title, 'falarallowedhtml' ); ?></h3> 
                        <?php if(  $content != '' ): ?>
                            <p class="ms-auto me-auto fw-medium"><?php echo esc_html($content); ?></p>
                        <?php endif; ?>
                        <?php if(  $button != '' ): ?>
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="default-btn">
                                <?php echo esc_html( $button ); ?>
                            </a>
                        <?php endif; ?>
                    </div> 
                <?php else: ?>
                    <div class="not-found-content text-center">
                        <h3><?php echo wp_kses('Oops! That page can nott be found', 'falarallowedhtml' ); ?></h3>
                        <p class="ms-auto me-auto fw-medium"><?php echo wp_kses('The page you are looking for might have been removed had its name changed or is temporarily unavailable.', 'falarallowedhtml' ); ?></p>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="default-btn fw-light position-relative d-inline-block text-decoration-none z-1 text-center">
                            <?php echo wp_kses('Back To Home', 'falarallowedhtml'); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <?php
    }
}