<?php
/**
 * Register custom style.
 */

if ( ! function_exists( 'falar_custom_style' ) ) {
    function falar_custom_style(){

        $custom_style ='';
            global $falar_opt;

            if( isset( $falar_opt['blog_title'] ) ):
                $body_bg                         = $falar_opt['body_bg'];
                $primary_color                   = $falar_opt['primary_color'];
                $secondary_color                 = $falar_opt['secondary_color'];
                $yellow_color                    = $falar_opt['yellow_color'];
                $heading_color                   = $falar_opt['heading_color'];
                $white_color                     = $falar_opt['white_color'];
                $paragraph_color                 = $falar_opt['paragraph_color'];

                $nav_bg                          = $falar_opt['nav_bg'];
                $nav_item_color                  = $falar_opt['nav_item_color'];
                $top_header_item_color           = $falar_opt['top_header_item_color'];
                $fot_title                       = $falar_opt['fot_title'];
                $fot_content                     = $falar_opt['fot_content'];
                $primary_typography              = $falar_opt['primary_typography']['font-family'];
                $secondary_typography            = $falar_opt['secondary_typography']['font-family'];
            else:
                $body_bg                         = '#ffffff';
                $primary_color                   = '#FC6441';
                $secondary_color                 = '#7768E5';
                $yellow_color                    = '#F8CA4D';
                $heading_color                   = '#0D0D25';
                $white_color                     = '#ffffff';
                $paragraph_color                 = '#525271';
                
                $nav_bg                          = '#ffffff';
                $nav_item_color                  = '#0D0D25';
                $top_header_item_color           = '#525271';
                $fot_title                       = '#ffffff';
                $fot_content                     = '#C5C5CF';
                $primary_typography              = '';
                $secondary_typography            = '';
            endif;

            $custom_style .='
            :root {
                --primaryColor: '.esc_attr($primary_color).';
                --secondaryColor: '.esc_attr($secondary_color).';
                --yellowColor: '.esc_attr($yellow_color).';
                --blackColor: '.esc_attr($heading_color).';
                --whiteColor: '.esc_attr($white_color).';
                --paragraphColor: '.esc_attr($paragraph_color).';
                ';
                if($primary_typography): $custom_style .='
                --heading-fontFamily: '.wp_kses($primary_typography, 'falarallowedhtml').';';
                endif;
                if($secondary_typography): $custom_style .='
                --main-fontFamily: '.wp_kses($secondary_typography, 'falarallowedhtml').';';
                endif;

                $custom_style .='
            } ';

            $custom_style .='

            body { background-color: '.esc_attr($body_bg).'; }
            .widget_rss ul li a:hover { color: '.esc_attr($primary_color).' !important; }

            .navbar { background-color: '.esc_attr($nav_bg).' }
            .navbar .navbar-nav .nav-item .nav-link, .navbar .navbar-nav .nav-item .dropdown-toggle::before { color: '.esc_attr($nav_item_color).' ; }
            .top-header-link-details .header-link li a, .top-header-details .header-contact li a, .top-header-link-details .header-account li:last-child a{ color: '.esc_attr($top_header_item_color).' ; }
            .footer-widget h3, .footer-widget h2, .footer-widget h4 { color: '.esc_attr($fot_title).' ; }
            .footer-widget.widget_nav_menu ul li, .footer-widget.widget_nav_menu ul li a, .footer-widget p .footer-widget span, .footer-widget ul li a, .copy-right-warp .copy-right-content p  { color: '.esc_attr($fot_content).' ; }';
            
            // Hide Sticky Header
            if(isset($falar_opt['enable_sticky_header']) && $falar_opt['enable_sticky_header'] == false){ $custom_style .='
                .navbar-area.is-sticky {
                    display:none !important;
                }';
            }

            // Custom Css
            if( isset($falar_opt['css_code'] ) && !empty($falar_opt['css_code']) ):
                $custom_style .= $falar_opt['css_code'];
            endif;

            if( is_user_logged_in() ){
                $custom_style .=' .comments-area .comment-respond .form-submit {
                    margin-top: 20px;
                }';
            }

            wp_add_inline_style('falar-blog', $custom_style);

            // Custom Js
            $custom_script ='';
            if( isset($falar_opt['js_code'] )){
                $custom_script .= $falar_opt['js_code'];
            }

            wp_add_inline_script( 'falar-main', $custom_script );
    }
}
add_action( 'wp_enqueue_scripts', 'falar_custom_style' );