<?php
/**
 * Social Link
 * @package WordPress
 * @subpackage Falar
*/

if ( ! function_exists( 'falar_social_link' ) ) :
    function falar_social_link(){
        global $falar_opt;

        if( isset( $falar_opt['falar_social_target'] ) ) {
            $target = $falar_opt['falar_social_target'];
        }else {
            $target = '_blank';
        }
        ?>
            <?php if (isset($falar_opt['twitch_url'] ) && $falar_opt['twitch_url']) { ?>
                <li>
                    <a class="d-block twitch" target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['twitch_url']); ?>"> <i class="ri-twitch-fill"></i></a>
                </li>
            <?php  } ?>
            
            <?php if (isset($falar_opt['facebook_url'] ) && $falar_opt['facebook_url']) { ?>
                <li>
                    <a class="d-block facebook" target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['facebook_url']); ?>"> <img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/facebook.svg') ?>" alt="Icon"></a>
                </li>
            <?php  } ?>

            <?php if (isset($falar_opt['twitter_url'] ) && $falar_opt['twitter_url']) { ?>
                <li>
                    <a class="d-block twitter" target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['twitter_url']);?>">  <img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/twitter.svg') ?>" alt="Icon"></a>
                </li>
            <?php  } ?>

            <?php if (isset($falar_opt['tiktok_url'] ) && $falar_opt['tiktok_url'] ) { ?>
                <li>
                    <a class="d-block" target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['tiktok_url']);?>" > <i class="ri-tiktok-line"></i></a>
                </li>
            <?php } ?>

            <?php if (isset($falar_opt['vimeo_url'] ) && $falar_opt['vimeo_url'] ) { ?>
                <li>
                    <a class="d-block vimeo" target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['vimeo_url']); ?>"><i class="ri-vimeo-line"></i></a>
                </li>
            <?php  } ?>

            <?php if (isset($falar_opt['instagram_url'] ) && $falar_opt['instagram_url'] ) { ?>
                <li>
                    <a class="d-block instagram" target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['instagram_url']); ?>"><img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/instagram.svg') ?>" alt="Icon"></a>
                </li>
            <?php  } ?>

            <?php
            if (isset($falar_opt['linkedin_url'] ) && $falar_opt['linkedin_url'] ) { ?>
            <li>
                <a class="d-block" target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['linkedin_url']);?>" ><img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/linkedin.svg') ?>" alt="Icon"></a>
            </li>
            <?php  } ?>

            <?php
            if (isset($falar_opt['youtube_url'] ) && $falar_opt['youtube_url'] ) { ?>
            <li>
                <a class="d-block" target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['youtube_url']);?>" > <img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/youtube.svg') ?>" alt="Icon"></a>
            </li>
            <?php  } ?>

            <?php
            if (isset($falar_opt['pinterest_url'] ) && $falar_opt['pinterest_url'] ) { ?>
            <li>
                <a class="d-block" target="<?php echo esc_attr($target); ?>" href="<?php echo esc_url($falar_opt['pinterest_url']);?>" ><i class="fa-brands fa-pinterest"></i></a>
            </li>
            <?php  } ?>

            <?php if (isset($falar_opt['dribbble_url'] ) && $falar_opt['dribbble_url'] ) { ?>
                <li>
                    <a class="d-block" target="<?php echo esc_attr($target); ?>" href="<?php echo esc_url($falar_opt['dribbble_url']);?>" ><i class="ri-pinterest-fill"></i></a>
                </li>
            <?php } ?>

            <?php if (isset($falar_opt['tumblr_url'] ) && $falar_opt['tumblr_url'] ) { ?>
                <li>
                    <a class="d-block" target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['tumblr_url']);?>" > <i class="ri-tumblr-fill"></i></a>
                </li>
            <?php } ?>

            <?php if (isset($falar_opt['behance_url'] ) && $falar_opt['behance_url'] ) { ?>
                <li>
                    <a class="d-block" target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['behance_url']);?>" > <i class="ri-behance-fill"></i></a>
                </li>
            <?php } ?>

            <?php if (isset($falar_opt['github_url'] ) &&  $falar_opt['github_url'] ) { ?>
                <li>
                    <a class="d-block" target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['github_url']);?>" > <i class="ri-github-fill"></i></a>
                </li>
            <?php } ?>

            <?php if (isset($falar_opt['skype_url'] ) && $falar_opt['skype_url'] ) { ?>
                <li>
                    <a class="d-block" target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['skype_url']);?>" > <i class="ri-skype-fill"></i></a>
                </li>
            <?php } ?>
            <?php if (isset($falar_opt['google_url'] ) && $falar_opt['google_url'] ) { ?>
                <li>
                    <a class="d-block" target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['google_url']);?>" > <i class="ri-google-fill"></i></a>
                </li>
            <?php } ?>

            <?php if (isset($falar_opt['rss_url'] ) && $falar_opt['rss_url'] ) { ?>
                <li>
                    <a class="d-block" target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['rss_url']);?>" > <i class="ri-rss-fill"></i></a>
                </li>
            <?php } ?>
    <?php
    }
endif; ?>