<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Falar
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function falar_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'falar_body_classes' );

/**
 * Falar Preloader
*/
if ( ! function_exists( 'falar_preloader' ) ) :
	function falar_preloader() {
		global $falar_opt;

		if( isset( $falar_opt['enable_preloader'] ) ):
			$is_preloader = $falar_opt['enable_preloader'];
		else:
			$is_preloader = true;
		endif;

		$is_preloader       = !empty($falar_opt['enable_preloader']) ? $falar_opt['enable_preloader'] : '';
        $preloader_style    = !empty($falar_opt['preloader_style']) ? $falar_opt['preloader_style'] : 'circle-spin';

        if( $is_preloader == true ):
            if ( defined( 'ELEMENTOR_VERSION' ) ) :
                if (\Elementor\Plugin::$instance->preview->is_preview_mode()) :
                    echo '';
                else:
                    if ( $preloader_style == 'text' ) :
                        if (!empty( $falar_opt['loading_text'] ) ) : ?>
                            <div class="preloader-area preloader position-fixed text-center" id="preloader">
								<div class="loader">
									<div class="waviy">
										<span class="d-inline-block"><?php echo esc_html( $falar_opt['loading_text'] ) ?></span>
										<span class="d-inline-block"><?php echo esc_html( $falar_opt['loading_text2'] ) ?></span>
										<span class="d-inline-block"><?php echo esc_html( $falar_opt['loading_text3'] ) ?></span>
										<span class="d-inline-block"><?php echo esc_html( $falar_opt['loading_text4'] ) ?></span>
										<span class="d-inline-block"><?php echo esc_html( $falar_opt['loading_text5'] ) ?></span>
										<span class="d-inline-block"><?php echo esc_html( $falar_opt['loading_text6'] ) ?></span>
										<span class="d-inline-block"><?php echo esc_html( $falar_opt['loading_text7'] ) ?></span>
									</div>
                                </div>
                            </div>
                        <?php endif;
                    elseif( $preloader_style == 'circle-spin' ) : ?>
                        <div class="preloader text-center position-fixed top-0 bottom-0 start-0 end-0" id="preloader">
							<div class="lds-ripple">
								<div class="preloader-container">
									<div class="petal"></div>
									<div class="petal"></div>
									<div class="petal"></div>
									<div class="petal"></div>
									<div class="petal"></div>
									<div class="petal"></div>
									<div class="petal"></div>
									<div class="petal"></div>
									<div class="petal-1"></div>
									<div class="petal-1"></div>
									<div class="petal-1"></div>
									<div class="ball"></div>
								</div>
							</div>
						</div>
                    <?php else: ?>
                        <div class="preloader-area position-fixed text-center preloader-img" id="preloader">
							<div class="pre-image">
								<img src="<?php echo esc_url($falar_opt['preloader_image']['url']) ?>" alt="">
							</div>
                        </div>
                    <?php endif;
                endif;
            else:
                if ( $preloader_style == 'text' ) :
                    if (!empty( $falar_opt['loading_text'] ) ) : ?>
                        <div class="preloader preloader-text">
                            <div class="loader">
                                <p class="text-center"> <?php echo esc_html( $falar_opt['loading_text'] ) ?> </p>
                            </div>
                        </div>
                    <?php endif;
                elseif( $preloader_style == 'circle-spin' ) :
                    ?>
                    <div class="preloader spin">
						<div class="lds-ripple">
							<div class="preloader-container">
								<div class="petal"></div>
								<div class="petal"></div>
								<div class="petal"></div>
								<div class="petal"></div>
								<div class="petal"></div>
								<div class="petal"></div>
								<div class="petal"></div>
								<div class="petal"></div>
								<div class="petal-1"></div>
								<div class="petal-1"></div>
								<div class="petal-1"></div>
								<div class="ball"></div>
							</div>
						</div>
					</div>
                <?php else : ?>
                    <div class="preloader preloader-img">
                        <div class="loader">
						<img src="<?php echo esc_url($falar_opt['preloader_image']['url']) ?>" alt="">
						</div>
                    </div>
                    <?php
                endif;
            endif;
        endif;
	}
endif;

/**
 * Falar Back To Top
*/
if ( ! function_exists( 'falar_footer_back_to_top' ) ) {
	function falar_footer_back_to_top() {
		global $falar_opt;
		if( isset( $falar_opt['copyright_text'] )):
			$enable_back_to_top 	= $falar_opt['enable_back_to_top'];
		else:
			$enable_back_to_top 	= true;
		endif;
		?>
		<?php if( $enable_back_to_top == true ):?>
			<button type="button" id="backtotop" class="go-top position-fixed text-center border-0 p-0">
				<i class="ti ti-arrow-move-up"></i>
        	</button>
		<?php endif;
	}
}

if ( ! function_exists( 'falar_post_reading_time' ) ) {
	function falar_post_reading_time(){
		global $falar_opt;
		$reading_time_text	= isset($falar_opt['post_reading_time']) ? $falar_opt['post_reading_time'] : 'min read';
		
		if($reading_time_text):
			$content = get_post_field( 'post_content', get_the_ID() );
			$word_count = str_word_count( strip_tags( $content ) );
			$reading_time = ceil( $word_count / 200 ); 
			
			if ( $reading_time == 1 ) {
				$reading_text = "1 $reading_time_text";
			} else {
				$reading_text = "$reading_time $reading_time_text";
			}
			return $reading_text;
		endif;
    }
}

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function falar_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'falar_pingback_header' );

/**
 * Falar Allowed HTML
 */
if ( ! function_exists( 'falar_kses_allowed_html' ) ) :
	function falar_kses_allowed_html($tags, $context) {
		$allowed_atts = array(
			'align'      => array(),
			'class'      => array(),
			'type'       => array(),
			'id'         => array(),
			'dir'        => array(),
			'lang'       => array(),
			'style'      => array(),
			'xml:lang'   => array(),
			'src'        => array(),
			'alt'        => array(),
			'href'       => array(),
			'rel'        => array(),
			'rev'        => array(),
			'target'     => array(),
			'novalidate' => array(),
			'type'       => array(),
			'value'      => array(),
			'name'       => array(),
			'tabindex'   => array(),
			'action'     => array(),
			'method'     => array(),
			'for'        => array(),
			'width'      => array(),
			'height'     => array(),
			'data'       => array(),
			'title'      => array(),
		);
		switch($context) {
		case 'falarallowedhtml':
			$tags = array(
				'form'    => $allowed_atts,
				'label'   => $allowed_atts,
				'input'   => $allowed_atts,
				'textarea'=> $allowed_atts,
				'iframe'  => $allowed_atts,
				'script'  => $allowed_atts,
				'style'   => $allowed_atts,
				'strong'  => $allowed_atts,
				'small'   => $allowed_atts,
				'table'   => $allowed_atts,
				'span'    => $allowed_atts,
				'abbr'    => $allowed_atts,
				'code'    => $allowed_atts,
				'pre'     => $allowed_atts,
				'div'     => $allowed_atts,
				'img'     => $allowed_atts,
				'h1'      => $allowed_atts,
				'h2'      => $allowed_atts,
				'h3'      => $allowed_atts,
				'h4'      => $allowed_atts,
				'h5'      => $allowed_atts,
				'h6'      => $allowed_atts,
				'ol'      => $allowed_atts,
				'ul'      => $allowed_atts,
				'li'      => $allowed_atts,
				'em'      => $allowed_atts,
				'hr'      => $allowed_atts,
				'br'      => $allowed_atts,
				'tr'      => $allowed_atts,
				'td'      => $allowed_atts,
				'p'       => $allowed_atts,
				'a'       => $allowed_atts,
				'b'       => $allowed_atts,
				'i'       => $allowed_atts,
			);
			return $tags;
		default:
			return $tags;
		}
	}
endif;

add_filter( 'wp_kses_allowed_html', 'falar_kses_allowed_html', 10, 2);

/**
 * Your Domain RTL
 */

 if( ! function_exists( 'falar_rtl' ) ):
	function falar_rtl() {
		global $falar_opt;

		if(	isset( $falar_opt['falar_enable_rtl'])  ):
			$falar_rtl_opt = $falar_opt['falar_enable_rtl'];
		else:
			$falar_rtl_opt = 'disable';
		endif;

		if ( isset( $_GET['rtl'] ) ) {
			$falar_rtl_opt = $_GET['rtl'];
		}

		if ( $falar_rtl_opt == 'enable' ) :
			$falar_rtl = true;
		else:
			$falar_rtl = false;
		endif;

		return $falar_rtl;
	}
endif;