<?php
/**
 * Register Theme Widget
 * @package Falar
 */

// Register Footer Widget
if ( ! function_exists( 'falar_widgets_init' ) ) {
    function falar_widgets_init() {
        register_sidebar( array(
            'name'          => esc_html__( 'Blog Sidebar', 'falar' ),
            'id'            => 'sidebar-1',
            'description'   => esc_html__( 'Add widgets here.', 'falar' ),
            'before_widget' => '<div id="%1$s" class="widget all-box box %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        ) );
        // Shop Sidebar
        if ( class_exists( 'WooCommerce' ) ){
            register_sidebar( array( 
                'name'          => esc_html__( 'Shop Sidebar', 'falar' ),
                'id'            => 'shop',
                'description'   => esc_html__( 'Add widgets here.', 'falar' ),
                'before_widget' => '<div class="widget sidebar-single-widget %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h3 class="widget-title">',
                'after_title'   => '</h3>',
            ) );
        }
        // Footer Widget
        global $falar_opt;
        $footer_column = !empty($falar_opt['footer_column']) ? $falar_opt['footer_column'] : '-4';
        register_sidebar( array(
            'name'          => esc_html__( 'Footer Widgets', 'falar' ),
            'id'            => 'footer_widgets',
            'description'   => esc_html__( 'Add widgets here.', 'falar' ),
            'before_widget' => '<div class="footer-widget single-footer-widget mb-25 col'.$footer_column.' %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h3>',
            'after_title'   => '</h3>',
        ) );
    }
}
add_action( 'widgets_init', 'falar_widgets_init' );
