<?php
/**
 *  Falar WooCommerce functions and definitions
 */
 	// Theme WooCommerce Support
	add_theme_support( 'woocommerce', apply_filters( 'storefront_woocommerce_args', array(
		'single_image_width'    => 530,
		'thumbnail_image_width' => 350,
		add_theme_support( 'wc-product-gallery-zoom' ),
		add_theme_support( 'wc-product-gallery-lightbox' ),
		add_theme_support( 'wc-product-gallery-slider' ),
	) ) );

	if ( is_active_sidebar( 'shop' ) ) {
		// Change number or products per row to 3
		add_filter('loop_shop_columns', 'falar_loop_columns', 999);
		if (!function_exists('falar_loop_columns')) {
			function falar_loop_columns() {
				global $falar_opt;

				$product_sidebar = isset( $falar_opt['product_sidebar']) ? $falar_opt['product_sidebar'] : '';

				if ( isset( $_GET['shop-sidebar'] ) ):
					if( $_GET['shop-sidebar'] == 'right' || $_GET['shop-sidebar'] == 'left' ):
						return 2; // 2 products per row
					elseif( $_GET['shop-sidebar'] == 'none' ):
						return 3; // 3 products per row
					endif;
				else:
					if ($product_sidebar == 'falar_product_no_sidebar' ):
						return 3; // 3 products per row
					elseif ( $product_sidebar == 'left-sidebar' || $product_sidebar == 'right-sidebar' ):
						return 2; // 2 products per row
					else:
						return 3; // 2 products per row
					endif;
				endif;
			}
		}
	}else{
		// Change number or products per row to 3
		add_filter('loop_shop_columns', 'falar_loop_columns', 999);
		if (!function_exists('falar_loop_columns')) {
			function falar_loop_columns() {
				return 3; // 3 products per row
			}
		}
	}

	// Change number of related products output
	function falar_woo_related_products_limit() {
		global $product;
		$args['posts_per_page'] = 6;
		return $args;
	}
	add_filter( 'woocommerce_output_related_products_args', 'falar_related_products_args', 20 );
	function falar_related_products_args( $args ) {
		global $falar_opt;

		if( isset( $falar_opt['falar_related_product_count'] ) ):
		   $count = $falar_opt['falar_related_product_count'];
		else:
		   $count = '3';
		endif;

		$args['posts_per_page'] = $count; // related products

		global $falar_opt;
		$product_sidebar = isset( $falar_opt['product_sidebar']) ? $falar_opt['product_sidebar'] : '';

		if ( isset( $_GET['shop-sidebar'] ) ):
			if( $_GET['shop-sidebar'] == 'right' || $_GET['shop-sidebar'] == 'left' ):
				$args['columns'] = 2; // 2 products per row
			elseif( $_GET['shop-sidebar'] == 'none' ):
				$args['columns'] = 3; // 3 products per row
			endif;
		else:

			if ( $product_sidebar == 'falar_product_no_sidebar' ):
				$args['columns'] = 3; // 3 products per row
			elseif ( $product_sidebar == 'left-sidebar' || $product_sidebar == 'right-sidebar' ):
				$args['columns'] = 2; // 3 products per row
			else:
				$args['columns'] = 3; // 3 products per row
			endif;
		endif;

		return $args;
	}

	// Filter woocommerce_checkout_fields
	if ( ! function_exists( 'falar_field_class_add' ) ) :
		function falar_field_class_add($fields) {
		foreach ($fields as &$fieldset) {
			foreach ($fieldset as &$field) {
				$field['class'][] = 'form-group';
				$field['input_class'][] = 'form-control';
			}
		}
		return $fields;
	}
	endif;
	add_filter('woocommerce_checkout_fields', 'falar_field_class_add' );

	/**
	 * Post Per page
	 */
	add_filter( 'loop_shop_per_page', 'falar_redefine_products_per_page', 9999 );

	function falar_redefine_products_per_page( $per_page ) {
		global $falar_opt;

		if( isset( $falar_opt['products_page_count'] ) ):
		   $count = $falar_opt['products_page_count'];
		else:
		   $count = '6';
		endif;

		if ( !empty($_GET['falar_product_par_page']) ) {
			$count = $_GET['falar_product_par_page'];
		}

		$per_page = $count;
		return $per_page;
	}

	if ( ! function_exists( 'falar_wc_refresh_mini_cart_count' ) ) :
		function falar_wc_refresh_mini_cart_count($fragments){
			ob_start();
			?>
			<span class="mini-cart-count">
				<?php echo WC()->cart->get_cart_contents_count(); ?>
			</span>
			<?php
				$fragments['.mini-cart-count'] = ob_get_clean();
			return $fragments;
		}
	endif;
	add_filter( 'woocommerce_add_to_cart_fragments', 'falar_wc_refresh_mini_cart_count');

	if ( ! function_exists( 'falar_refresh_mini_cart_count' ) ) :
		function falar_refresh_mini_cart_count($fragments){
			ob_start();
			?>
			<span class="cart-count">
				<?php echo WC()->cart->get_cart_contents_count(); ?>
			</span>
			<?php
				$fragments['.cart-count'] = ob_get_clean();
			return $fragments;
		}
	endif;
	add_filter( 'woocommerce_add_to_cart_fragments', 'falar_refresh_mini_cart_count');

	//Tab Title Chainge Option
	add_filter( 'woocommerce_product_tabs', 'falar_rename_description_tab' );

	function falar_rename_description_tab( $tabs ) {
		global $falar_opt;

		$tabs[ 'description' ][ 'title' ] = $falar_opt['des_tab_title'];

		return $tabs;

	}

	add_filter( 'woocommerce_product_tabs', 'falar_rename_reviews_tab' );

	function falar_rename_reviews_tab( $tabs ) {
		global $falar_opt;

		$reviews_enabled = get_option('woocommerce_enable_reviews');
		if ($reviews_enabled === 'yes') {
			$tabs[ 'reviews' ][ 'title' ] = str_replace( 'Reviews', $falar_opt['review_tab_title'] , $tabs[ 'reviews' ][ 'title' ] );

		}

		return $tabs;

	}