<?php
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';


add_action( 'tgmpa_register', 'falar_register_required_plugins' );


if ( ! function_exists( 'falar_register_required_plugins' ) ) {
	function falar_register_required_plugins() {

		$plugins = array(
			
			// Falar Toolkit
			array(
				'name'               => esc_html__('Falar Toolkit', 'falar'),
				'slug'               => 'falar-toolkit',
				'source'             => get_template_directory() . '/lib/plugins/falar-toolkit.zip',
				'required'           => true,
			),

			// Elemantor Page Builder
			array(
				'name'               => esc_html__('Elementor Website Builder', 'falar'),
				'slug'               => 'elementor',
				'required'           => true,
			),
			
			// Advanced Custom Fields Pro
			array(
				'name'               => esc_html__('Advanced Custom Fields Pro', 'falar'),
				'slug'               => 'advanced-custom-fields-pro',
				'source'             =>  'https://themes.envytheme.com/tools/advanced-custom-fields-pro.zip',
				'required'           => true,
			),

			// WooCommerce
			array(
				'name'      => esc_html__('WooCommerce', 'falar'),
				'slug'      => 'woocommerce',
				'required'  => false,
			),

			// Contact Form 7 
			array(
				'name'               => esc_html__('Contact Form 7', 'falar'),
				'slug'               => 'contact-form-7',
				'required'           => true,
			),

			// Contact Form 7 Multi Step
			array(
				'name'               => esc_html__('Contact Form 7 Multi-Step Forms', 'falar'),
				'slug'               => 'contact-form-7-multi-step-module',
				'required'           => true,
			),

			// Envy Demo Importer
			array(
				'name'               => esc_html__('Envy Demo Importer', 'falar'),
				'slug'               => 'envy-demo-importer',
				'source'			 =>'https://themes.envytheme.com/tools/envy-demo-importer.zip',
				'required'           => true,
			),
		);

		$config = array(
			'id'           => 'tgmpa',
			'default_path' => '',
			'menu'         => 'tgmpa-install-plugins',
			'parent_slug'  => 'themes.php',
			'capability'   => 'edit_theme_options',
			'has_notices'  => true,
			'dismissable'  => true,
			'dismiss_msg'  => '',
			'is_automatic' => false,
			'message'      => '',
		);
		tgmpa( $plugins, $config );
	}
}