<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Falar
 */

	get_header();

	/**
	 * Page Control
	*/
	if( function_exists('acf_add_options_page') ) {
		$hide_banner 		= get_field( 'hide_banner' );
		$hide_breadcrumb 	= get_field( 'hide_breadcrumb' );
		$hide_title 	    = get_field( 'hide_title' );
		$banner_shape       = get_field( 'banner_shape' );
	}else {
		$hide_banner 		= false;
		$hide_title 	    = false;
		$hide_breadcrumb 	= false;
		$banner_shape       = false;
	}
	if( isset($falar_opt['page_title_tag']) ):
		$tag = $falar_opt['page_title_tag'];
	else:
		$tag = 'h2';
	endif;

	$title = get_the_title();
	
?>

	<?php if( $hide_banner == false ): ?>
		<div class="inner-heros-warp">
			<div class="container-fluid">
				<div class="inner-hero-content">
					<?php if( $hide_title == false ): ?>
						<?php if( isset($tag) ): ?>
							<<?php echo esc_attr( $tag ); ?>><?php the_title(); ?></<?php echo esc_attr( $tag ); ?>>
						<?php else: ?>
							<<?php echo esc_attr( $tag ); ?>><?php esc_html_e('No Title', 'falar'); ?></<?php echo esc_attr( $tag ); ?>>
						<?php endif; ?>
					<?php endif; ?>
					<?php if( $hide_breadcrumb == false ): ?>
					<?php
						if ( function_exists('yoast_breadcrumb') ) {
							yoast_breadcrumb( '<p class="falar-seo-breadcrumbs" id="breadcrumbs">','</p>' );
						} else { ?>
							<ul class="inner-hero-list">
								<li class="d-inline-block position-relative text-uppercase"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'falar' ); ?></a></li>
									<?php if( $title != '' ): ?>
										<li class="d-inline-block position-relative text-uppercase active"><?php echo esc_html( $title ); ?></li>
										<?php else: ?>
											<li class="d-inline-block position-relative text-uppercase active"><?php echo esc_html_e( 'No Title', 'falar' ); ?></li>
									<?php endif; ?>
								<?php ?>                        
							</ul>
						<?php
						}
					endif; ?>
				</div>
			</div>
			<div class="all-shapes">
				<?php if($banner_shape):  ?>
					<img src="<?php echo esc_url($banner_shape) ?>" class="inner-page-shape1" alt="<?php echo esc_attr__( 'images', 'falar' ); ?>">
					<?php else: ?>
						<img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/inner-page-shape1.png') ?>" class="inner-page-shape1" alt="Shape">
				<?php endif; ?>
            </div>
		</div>
	<?php endif; ?>

	<div class="page-wrapper">
		<?php if(!falar_is_elementor()): ?><div class="page-main-content"><?php endif; ?>
			<div class="page-area">
				<?php if( !falar_is_elementor()): ?><div class="container"><?php endif; ?>
					<?php while ( have_posts() ) : the_post(); ?>
						<?php $thecontent = get_the_content(); // If no content ?>
						<?php if(empty($thecontent)){ ?> <div class="falar-single-blank-page"></div><?php } ?>
						<?php get_template_part( 'template-parts/content', 'page' ); ?>
						<?php if ( comments_open() || get_comments_number() ) : comments_template(); endif; // If comments are open or we have at least one comment, load up the comment template. ?>
					<?php endwhile; // End of the loop. ?>
				<?php if( !falar_is_elementor()): ?></div><?php endif; ?>
			</div>
		<?php if( !falar_is_elementor()): ?></div><?php endif; ?>	
	</div>
<?php
get_footer();
