<?php
    global $falar_opt;

    $tag_num = isset( $falar_opt['tag_num'] ) ? $falar_opt['tag_num'] : '';
?>
    <div class="blog-input">
        <form role="search" method="get" class="search-form" id="search" action="<?php echo esc_url( home_url( '/' ) ); ?>">
            <label>
                <input type="search" class="form-control search-field" placeholder="<?php esc_attr_e( 'Find article', 'falar' ); ?>" value="<?php echo get_search_query(); ?>" name="s" id="s" required>
            </label>
            <button class="search-btn" type="submit"><i class="ri-search-line"></i></button>
        </form>
    </div>
    <div class="search-tags">
        <div class="row">
            <div class="col-lg-4">
                <span class="search-list"><?php esc_attr_e( 'Quick Search:', 'falar' ); ?></span>
            </div>
            <div class="col-lg-8">
                <?php if ( get_tags() ) {  ?>
                <ul class="program-list">
                    <?php $tags = get_tags();
                        $i = 1;
                        foreach ($tags as $tag ) {  ?>
                        <?php if($i <= $tag_num): ?>
                        <li>
                            <a href="<?php echo esc_url(get_tag_link($tag->term_id)); ?>">
                                <?php echo esc_html($tag->name) ?>
                            </a>
                        </li>
                        <?php endif; $i++;
                        } ?>
                    </ul>
                <?php } ?>
            </div>
        </div>
    </div>
<?php