<?php
/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Falar
 */


 if ( class_exists( 'WooCommerce' ) ) {
	if( is_woocommerce() ) {
		$falar_sidebar_class = 'shop';
	} elseif ( is_product() ) {
		$falar_sidebar_class = 'shop';
	} else {
		$falar_sidebar_class = 'sidebar-1';
	}
} else {
	$falar_sidebar_class = 'sidebar-1';
}

if ( ! is_active_sidebar( $falar_sidebar_class ) ) { 
	return;
}
?>

<div class="col-lg-4 col-md-12">
	<?php if ( class_exists( 'WooCommerce' ) ) {
		if( is_woocommerce() ) { ?>
			<div id="secondary" class="shop-sidebar sidebar">
			<?php
		} elseif ( is_product() ) { ?>
			<div id="secondary" class="sidebar shop-sidebar sidebar">
		<?php
		} else { ?>
			<div id="secondary" class="title sidebar blog-small-widget widget-area">
		<?php
		}
	} else { ?>
		<div id="secondary" class="title sidebar blog-small-widget widget-area">
	<?php } ?>
		<?php dynamic_sidebar( $falar_sidebar_class );?>
	</div>
</div><!-- #secondary -->