<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Falar
 */

 	global $falar_opt;
	// Post thumb size
	if(isset($falar_opt['falar_blog_sidebar'])) {
	if( $falar_opt['falar_blog_sidebar'] == 'falar_without_sidebar' ):
			$thumb_size = 'full';
	else:
			$thumb_size = 'falar_single_blog_thumb';
	endif;
	}else {
		$thumb_size = 'falar_single_blog_thumb';
	}

	// Blog breadcrumb
	if( isset($falar_opt['blog_title']) ) {
		$falar_blog_grid        = $falar_opt['falar_blog_grid'];
		
	} else {
		$falar_blog_grid    	='col-lg-12';
	}
    
	$id	 = get_the_ID();
	$title = get_the_title( get_the_ID() );

	// Category 
	$falar_blog_category = get_the_terms(get_the_ID(), 'category');

	if($falar_blog_category && ! is_wp_error( $falar_blog_category )) {
		$blog_cat_list = array();
		
		foreach($falar_blog_category as $category) {
			$blog_cat_list[] = $category->name; 
			$category_link   = get_category_link($category);
			$category_ass    ='<a href="' . esc_url($category_link) .'">' . esc_html($category->name) . ' </a>';
		}
	} 
?>
<div class="<?php echo esc_attr($falar_blog_grid);?> <?php if (!has_post_thumbnail() ) { echo esc_attr__( 'blog-without-img', 'falar' ); } ?>">
	<div <?php post_class("main-blog-card main"); ?>>
		<?php if(get_the_post_thumbnail_url() != ''): ?>
			<div class="image">
				<a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="image d-block">
					<img src="<?php echo get_the_post_thumbnail_url( get_the_ID() ); ?>" alt="<?php the_post_thumbnail_caption(); ?>">
				</a>
			</div>
		<?php endif; ?>
		<div class="content">
			<?php
				$categories = get_the_category();
				if ($categories) {
					echo '<ul class="ps-0 mb-0 list-unstyled cat">';
					foreach ($categories as $category) {
						echo '<li><a href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
					}
					echo '</ul>';
				}
				?>
			<h3>
				<a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="text-decoration-none">
					<?php echo wp_kses_post($title); ?>
				</a>
			</h3>
			<ul class="blog-list">
				<li><a href="<?php echo esc_url(get_the_permalink($id)); ?>"><?php echo esc_html(get_the_date()); ?></a></li>
				<li><?php echo esc_html(falar_post_reading_time()); ?></li>
			</ul>
		</div>
	</div>
</div>