<?php
/**
 * Footer Content
 * @package WordPress
 * @subpackage Falar
*/
if ( ! function_exists( 'falar_theme_footer_content' ) ) {
	function falar_theme_footer_content() {

        global $falar_opt;

        $fot_style = function_exists( 'get_field' ) ? get_field( 'footer_style' ) : '';

        if( isset( $falar_opt['copyright_text'] )):
            $copyright_text 		= $falar_opt['copyright_text'];
        else:
            $copyright_text 		= '';
        endif;

        $fot_style = function_exists( 'get_field' ) ? get_field( 'footer_style' ) : '';

        if( isset( $falar_opt['enable_back_to_top'] )):
            $enable_back_to_top 	= $falar_opt['enable_back_to_top'];
        else:
            $enable_back_to_top 	= true;
        endif;

        ?>
            <?php if ( is_active_sidebar( 'footer_widgets') ) : ?>
                <footer class="footer-warp ptb-100">
                    <div class="container">
                        <div class="row justify-content-center" data-cue="slideInUp">
                            <?php dynamic_sidebar( 'footer_widgets' ); ?>
                        </div>
                    </div>
                </footer>
            <?php endif; ?>
            <!-- Copy Right Warp Start -->
            <?php if($copyright_text): ?>
                <div class="copy-right-warp">
                    <div class="container">
                        <div class="copy-right-content">
                            <p><?php echo wp_kses( $copyright_text, 'falarallowedhtml' ); ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <!-- Copy Right Warp End -->
        <?php
    }
}