<?php
/**
 * Navbar Area
 * @package WordPress
 * @subpackage Falar
*/

if ( ! function_exists( 'falar_nav_area' ) ) {
	function falar_nav_area() {
        global $falar_opt;

        // Main site logo
        if(isset($falar_opt['main_logo']['url'])):
            $logo 	= $falar_opt['main_logo']['url'];
        else:
            $logo	= '';
        endif;
        if(isset($falar_opt['main_logo2']['url'])):
            $logo2 	= $falar_opt['main_logo2']['url'];
        else:
            $logo2	= '';
        endif;
        if(isset($falar_opt['main_logo3']['url'])):
            $logo3 	= $falar_opt['main_logo3']['url'];
        else:
            $logo3	= '';
        endif;
        if(isset($falar_opt['main_logo4']['url'])):
            $logo4 	= $falar_opt['main_logo4']['url'];
        else:
            $logo4	= '';
        endif;
        if(isset($falar_opt['main_logo5']['url'])):
            $logo5 	= $falar_opt['main_logo5']['url'];
        else:
            $logo5	= '';
        endif;

        if(isset($falar_opt['search_icon']['url'])):
            $search_icon 	= $falar_opt['search_icon']['url'];
        else:
            $search_icon	= '';
        endif;

        if(isset($falar_opt['menu_icon']['url'])):
            $menu_icon 	= $falar_opt['menu_icon']['url'];
        else:
            $menu_icon	= '';
        endif;

        if(isset($falar_opt['sidebar_top_bg']['url'])):
            $sidebar_top_bg 	= $falar_opt['sidebar_top_bg']['url'];
        else:
            $sidebar_top_bg	= '';
        endif;

        $search_placeholder     = isset( $falar_opt['header_search_placeholder'] ) ? $falar_opt['header_search_placeholder'] : '';
        $mail_address           = isset( $falar_opt['mail_address'] ) ? $falar_opt['mail_address'] : '';
        $phone_no               = isset( $falar_opt['phone_no'] ) ? $falar_opt['phone_no'] : '';

        //Top Menu
        $top_menu_text1     = isset( $falar_opt['top_menu_text1'] ) ? $falar_opt['top_menu_text1'] : '';
        $top_menu_url1      = isset( $falar_opt['top_menu_url1'] ) ? $falar_opt['top_menu_url1'] : '';
        $top_menu_text2     = isset( $falar_opt['top_menu_text2'] ) ? $falar_opt['top_menu_text2'] : '';
        $top_menu_url2      = isset( $falar_opt['top_menu_url2'] ) ? $falar_opt['top_menu_url2'] : '';
        $top_menu_text3     = isset( $falar_opt['top_menu_text3'] ) ? $falar_opt['top_menu_text3'] : '';
        $top_menu_url3      = isset( $falar_opt['top_menu_url3'] ) ? $falar_opt['top_menu_url3'] : '';
        $top_menu_text4     = isset( $falar_opt['top_menu_text4'] ) ? $falar_opt['top_menu_text4'] : '';
        $top_menu_url4      = isset( $falar_opt['top_menu_url4'] ) ? $falar_opt['top_menu_url4'] : '';
        $top_button_text    = isset( $falar_opt['top_button_text'] ) ? $falar_opt['top_button_text'] : '';
        $top_button_url     = isset( $falar_opt['top_button_url'] ) ? $falar_opt['top_button_url'] : '';


        //Sidebar
        $sidebar_top_title       = isset( $falar_opt['sidebar_top_title'] ) ? $falar_opt['sidebar_top_title'] : '';
        $sidebar_top_content     = isset( $falar_opt['sidebar_top_content'] ) ? $falar_opt['sidebar_top_content'] : '';
        $sidebar_button_text     = isset( $falar_opt['sidebar_button_text'] ) ? $falar_opt['sidebar_button_text'] : '';
        $sidebar_button_url      = isset( $falar_opt['sidebar_button_url'] ) ? $falar_opt['sidebar_button_url'] : '';
        $directory_title         = isset( $falar_opt['directory_title'] ) ? $falar_opt['directory_title'] : '';
        $directory_list_text1    = isset( $falar_opt['directory_list_text1'] ) ? $falar_opt['directory_list_text1'] : '';
        $directory_list_url1     = isset( $falar_opt['directory_list_url1'] ) ? $falar_opt['directory_list_url1'] : '';
        $directory_list_text2    = isset( $falar_opt['directory_list_text2'] ) ? $falar_opt['directory_list_text2'] : '';
        $directory_list_url2     = isset( $falar_opt['directory_list_url2'] ) ? $falar_opt['directory_list_url2'] : '';
        $directory_list_text3    = isset( $falar_opt['directory_list_text3'] ) ? $falar_opt['directory_list_text3'] : '';
        $directory_list_url3     = isset( $falar_opt['directory_list_url3'] ) ? $falar_opt['directory_list_url3'] : '';
        $news_title              = isset( $falar_opt['news_title'] ) ? $falar_opt['news_title'] : '';

        //Sidebar Blog Hide Show
        if( isset($falar_opt['top_menu_text1']) ) {
            $news_title                 = $falar_opt['top_menu_text1'];
            $top_header_hideshow        = $falar_opt['top_header_hideshow'];
        } else {
            $top_header_hideshow    	= false;
        }
        //Sidebar Blog Hide Show
        if( isset($falar_opt['news_title']) ) {
            $news_title                 = $falar_opt['news_title'];
            $sidebar_blog_hideshow      = $falar_opt['sidebar_blog_hideshow'];
        } else {
            $sidebar_blog_hideshow    	= false;
        }
        
        $hide_adminbar 				= 'falar-hide-adminbar';
        
        $nav_style = function_exists( 'get_field' ) ? get_field( 'header_style' ) : '';
        
        if($nav_style== 2): ?>
            <?php if( $top_header_hideshow == false ): ?>
                <!-- Top Header Warp Start -->
                <div class="top-header-warp">
                    <div class="container-fluid">
                        <div class="row align-items-center">
                            <div class="col-lg-6">
                                <div class="top-header-details">
                                    <ul class="social-list">
                                        <?php falar_social_link(); ?>
                                    </ul>
                                    <ul class="header-contact">
                                        <?php if($mail_address): ?>
                                            <li>
                                                <i class="ti ti-mail"></i>
                                                <a href="mailto:<?php echo esc_attr( $mail_address ); ?>"><?php echo esc_attr( $mail_address ); ?></a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if($phone_no): ?>
                                            <li>
                                                <i class="ti ti-phone-call"></i>
                                                <a href="tel:<?php echo esc_attr( $phone_no ); ?>"><?php echo esc_attr( $phone_no ); ?></a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="top-header-link-details">
                                    <?php if($top_menu_url4): ?>
                                        <ul class="header-link">
                                            <?php if($top_menu_url1): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_menu_url1 ); ?>"><?php echo esc_attr( $top_menu_text1 ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($top_menu_url2): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_menu_url2 ); ?>"><?php echo esc_attr( $top_menu_text2 ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($top_menu_url3): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_menu_url3 ); ?>"><?php echo esc_attr( $top_menu_text3 ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($top_menu_url4): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_menu_url4 ); ?>"><?php echo esc_attr( $top_menu_text4 ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    <?php endif; ?>
                                    <ul class="header-account">
                                        <?php if($top_button_url): ?>
                                            <li>
                                                <a href="<?php echo esc_attr( $top_button_url ); ?>"><?php echo esc_attr( $top_button_text ); ?></a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Top Header Warp End -->
            <?php endif; ?>

            <!-- Start Navbar Area -->
            <nav class="navbar navbar-expand-lg top-navbar first-navbar <?php if ( is_user_logged_in() ) { echo esc_attr( $hide_adminbar ); } ?>" id="navbar">
                <div class="container-fluid">
                    <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <?php if( $logo != '' ): ?>
                            <img src="<?php echo esc_url( $logo ); ?>" class="navbar-logo" alt="<?php bloginfo( 'name' ); ?>">
                        <?php else: ?>
                            <h2 class="logo-option"><?php bloginfo( 'name' ); ?></h2>
                        <?php endif; ?>
                    </a>
                    <button class="navbar-toggler home1-one-toggle" data-bs-toggle="offcanvas" data-bs-target="#navbarOffcanvas">
                        <span class="burger-menu">
                            <span class="top-bar"></span>
                            <span class="middle-bar"></span>
                            <span class="bottom-bar"></span>
                        </span>
                    </button>
                    <div class="collapse navbar-collapse">
                        <?php
                            $primary_nav_arg = [
                                'menu'            => 'primary',
                                'theme_location'  => 'primary',
                                'container'       => null,
                                'menu_class'      => 'navbar-nav ms-auto',
                                'depth'           => 3,
                                'walker'          => new Falar_Bootstrap_Navwalker(),
                                'fallback_cb'     => 'Falar_Bootstrap_Navwalker::fallback',
                            ];

                            if(has_nav_menu('primary')){
                                wp_nav_menu($primary_nav_arg);
                            }
                        ?>
                        <div class="others-option d-flex align-items-center">
                            <?php if( $search_icon != '' ): ?>
                                <div class="option-item">
                                    <div class="search-bar main-menu__search search-toggler">
                                        <a href="#" class="search-btn">
                                            <img src="<?php echo esc_url( $search_icon ); ?>" alt="image">
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if( $menu_icon != '' ): ?>
                                <div class="option-item">
                                    <button class="btn side-bar-btn" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasWithBothOptions" aria-controls="offcanvasWithBothOptions">
                                        <img src="<?php echo esc_url( $menu_icon ); ?>" alt="svg">
                                    </button>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </nav>
            <!-- End Navbar Area -->

            <?php if($search_placeholder): ?>
                <div class="search-popup">
                    <div class="search-popup-overlay search-toggler"></div>
                    <!-- /.search-popup__overlay -->
                    <div class="search-popup-content">
                        <form role="search" method="get" id="search1" action="<?php echo esc_url( home_url( '/' ) );?>" class="search-popup-form" >
                            <input type="text" class="form-control" value="<?php echo get_search_query(); ?>" name="s" id="s2" required  placeholder="<?php echo esc_attr( $search_placeholder ); ?>">
                            <button type="submit" aria-label="search submit" class="default-btn">
                                <i class="ti ti-search"></i>
                            </button>
                        </form>
                    </div>
                    <!-- /.search-popup__content -->
                </div>
            <?php endif; ?>

            <!-- Sidebar Area Start -->
            <div class="offcanvas offcanvas-end slide-bar-offcanvas" data-bs-scroll="true" tabindex="-1" id="offcanvasWithBothOptions">
                <div class="offcanvas-body">
                    <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"> <i class="flaticon-close"></i>
                    </button>
                    <div class="sidebar-warp">
                        <div class="join-luva-box" style="background-image:url(<?php echo esc_url($sidebar_top_bg); ?>);">
                            <?php if($sidebar_top_title): ?>
                                <h3><?php echo esc_attr( $sidebar_top_title ); ?></h3>
                            <?php endif; ?>
                            <?php if($sidebar_top_content): ?>
                                <p><?php echo esc_attr( $sidebar_top_content ); ?></p>
                            <?php endif; ?>
                            <?php if($sidebar_button_url): ?>
                                <a href="<?php echo esc_attr( $sidebar_button_url ); ?>" class="default-btn">
                                    <?php echo esc_attr( $sidebar_button_text ); ?>
                                    <i class="ti ti-arrow-narrow-right"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                        <div class="directory-widget">
                            <?php if($directory_title): ?>
                                <h3><?php echo esc_attr( $directory_title ); ?></h3>
                            <?php endif; ?>
                            <ul class="directory-list">
                                <?php if($directory_list_url1): ?>
                                    <li>
                                        <a href="<?php echo esc_attr( $directory_list_url1 ); ?>"><?php echo esc_attr( $directory_list_text1 ); ?></a>
                                    </li>
                                <?php endif; ?>
                                <?php if($directory_list_url2): ?>
                                    <li>
                                        <a href="<?php echo esc_attr( $directory_list_url2 ); ?>"><?php echo esc_attr( $directory_list_text2 ); ?></a>
                                    </li>
                                <?php endif; ?>
                                <?php if($directory_list_url3): ?>
                                    <li>
                                        <a href="<?php echo esc_attr( $directory_list_url3 ); ?>"><?php echo esc_attr( $directory_list_text3 ); ?></a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <?php if( $sidebar_blog_hideshow == false ): ?>
                            <div class="latest-side-news">
                                <?php if($news_title): ?>
                                    <h3><?php echo esc_attr( $news_title ); ?></h3>
                                <?php endif; ?>
                                <?php
                                    $args = array(
                                        'posts_per_page' => 1, 
                                    );
                                    $recent_posts = new WP_Query($args);
                                ?>

                                <?php
                                    while ( $recent_posts->have_posts() ): $recent_posts->the_post();
                                    $id    = get_the_ID();
                                    $title = get_the_title( get_the_ID() );
                                ?>
                                    <div class="blog-article-item">
                                        <?php
                                        $categories = get_the_category();
                                        if ($categories) {
                                            echo '<ul class="ps-0 mb-0 list-unstyled cat">';
                                            foreach ($categories as $category) {
                                                echo '<li><a href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
                                            }
                                            echo '</ul>';
                                        }
                                        ?>
                                        <h3>
                                            <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="text-decoration-none">
                                                <?php echo wp_kses_post($title); ?>
                                            </a>
                                        </h3>
                                        <ul class="article-list">
                                            <li><?php echo esc_html(get_the_date()); ?></li>
                                            <li><?php echo esc_html(falar_post_reading_time()); ?></li>
                                        </ul>
                                    </div>
                                <?php endwhile; ?>
                                <?php
                                    wp_reset_query();
                                ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <!-- Sidebar Area End -->

            <!-- Start Responsive Navbar Area -->
            <div class="responsive-navbar offcanvas offcanvas-end border-0" data-bs-backdrop="static" tabindex="-1" id="navbarOffcanvas">
                <div class="offcanvas-header">
                    <a class="logo d-inline-block" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <?php if( $logo != '' ): ?>
                            <img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                        <?php else: ?>
                            <h2 class="logo-option"><?php bloginfo( 'name' ); ?></h2>
                        <?php endif; ?>
                    </a>
                    <button type="button" class="close-btn bg-transparent position-relative lh-1 p-0 border-0" data-bs-dismiss="offcanvas" aria-label="Close">
                        <i class="ti ti-x"></i>
                    </button>
                </div>
                <div class="offcanvas-body">
                    <?php
                        $primary_nav_arg = [
                            'menu'            => 'primary',
                            'theme_location'  => 'primary',
                            'container'       => null,
                            'menu_class'      => 'navbar-nav',
                            'depth'           => 3,
                        ];

                        if(has_nav_menu('primary')){
                            wp_nav_menu($primary_nav_arg);
                        }
                    ?>
                    <div class="others-option d-flex align-items-center">
                        <?php if( $search_icon != '' ): ?>
                            <div class="option-item">
                                <div class="search-bar main-menu__search search-toggler">
                                    <a href="#" class="search-btn">
                                        <img src="<?php echo esc_url( $search_icon ); ?>" alt="image">
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if( $menu_icon != '' ): ?>
                            <div class="option-item">
                                <button class="btn side-bar-btn" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasWithBothOptions" aria-controls="offcanvasWithBothOptions">
                                    <img src="<?php echo esc_url( $menu_icon ); ?>" alt="svg">
                                </button>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <!-- End Responsive Navbar Area -->
        <?php elseif($nav_style== 3): ?>
            <?php if( $top_header_hideshow == false ): ?>
                <!-- Top Header Warp Start -->
                <div class="top-header-warp style2-top-header">
                    <div class="container-fluid">
                        <div class="row align-items-center">
                            <div class="col-lg-6">
                                <div class="top-header-details">
                                    <ul class="social-list">
                                        <?php falar_social_link(); ?>
                                    </ul>
                                    <ul class="header-contact">
                                        <?php if($mail_address): ?>
                                            <li>
                                                <i class="ti ti-mail"></i>
                                                <a href="mailto:<?php echo esc_attr( $mail_address ); ?>"><?php echo esc_attr( $mail_address ); ?></a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if($phone_no): ?>
                                            <li>
                                                <i class="ti ti-phone-call"></i>
                                                <a href="tel:<?php echo esc_attr( $phone_no ); ?>"><?php echo esc_attr( $phone_no ); ?></a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="top-header-link-details">
                                    <?php if($top_menu_url4): ?>
                                        <ul class="header-link">
                                            <?php if($top_menu_url1): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_menu_url1 ); ?>"><?php echo esc_attr( $top_menu_text1 ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($top_menu_url2): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_menu_url2 ); ?>"><?php echo esc_attr( $top_menu_text2 ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($top_menu_url3): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_menu_url3 ); ?>"><?php echo esc_attr( $top_menu_text3 ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($top_menu_url4): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_menu_url4 ); ?>"><?php echo esc_attr( $top_menu_text4 ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    <?php endif; ?>
                                    <ul class="header-account">
                                        <?php if($top_button_url): ?>
                                            <li>
                                                <a href="<?php echo esc_attr( $top_button_url ); ?>"><?php echo esc_attr( $top_button_text ); ?></a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Top Header Warp End -->
            <?php endif; ?>

            <!-- Start Navbar Area -->
            <nav class="navbar navbar-expand-lg top-navbar second-navbar <?php if ( is_user_logged_in() ) { echo esc_attr( $hide_adminbar ); } ?>" id="navbar">
                <div class="container-fluid">
                    <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <?php if( $logo2 != '' ): ?>
                            <img src="<?php echo esc_url( $logo2 ); ?>" class="navbar-logo" alt="<?php bloginfo( 'name' ); ?>">
                        <?php else: ?>
                            <h2 class="logo-option"><?php bloginfo( 'name' ); ?></h2>
                        <?php endif; ?>
                    </a>
                    <button class="navbar-toggler home1-one-toggler" data-bs-toggle="offcanvas" data-bs-target="#navbarOffcanvas">
                        <span class="burger-menu">
                            <span class="top-bar"></span>
                            <span class="middle-bar"></span>
                            <span class="bottom-bar"></span>
                        </span>
                    </button>
                    <div class="collapse navbar-collapse">
                        <?php
                            $left_menu_arg = [
                                'menu'            => 'left_menu',
                                'theme_location'  => 'left_menu',
                                'container'       => null,
                                'menu_class'      => 'navbar-nav me-auto navbar-style2',
                                'depth'           => 3,
                                'walker'          => new Falar_Bootstrap_Navwalker(),
                                'fallback_cb'     => 'Falar_Bootstrap_Navwalker::fallback',
                            ];

                            if(has_nav_menu('left_menu')){
                                wp_nav_menu($left_menu_arg);
                            }
                        ?>
                        <?php
                            $right_menu_arg = [
                                'menu'            => 'right_menu',
                                'theme_location'  => 'right_menu',
                                'container'       => null,
                                'menu_class'      => 'navbar-nav ms-auto',
                                'depth'           => 3,
                                'walker'          => new Falar_Bootstrap_Navwalker(),
                                'fallback_cb'     => 'Falar_Bootstrap_Navwalker::fallback',
                            ];

                            if(has_nav_menu('right_menu')){
                                wp_nav_menu($right_menu_arg);
                            }
                        ?>
                        <div class="others-option d-flex align-items-center">
                            <?php if( $search_icon != '' ): ?>
                                <div class="option-item">
                                    <div class="search-bar main-menu__search search-toggler">
                                        <a href="#" class="search-btn">
                                            <img src="<?php echo esc_url( $search_icon ); ?>" alt="image">
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if( $menu_icon != '' ): ?>
                                <div class="option-item">
                                    <button class="btn side-bar-btn" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasWithBothOptions" aria-controls="offcanvasWithBothOptions">
                                        <img src="<?php echo esc_url( $menu_icon ); ?>" alt="svg">
                                    </button>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </nav>
            <!-- End Navbar Area -->

            <?php if($search_placeholder): ?>
                <div class="search-popup">
                    <div class="search-popup-overlay search-toggler"></div>
                    <!-- /.search-popup__overlay -->
                    <div class="search-popup-content">
                        <form role="search" method="get" id="search1" action="<?php echo esc_url( home_url( '/' ) );?>" class="search-popup-form" >
                            <input type="text" class="form-control" value="<?php echo get_search_query(); ?>" name="s" id="s2" required  placeholder="<?php echo esc_attr( $search_placeholder ); ?>">
                            <button type="submit" aria-label="search submit" class="default-btn">
                                <i class="ti ti-search"></i>
                            </button>
                        </form>
                    </div>
                    <!-- /.search-popup__content -->
                </div>
            <?php endif; ?>

            <!-- Sidebar Area Start -->
            <div class="offcanvas offcanvas-end slide-bar-offcanvas" data-bs-scroll="true" tabindex="-1" id="offcanvasWithBothOptions">
                <div class="offcanvas-body">
                    <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"> <i class="flaticon-close"></i>
                    </button>
                    <div class="sidebar-warp">
                        <div class="join-luva-box" style="background-image:url(<?php echo esc_url($sidebar_top_bg); ?>);">
                            <?php if($sidebar_top_title): ?>
                                <h3><?php echo esc_attr( $sidebar_top_title ); ?></h3>
                            <?php endif; ?>
                            <?php if($sidebar_top_content): ?>
                                <p><?php echo esc_attr( $sidebar_top_content ); ?></p>
                            <?php endif; ?>
                            <?php if($sidebar_button_url): ?>
                                <a href="<?php echo esc_attr( $sidebar_button_url ); ?>" class="default-btn">
                                    <?php echo esc_attr( $sidebar_button_text ); ?>
                                    <i class="ti ti-arrow-narrow-right"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                        <div class="directory-widget">
                            <?php if($directory_title): ?>
                                <h3><?php echo esc_attr( $directory_title ); ?></h3>
                            <?php endif; ?>
                            <ul class="directory-list">
                                <?php if($directory_list_url1): ?>
                                    <li>
                                        <a href="<?php echo esc_attr( $directory_list_url1 ); ?>"><?php echo esc_attr( $directory_list_text1 ); ?></a>
                                    </li>
                                <?php endif; ?>
                                <?php if($directory_list_url2): ?>
                                    <li>
                                        <a href="<?php echo esc_attr( $directory_list_url2 ); ?>"><?php echo esc_attr( $directory_list_text2 ); ?></a>
                                    </li>
                                <?php endif; ?>
                                <?php if($directory_list_url3): ?>
                                    <li>
                                        <a href="<?php echo esc_attr( $directory_list_url3 ); ?>"><?php echo esc_attr( $directory_list_text3 ); ?></a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <?php if( $sidebar_blog_hideshow == false ): ?>
                            <div class="latest-side-news">
                                <?php if($news_title): ?>
                                    <h3><?php echo esc_attr( $news_title ); ?></h3>
                                <?php endif; ?>
                                <?php
                                    $args = array(
                                        'posts_per_page' => 1, 
                                    );
                                    $recent_posts = new WP_Query($args);
                                ?>

                                <?php
                                    while ( $recent_posts->have_posts() ): $recent_posts->the_post();
                                    $id    = get_the_ID();
                                    $title = get_the_title( get_the_ID() );
                                ?>
                                    <div class="blog-article-item">
                                        <?php
                                        $categories = get_the_category();
                                        if ($categories) {
                                            echo '<ul class="ps-0 mb-0 list-unstyled cat">';
                                            foreach ($categories as $category) {
                                                echo '<li><a href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
                                            }
                                            echo '</ul>';
                                        }
                                        ?>
                                        <h3>
                                            <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="text-decoration-none">
                                                <?php echo wp_kses_post($title); ?>
                                            </a>
                                        </h3>
                                        <ul class="article-list">
                                            <li><?php echo esc_html(get_the_date()); ?></li>
                                            <li><?php echo esc_html(falar_post_reading_time()); ?></li>
                                        </ul>
                                    </div>
                                <?php endwhile; ?>
                                <?php
                                    wp_reset_query();
                                ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <!-- Sidebar Area End -->

            <!-- Start Responsive Navbar Area -->
            <div class="responsive-navbar offcanvas offcanvas-end border-0" data-bs-backdrop="static" tabindex="-1" id="navbarOffcanvas">
                <div class="offcanvas-header">
                    <a class="logo d-inline-block" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <?php if( $logo != '' ): ?>
                            <img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                        <?php else: ?>
                            <h2 class="logo-option"><?php bloginfo( 'name' ); ?></h2>
                        <?php endif; ?>
                    </a>
                    <button type="button" class="close-btn bg-transparent position-relative lh-1 p-0 border-0" data-bs-dismiss="offcanvas" aria-label="Close">
                        <i class="ti ti-x"></i>
                    </button>
                </div>
                <div class="offcanvas-body">
                    <?php
                        $primary_nav_arg = [
                            'menu'            => 'primary',
                            'theme_location'  => 'primary',
                            'container'       => null,
                            'menu_class'      => 'navbar-nav',
                            'depth'           => 3,
                        ];

                        if(has_nav_menu('primary')){
                            wp_nav_menu($primary_nav_arg);
                        }
                    ?>
                    <div class="others-option d-flex align-items-center">
                        <?php if( $search_icon != '' ): ?>
                            <div class="option-item">
                                <div class="search-bar main-menu__search search-toggler">
                                    <a href="#" class="search-btn">
                                        <img src="<?php echo esc_url( $search_icon ); ?>" alt="image">
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if( $menu_icon != '' ): ?>
                            <div class="option-item">
                                <button class="btn side-bar-btn" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasWithBothOptions" aria-controls="offcanvasWithBothOptions">
                                    <img src="<?php echo esc_url( $menu_icon ); ?>" alt="svg">
                                </button>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <!-- End Responsive Navbar Area -->
            <?php elseif($nav_style== 4): ?>
                <?php if( $top_header_hideshow == false ): ?>
                    <!-- Top Header Warp Start -->
                    <div class="top-header-warp style2-top-header style3 transparent-bg only-992-device-none">
                        <div class="container-fluid">
                            <div class="row align-items-center">
                                <div class="col-lg-6">
                                    <div class="top-header-details">
                                        <ul class="header-contact">
                                            <?php if($mail_address): ?>
                                                <li>
                                                    <i class="ti ti-mail"></i>
                                                    <a href="mailto:<?php echo esc_attr( $mail_address ); ?>"><?php echo esc_attr( $mail_address ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($phone_no): ?>
                                                <li>
                                                    <i class="ti ti-phone-call"></i>
                                                    <a href="tel:<?php echo esc_attr( $phone_no ); ?>"><?php echo esc_attr( $phone_no ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="top-header-link-details">
                                        <?php if($top_menu_url4): ?>
                                            <ul class="header-link">
                                                <?php if($top_menu_url1): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url1 ); ?>"><?php echo esc_attr( $top_menu_text1 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($top_menu_url2): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url2 ); ?>"><?php echo esc_attr( $top_menu_text2 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($top_menu_url3): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url3 ); ?>"><?php echo esc_attr( $top_menu_text3 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($top_menu_url4): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url4 ); ?>"><?php echo esc_attr( $top_menu_text4 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                            </ul>
                                        <?php endif; ?>
                                        <ul class="header-account">
                                            <?php if($top_button_url): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_button_url ); ?>"><?php echo esc_attr( $top_button_text ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Top Header Warp End -->
                <?php endif; ?>
                <?php if( $top_header_hideshow == false ): ?>
                    <!-- Top Header Warp Start -->
                    <div class="top-header-warp only-992-device">
                        <div class="container-fluid">
                            <div class="row align-items-center">
                                <div class="col-lg-6">
                                    <div class="top-header-details">
                                        <ul class="social-list">
                                            <?php falar_social_link(); ?>
                                        </ul>
                                        <ul class="header-contact">
                                            <?php if($mail_address): ?>
                                                <li>
                                                    <i class="ti ti-mail"></i>
                                                    <a href="mailto:<?php echo esc_attr( $mail_address ); ?>"><?php echo esc_attr( $mail_address ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($phone_no): ?>
                                                <li>
                                                    <i class="ti ti-phone-call"></i>
                                                    <a href="tel:<?php echo esc_attr( $phone_no ); ?>"><?php echo esc_attr( $phone_no ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="top-header-link-details">
                                        <?php if($top_menu_url4): ?>
                                            <ul class="header-link">
                                                <?php if($top_menu_url1): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url1 ); ?>"><?php echo esc_attr( $top_menu_text1 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($top_menu_url2): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url2 ); ?>"><?php echo esc_attr( $top_menu_text2 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($top_menu_url3): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url3 ); ?>"><?php echo esc_attr( $top_menu_text3 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($top_menu_url4): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url4 ); ?>"><?php echo esc_attr( $top_menu_text4 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                            </ul>
                                        <?php endif; ?>
                                        <ul class="header-account">
                                            <?php if($top_button_url): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_button_url ); ?>"><?php echo esc_attr( $top_button_text ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Top Header Warp End -->
                <?php endif; ?>

                <!-- Start Navbar Area -->
                <nav class="navbar navbar-expand-lg top-navbar transparent-bg <?php if ( is_user_logged_in() ) { echo esc_attr( $hide_adminbar ); } ?>" id="navbar">
                    <div class="container-fluid">
                        <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <?php if( $logo3 != '' ): ?>
                                <img src="<?php echo esc_url( $logo3 ); ?>" class="navbar-logo style3-logo" alt="<?php bloginfo( 'name' ); ?>">
                                <img src="<?php echo esc_url( $logo ); ?>" class="sticky-logo" alt="<?php bloginfo( 'name' ); ?>">
                            <?php else: ?>
                                <h2 class="logo-option"><?php bloginfo( 'name' ); ?></h2>
                            <?php endif; ?>
                        </a>
                        <button class="navbar-toggler home1-one-toggle" data-bs-toggle="offcanvas" data-bs-target="#navbarOffcanvas">
                            <span class="burger-menu">
                                <span class="top-bar"></span>
                                <span class="middle-bar"></span>
                                <span class="bottom-bar"></span>
                            </span>
                        </button>
                        <div class="collapse navbar-collapse">
                            <ul class="social-list me-auto">
                                <?php falar_social_link(); ?>
                            </ul>
                            <?php
                                $primary_nav_arg = [
                                    'menu'            => 'primary',
                                    'theme_location'  => 'primary',
                                    'container'       => null,
                                    'menu_class'      => 'navbar-nav ms-auto',
                                    'depth'           => 3,
                                    'walker'          => new Falar_Bootstrap_Navwalker(),
                                    'fallback_cb'     => 'Falar_Bootstrap_Navwalker::fallback',
                                ];

                                if(has_nav_menu('primary')){
                                    wp_nav_menu($primary_nav_arg);
                                }
                            ?>
                            <div class="others-option d-flex align-items-center">
                                <?php if( $search_icon != '' ): ?>
                                    <div class="option-item">
                                        <div class="search-bar main-menu__search search-toggler">
                                            <a href="#" class="search-btn">
                                                <img src="<?php echo esc_url( $search_icon ); ?>" alt="image">
                                            </a>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if( $menu_icon != '' ): ?>
                                    <div class="option-item">
                                        <button class="btn side-bar-btn" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasWithBothOptions" aria-controls="offcanvasWithBothOptions">
                                            <img src="<?php echo esc_url( $menu_icon ); ?>" alt="svg">
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </nav>
                <!-- End Navbar Area -->

                <?php if($search_placeholder): ?>
                    <div class="search-popup">
                        <div class="search-popup-overlay search-toggler"></div>
                        <!-- /.search-popup__overlay -->
                        <div class="search-popup-content">
                            <form role="search" method="get" id="search1" action="<?php echo esc_url( home_url( '/' ) );?>" class="search-popup-form" >
                                <input type="text" class="form-control" value="<?php echo get_search_query(); ?>" name="s" id="s2" required  placeholder="<?php echo esc_attr( $search_placeholder ); ?>">
                                <button type="submit" aria-label="search submit" class="default-btn">
                                    <i class="ti ti-search"></i>
                                </button>
                            </form>
                        </div>
                        <!-- /.search-popup__content -->
                    </div>
                <?php endif; ?>

                <!-- Sidebar Area Start -->
                <div class="offcanvas offcanvas-end slide-bar-offcanvas" data-bs-scroll="true" tabindex="-1" id="offcanvasWithBothOptions">
                    <div class="offcanvas-body">
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"> <i class="flaticon-close"></i>
                        </button>
                        <div class="sidebar-warp">
                            <div class="join-luva-box" style="background-image:url(<?php echo esc_url($sidebar_top_bg); ?>);">
                                <?php if($sidebar_top_title): ?>
                                    <h3><?php echo esc_attr( $sidebar_top_title ); ?></h3>
                                <?php endif; ?>
                                <?php if($sidebar_top_content): ?>
                                    <p><?php echo esc_attr( $sidebar_top_content ); ?></p>
                                <?php endif; ?>
                                <?php if($sidebar_button_url): ?>
                                    <a href="<?php echo esc_attr( $sidebar_button_url ); ?>" class="default-btn">
                                        <?php echo esc_attr( $sidebar_button_text ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="directory-widget">
                                <?php if($directory_title): ?>
                                    <h3><?php echo esc_attr( $directory_title ); ?></h3>
                                <?php endif; ?>
                                <ul class="directory-list">
                                    <?php if($directory_list_url1): ?>
                                        <li>
                                            <a href="<?php echo esc_attr( $directory_list_url1 ); ?>"><?php echo esc_attr( $directory_list_text1 ); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($directory_list_url2): ?>
                                        <li>
                                            <a href="<?php echo esc_attr( $directory_list_url2 ); ?>"><?php echo esc_attr( $directory_list_text2 ); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($directory_list_url3): ?>
                                        <li>
                                            <a href="<?php echo esc_attr( $directory_list_url3 ); ?>"><?php echo esc_attr( $directory_list_text3 ); ?></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <?php if( $sidebar_blog_hideshow == false ): ?>
                                <div class="latest-side-news">
                                    <?php if($news_title): ?>
                                        <h3><?php echo esc_attr( $news_title ); ?></h3>
                                    <?php endif; ?>
                                    <?php
                                        $args = array(
                                            'posts_per_page' => 1, 
                                        );
                                        $recent_posts = new WP_Query($args);
                                    ?>

                                    <?php
                                        while ( $recent_posts->have_posts() ): $recent_posts->the_post();
                                        $id    = get_the_ID();
                                        $title = get_the_title( get_the_ID() );
                                    ?>
                                        <div class="blog-article-item">
                                            <?php
                                            $categories = get_the_category();
                                            if ($categories) {
                                                echo '<ul class="ps-0 mb-0 list-unstyled cat">';
                                                foreach ($categories as $category) {
                                                    echo '<li><a href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
                                                }
                                                echo '</ul>';
                                            }
                                            ?>
                                            <h3>
                                                <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="text-decoration-none">
                                                    <?php echo wp_kses_post($title); ?>
                                                </a>
                                            </h3>
                                            <ul class="article-list">
                                                <li><?php echo esc_html(get_the_date()); ?></li>
                                                <li><?php echo esc_html(falar_post_reading_time()); ?></li>
                                            </ul>
                                        </div>
                                    <?php endwhile; ?>
                                    <?php
                                        wp_reset_query();
                                    ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <!-- Sidebar Area End -->

                <!-- Start Responsive Navbar Area -->
                <div class="responsive-navbar offcanvas offcanvas-end border-0" data-bs-backdrop="static" tabindex="-1" id="navbarOffcanvas">
                    <div class="offcanvas-header">
                        <a class="logo d-inline-block" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <?php if( $logo != '' ): ?>
                                <img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                            <?php else: ?>
                                <h2 class="logo-option"><?php bloginfo( 'name' ); ?></h2>
                            <?php endif; ?>
                        </a>
                        <button type="button" class="close-btn bg-transparent position-relative lh-1 p-0 border-0" data-bs-dismiss="offcanvas" aria-label="Close">
                            <i class="ti ti-x"></i>
                        </button>
                    </div>
                    <div class="offcanvas-body">
                        <?php
                            $primary_nav_arg = [
                                'menu'            => 'primary',
                                'theme_location'  => 'primary',
                                'container'       => null,
                                'menu_class'      => 'navbar-nav',
                                'depth'           => 3,
                            ];

                            if(has_nav_menu('primary')){
                                wp_nav_menu($primary_nav_arg);
                            }
                        ?>
                        <div class="others-option d-flex align-items-center">
                            <?php if( $search_icon != '' ): ?>
                                <div class="option-item">
                                    <div class="search-bar main-menu__search search-toggler">
                                        <a href="#" class="search-btn">
                                            <img src="<?php echo esc_url( $search_icon ); ?>" alt="image">
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if( $menu_icon != '' ): ?>
                                <div class="option-item">
                                    <button class="btn side-bar-btn" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasWithBothOptions" aria-controls="offcanvasWithBothOptions">
                                        <img src="<?php echo esc_url( $menu_icon ); ?>" alt="svg">
                                    </button>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <!-- End Responsive Navbar Area -->
            <?php elseif($nav_style== 5): ?>
                <!-- Top Header Warp Start -->
                <?php if( $top_header_hideshow == false ): ?>
                    <div class="top-header-warp home4-header">
                        <div class="container-fluid">
                            <div class="row align-items-center">
                                <div class="col-lg-6">
                                    <div class="top-header-details">
                                        <ul class="social-list">
                                            <?php falar_social_link(); ?>
                                        </ul>
                                        <ul class="header-contact">
                                            <?php if($mail_address): ?>
                                                <li>
                                                    <i class="ti ti-mail"></i>
                                                    <a href="mailto:<?php echo esc_attr( $mail_address ); ?>"><?php echo esc_attr( $mail_address ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($phone_no): ?>
                                                <li>
                                                    <i class="ti ti-phone-call"></i>
                                                    <a href="tel:<?php echo esc_attr( $phone_no ); ?>"><?php echo esc_attr( $phone_no ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="top-header-link-details">
                                        <?php if($top_menu_url4): ?>
                                            <ul class="header-link">
                                                <?php if($top_menu_url1): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url1 ); ?>"><?php echo esc_attr( $top_menu_text1 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($top_menu_url2): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url2 ); ?>"><?php echo esc_attr( $top_menu_text2 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($top_menu_url3): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url3 ); ?>"><?php echo esc_attr( $top_menu_text3 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($top_menu_url4): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url4 ); ?>"><?php echo esc_attr( $top_menu_text4 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                            </ul>
                                        <?php endif; ?>
                                        <ul class="header-account">
                                            <?php if($top_button_url): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_button_url ); ?>"><?php echo esc_attr( $top_button_text ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <!-- Top Header Warp End -->

                <!-- Start Navbar Area -->
                <nav class="navbar navbar-expand-lg top-navbar home4-navbar <?php if ( is_user_logged_in() ) { echo esc_attr( $hide_adminbar ); } ?>" id="navbar">
                    <div class="container-fluid">
                        <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <?php if( $logo4 != '' ): ?>
                                <img src="<?php echo esc_url( $logo4 ); ?>" class="navbar-logo" alt="<?php bloginfo( 'name' ); ?>">
                            <?php else: ?>
                                <h2 class="logo-option"><?php bloginfo( 'name' ); ?></h2>
                            <?php endif; ?>
                        </a>
                        
                        <a class="navbar-toggler home1-one-toggler" data-bs-toggle="offcanvas" href="#navbarOffcanvas" role="button" aria-controls="navbarOffcanvas">
                            <span class="burger-menu">
                                <span class="top-bar"></span>
                                <span class="middle-bar"></span>
                                <span class="bottom-bar"></span>
                            </span>
                        </a>
                        <div class="collapse navbar-collapse">
                            <?php
                                $primary_nav_arg = [
                                    'menu'            => 'primary',
                                    'theme_location'  => 'primary',
                                    'container'       => null,
                                    'menu_class'      => 'navbar-nav me-auto',
                                    'depth'           => 3,
                                    'walker'          => new Falar_Bootstrap_Navwalker(),
                                    'fallback_cb'     => 'Falar_Bootstrap_Navwalker::fallback',
                                ];

                                if(has_nav_menu('primary')){
                                    wp_nav_menu($primary_nav_arg);
                                }
                            ?>
                            <div class="others-option d-flex align-items-center">

                                <div class="option-item">
                                    <div class="input-search">
                                        <form role="search" method="get" id="search1" action="<?php echo esc_url( home_url( '/' ) );?>" class="search-popup-form" >
                                            <input type="text" class="form-control" value="<?php echo get_search_query(); ?>" name="s" id="s2" required  placeholder="<?php echo esc_attr( $search_placeholder ); ?>">
                                            <?php if( $search_icon != '' ): ?>
                                                <button type="submit" class="form-search-btn">
                                                    <img src="<?php echo esc_url( $search_icon ); ?>" alt="image">
                                                </button>
                                            <?php endif; ?>
                                        </form>
                                    </div>
                                </div>

                                <?php if( $menu_icon != '' ): ?>
                                    <div class="option-item">
                                        <button class="btn side-bar-btn" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasWithBothOptions" aria-controls="offcanvasWithBothOptions">
                                            <img src="<?php echo esc_url( $menu_icon ); ?>" alt="svg">
                                        </button>
                                    </div>
                                <?php endif; ?>

                            </div>
                        </div>

                    </div>
                </nav>
                <!-- End Navbar Area -->

                <!-- Sidebar Area Start -->
                <div class="offcanvas offcanvas-end slide-bar-offcanvas" data-bs-scroll="true" tabindex="-1" id="offcanvasWithBothOptions">
                    <div class="offcanvas-body">
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"> <i class="flaticon-close"></i>
                        </button>
                        <div class="sidebar-warp">
                            <div class="join-luva-box" style="background-image:url(<?php echo esc_url($sidebar_top_bg); ?>);">
                                <?php if($sidebar_top_title): ?>
                                    <h3><?php echo esc_attr( $sidebar_top_title ); ?></h3>
                                <?php endif; ?>
                                <?php if($sidebar_top_content): ?>
                                    <p><?php echo esc_attr( $sidebar_top_content ); ?></p>
                                <?php endif; ?>
                                <?php if($sidebar_button_url): ?>
                                    <a href="<?php echo esc_attr( $sidebar_button_url ); ?>" class="default-btn">
                                        <?php echo esc_attr( $sidebar_button_text ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="directory-widget">
                                <?php if($directory_title): ?>
                                    <h3><?php echo esc_attr( $directory_title ); ?></h3>
                                <?php endif; ?>
                                <ul class="directory-list">
                                    <?php if($directory_list_url1): ?>
                                        <li>
                                            <a href="<?php echo esc_attr( $directory_list_url1 ); ?>"><?php echo esc_attr( $directory_list_text1 ); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($directory_list_url2): ?>
                                        <li>
                                            <a href="<?php echo esc_attr( $directory_list_url2 ); ?>"><?php echo esc_attr( $directory_list_text2 ); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($directory_list_url3): ?>
                                        <li>
                                            <a href="<?php echo esc_attr( $directory_list_url3 ); ?>"><?php echo esc_attr( $directory_list_text3 ); ?></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <?php if( $sidebar_blog_hideshow == false ): ?>
                                <div class="latest-side-news">
                                    <?php if($news_title): ?>
                                        <h3><?php echo esc_attr( $news_title ); ?></h3>
                                    <?php endif; ?>
                                    <?php
                                        $args = array(
                                            'posts_per_page' => 1, 
                                        );
                                        $recent_posts = new WP_Query($args);
                                    ?>

                                    <?php
                                        while ( $recent_posts->have_posts() ): $recent_posts->the_post();
                                        $id    = get_the_ID();
                                        $title = get_the_title( get_the_ID() );
                                    ?>
                                        <div class="blog-article-item">
                                            <?php
                                            $categories = get_the_category();
                                            if ($categories) {
                                                echo '<ul class="ps-0 mb-0 list-unstyled cat">';
                                                foreach ($categories as $category) {
                                                    echo '<li><a href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
                                                }
                                                echo '</ul>';
                                            }
                                            ?>
                                            <h3>
                                                <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="text-decoration-none">
                                                    <?php echo wp_kses_post($title); ?>
                                                </a>
                                            </h3>
                                            <ul class="article-list">
                                                <li><?php echo esc_html(get_the_date()); ?></li>
                                                <li><?php echo esc_html(falar_post_reading_time()); ?></li>
                                            </ul>
                                        </div>
                                    <?php endwhile; ?>
                                    <?php
                                        wp_reset_query();
                                    ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <!-- Sidebar Area End -->

                <!-- Start Responsive Navbar Area -->
                <div class="responsive-navbar offcanvas offcanvas-end border-0" data-bs-backdrop="static" tabindex="-1" id="navbarOffcanvas">
                    <div class="offcanvas-header">
                        <a class="logo d-inline-block" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <?php if( $logo != '' ): ?>
                                <img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                            <?php else: ?>
                                <h2 class="logo-option"><?php bloginfo( 'name' ); ?></h2>
                            <?php endif; ?>
                        </a>
                        <button type="button" class="close-btn bg-transparent position-relative lh-1 p-0 border-0" data-bs-dismiss="offcanvas" aria-label="Close">
                            <i class="ti ti-x"></i>
                        </button>
                    </div>
                    <div class="offcanvas-body">
                        <?php
                            $primary_nav_arg = [
                                'menu'            => 'primary',
                                'theme_location'  => 'primary',
                                'container'       => null,
                                'menu_class'      => 'navbar-nav',
                                'depth'           => 3,
                            ];

                            if(has_nav_menu('primary')){
                                wp_nav_menu($primary_nav_arg);
                            }
                        ?>
                        <div class="others-option d-flex align-items-center">
                            <?php if( $search_icon != '' ): ?>
                                <div class="option-item">
                                    <div class="search-bar main-menu__search search-toggler">
                                        <a href="#" class="search-btn">
                                            <img src="<?php echo esc_url( $search_icon ); ?>" alt="image">
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if( $menu_icon != '' ): ?>
                                <div class="option-item">
                                    <button class="btn side-bar-btn" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasWithBothOptions" aria-controls="offcanvasWithBothOptions">
                                        <img src="<?php echo esc_url( $menu_icon ); ?>" alt="svg">
                                    </button>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <!-- End Responsive Navbar Area -->
            <?php elseif($nav_style== 6): ?>
                <!-- Top Header Warp Start -->
                <div class="top-header-warp home4-header">
                    <div class="container-fluid">
                        <div class="row align-items-center">
                            <div class="col-lg-3">
                                <div class="home-logo only-main-device">
                                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                        <?php if( $logo5 != '' ): ?>
                                            <img src="<?php echo esc_url( $logo5 ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                                        <?php else: ?>
                                            <h2 class="logo-option"><?php bloginfo( 'name' ); ?></h2>
                                        <?php endif; ?>
                                    </a>
                                </div>
                            </div>
                            <div class="col-lg-9">
                                <div class="top-header-link-details home-five-header">
                                    <ul class="header-contact">
                                        <?php if($mail_address): ?>
                                            <li>
                                                <i class="ti ti-mail"></i>
                                                <a href="mailto:<?php echo esc_attr( $mail_address ); ?>"><?php echo esc_attr( $mail_address ); ?></a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if($phone_no): ?>
                                            <li>
                                                <i class="ti ti-phone-call"></i>
                                                <a href="tel:<?php echo esc_attr( $phone_no ); ?>"><?php echo esc_attr( $phone_no ); ?></a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                    <?php if($top_menu_url4): ?>
                                        <ul class="header-link">
                                            <?php if($top_menu_url1): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_menu_url1 ); ?>"><?php echo esc_attr( $top_menu_text1 ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($top_menu_url2): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_menu_url2 ); ?>"><?php echo esc_attr( $top_menu_text2 ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($top_menu_url3): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_menu_url3 ); ?>"><?php echo esc_attr( $top_menu_text3 ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($top_menu_url4): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_menu_url4 ); ?>"><?php echo esc_attr( $top_menu_text4 ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    <?php endif; ?>
                                    <ul class="header-account">
                                        <?php if($top_button_url): ?>
                                            <li>
                                                <a href="<?php echo esc_attr( $top_button_url ); ?>"><?php echo esc_attr( $top_button_text ); ?></a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Top Header Warp End -->

                <!-- Start Navbar Area -->
                <nav class="navbar navbar-expand-lg top-navbar home-five-navbar <?php if ( is_user_logged_in() ) { echo esc_attr( $hide_adminbar ); } ?>" id="navbar">
                    <div class="container-fluid">
                        <div class="home-logo only-responsive-device">
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                <?php if( $logo5 != '' ): ?>
                                    <img src="<?php echo esc_url( $logo5 ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                                <?php else: ?>
                                    <h2 class="logo-option"><?php bloginfo( 'name' ); ?></h2>
                                <?php endif; ?>
                            </a>
                        </div>
                        <a class="navbar-toggler home1-one-toggler" data-bs-toggle="offcanvas" href="#navbarOffcanvas" role="button" aria-controls="navbarOffcanvas">
                            <span class="burger-menu">
                                <span class="top-bar"></span>
                                <span class="middle-bar"></span>
                                <span class="bottom-bar"></span>
                            </span>
                        </a>
                        <div class="collapse navbar-collapse">
                            <?php
                                $primary_nav_arg = [
                                    'menu'            => 'primary',
                                    'theme_location'  => 'primary',
                                    'container'       => null,
                                    'menu_class'      => 'navbar-nav me-auto',
                                    'depth'           => 3,
                                    'walker'          => new Falar_Bootstrap_Navwalker(),
                                    'fallback_cb'     => 'Falar_Bootstrap_Navwalker::fallback',
                                ];

                                if(has_nav_menu('primary')){
                                    wp_nav_menu($primary_nav_arg);
                                }
                            ?>
                            <div class="others-option d-flex align-items-center">

                                <div class="option-item">
                                    <div class="input-search">
                                        <form role="search" method="get" id="search1" action="<?php echo esc_url( home_url( '/' ) );?>">
                                            <input type="text" class="form-control" value="<?php echo get_search_query(); ?>" name="s" id="s2" required  placeholder="<?php echo esc_attr( $search_placeholder ); ?>">
                                            <?php if( $search_icon != '' ): ?>
                                                <button type="submit" class="form-search-btn">
                                                    <img src="<?php echo esc_url( $search_icon ); ?>" alt="image">
                                                </button>
                                            <?php endif; ?>
                                        </form>
                                    </div>
                                </div>

                                <?php if( $menu_icon != '' ): ?>
                                    <div class="option-item">
                                        <button class="btn side-bar-btn" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasWithBothOptions" aria-controls="offcanvasWithBothOptions">
                                            <img src="<?php echo esc_url( $menu_icon ); ?>" alt="svg">
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                    </div>
                </nav>
                <!-- End Navbar Area -->

                <!-- Sidebar Area Start -->
                <div class="offcanvas offcanvas-end slide-bar-offcanvas" data-bs-scroll="true" tabindex="-1" id="offcanvasWithBothOptions">
                    <div class="offcanvas-body">
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"> <i class="flaticon-close"></i>
                        </button>
                        <div class="sidebar-warp">
                            <div class="join-luva-box" style="background-image:url(<?php echo esc_url($sidebar_top_bg); ?>);">
                                <?php if($sidebar_top_title): ?>
                                    <h3><?php echo esc_attr( $sidebar_top_title ); ?></h3>
                                <?php endif; ?>
                                <?php if($sidebar_top_content): ?>
                                    <p><?php echo esc_attr( $sidebar_top_content ); ?></p>
                                <?php endif; ?>
                                <?php if($sidebar_button_url): ?>
                                    <a href="<?php echo esc_attr( $sidebar_button_url ); ?>" class="default-btn">
                                        <?php echo esc_attr( $sidebar_button_text ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="directory-widget">
                                <?php if($directory_title): ?>
                                    <h3><?php echo esc_attr( $directory_title ); ?></h3>
                                <?php endif; ?>
                                <ul class="directory-list">
                                    <?php if($directory_list_url1): ?>
                                        <li>
                                            <a href="<?php echo esc_attr( $directory_list_url1 ); ?>"><?php echo esc_attr( $directory_list_text1 ); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($directory_list_url2): ?>
                                        <li>
                                            <a href="<?php echo esc_attr( $directory_list_url2 ); ?>"><?php echo esc_attr( $directory_list_text2 ); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($directory_list_url3): ?>
                                        <li>
                                            <a href="<?php echo esc_attr( $directory_list_url3 ); ?>"><?php echo esc_attr( $directory_list_text3 ); ?></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <?php if( $sidebar_blog_hideshow == false ): ?>
                                <div class="latest-side-news">
                                    <?php if($news_title): ?>
                                        <h3><?php echo esc_attr( $news_title ); ?></h3>
                                    <?php endif; ?>
                                    <?php
                                        $args = array(
                                            'posts_per_page' => 1, 
                                        );
                                        $recent_posts = new WP_Query($args);
                                    ?>

                                    <?php
                                        while ( $recent_posts->have_posts() ): $recent_posts->the_post();
                                        $id    = get_the_ID();
                                        $title = get_the_title( get_the_ID() );
                                    ?>
                                        <div class="blog-article-item">
                                            <?php
                                            $categories = get_the_category();
                                            if ($categories) {
                                                echo '<ul class="ps-0 mb-0 list-unstyled cat">';
                                                foreach ($categories as $category) {
                                                    echo '<li><a href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
                                                }
                                                echo '</ul>';
                                            }
                                            ?>
                                            <h3>
                                                <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="text-decoration-none">
                                                    <?php echo wp_kses_post($title); ?>
                                                </a>
                                            </h3>
                                            <ul class="article-list">
                                                <li><?php echo esc_html(get_the_date()); ?></li>
                                                <li><?php echo esc_html(falar_post_reading_time()); ?></li>
                                            </ul>
                                        </div>
                                    <?php endwhile; ?>
                                    <?php
                                        wp_reset_query();
                                    ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <!-- Sidebar Area End -->

                <!-- Start Responsive Navbar Area -->
                <div class="responsive-navbar offcanvas offcanvas-end border-0" data-bs-backdrop="static" tabindex="-1" id="navbarOffcanvas">
                    <div class="offcanvas-header">
                        <a class="logo d-inline-block" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <?php if( $logo != '' ): ?>
                                <img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                            <?php else: ?>
                                <h2 class="logo-option"><?php bloginfo( 'name' ); ?></h2>
                            <?php endif; ?>
                        </a>
                        <button type="button" class="close-btn bg-transparent position-relative lh-1 p-0 border-0" data-bs-dismiss="offcanvas" aria-label="Close">
                            <i class="ti ti-x"></i>
                        </button>
                    </div>
                    <div class="offcanvas-body">
                        <?php
                            $primary_nav_arg = [
                                'menu'            => 'primary',
                                'theme_location'  => 'primary',
                                'container'       => null,
                                'menu_class'      => 'navbar-nav',
                                'depth'           => 3,
                            ];

                            if(has_nav_menu('primary')){
                                wp_nav_menu($primary_nav_arg);
                            }
                        ?>
                        <div class="others-option d-flex align-items-center">
                            <?php if( $search_icon != '' ): ?>
                                <div class="option-item">
                                    <div class="search-bar main-menu__search search-toggler">
                                        <a href="#" class="search-btn">
                                            <img src="<?php echo esc_url( $search_icon ); ?>" alt="image">
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if( $menu_icon != '' ): ?>
                                <div class="option-item">
                                    <button class="btn side-bar-btn" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasWithBothOptions" aria-controls="offcanvasWithBothOptions">
                                        <img src="<?php echo esc_url( $menu_icon ); ?>" alt="svg">
                                    </button>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <!-- End Responsive Navbar Area -->
            <?php else: ?>
                <?php if( $top_header_hideshow == false ): ?>
                    <!-- Top Header Warp Start -->
                    <div class="top-header-warp">
                        <div class="container-fluid">
                            <div class="row align-items-center">
                                <div class="col-lg-6">
                                    <div class="top-header-details">
                                        <?php if($mail_address): ?>
                                            <ul class="social-list">
                                                <?php falar_social_link(); ?>
                                            </ul>
                                        <?php endif; ?>
                                        <ul class="header-contact">
                                            <?php if($mail_address): ?>
                                                <li>
                                                    <i class="ti ti-mail"></i>
                                                    <a href="mailto:<?php echo esc_attr( $mail_address ); ?>"><?php echo esc_attr( $mail_address ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if($phone_no): ?>
                                                <li>
                                                    <i class="ti ti-phone-call"></i>
                                                    <a href="tel:<?php echo esc_attr( $phone_no ); ?>"><?php echo esc_attr( $phone_no ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="top-header-link-details">
                                        <?php if($top_menu_url4): ?>
                                            <ul class="header-link">
                                                <?php if($top_menu_url1): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url1 ); ?>"><?php echo esc_attr( $top_menu_text1 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($top_menu_url2): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url2 ); ?>"><?php echo esc_attr( $top_menu_text2 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($top_menu_url3): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url3 ); ?>"><?php echo esc_attr( $top_menu_text3 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($top_menu_url4): ?>
                                                    <li>
                                                        <a href="<?php echo esc_attr( $top_menu_url4 ); ?>"><?php echo esc_attr( $top_menu_text4 ); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                            </ul>
                                        <?php endif; ?>
                                        <ul class="header-account">
                                            <?php if($top_button_url): ?>
                                                <li>
                                                    <a href="<?php echo esc_attr( $top_button_url ); ?>"><?php echo esc_attr( $top_button_text ); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Top Header Warp End -->
                <?php endif; ?>

                <!-- Start Navbar Area -->
                <nav class="navbar navbar-expand-lg top-navbar inner-navbar <?php if ( is_user_logged_in() ) { echo esc_attr( $hide_adminbar ); } ?>" id="navbar">
                    <div class="container-fluid">
                        <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <?php if( $logo2 != '' ): ?>
                                <img src="<?php echo esc_url( $logo2 ); ?>" class="navbar-logo" alt="<?php bloginfo( 'name' ); ?>">
                            <?php else: ?>
                                <h2 class="logo-option"><?php bloginfo( 'name' ); ?></h2>
                            <?php endif; ?>
                        </a>
                        <button class="navbar-toggler home1-one-toggler" data-bs-toggle="offcanvas" data-bs-target="#navbarOffcanvas">
                            <span class="burger-menu">
                                <span class="top-bar"></span>
                                <span class="middle-bar"></span>
                                <span class="bottom-bar"></span>
                            </span>
                        </button>
                        <div class="collapse navbar-collapse">
                            <?php
                                $left_menu_arg = [
                                    'menu'            => 'left_menu',
                                    'theme_location'  => 'left_menu',
                                    'container'       => null,
                                    'menu_class'      => 'navbar-nav me-auto navbar-style2',
                                    'depth'           => 3,
                                    'walker'          => new Falar_Bootstrap_Navwalker(),
                                    'fallback_cb'     => 'Falar_Bootstrap_Navwalker::fallback',
                                ];

                                if(has_nav_menu('left_menu')){
                                    wp_nav_menu($left_menu_arg);
                                }
                            ?>
                            <?php
                                $right_menu_arg = [
                                    'menu'            => 'right_menu',
                                    'theme_location'  => 'right_menu',
                                    'container'       => null,
                                    'menu_class'      => 'navbar-nav ms-auto',
                                    'depth'           => 3,
                                    'walker'          => new Falar_Bootstrap_Navwalker(),
                                    'fallback_cb'     => 'Falar_Bootstrap_Navwalker::fallback',
                                ];

                                if(has_nav_menu('right_menu')){
                                    wp_nav_menu($right_menu_arg);
                                }
                            ?>
                            <div class="others-option d-flex align-items-center">
                                <?php if( $search_icon != '' ): ?>
                                    <div class="option-item">
                                        <div class="search-bar main-menu__search search-toggler">
                                            <a href="#" class="search-btn">
                                                <img src="<?php echo esc_url( $search_icon ); ?>" alt="image">
                                            </a>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if( $menu_icon != '' ): ?>
                                    <div class="option-item">
                                        <button class="btn side-bar-btn" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasWithBothOptions" aria-controls="offcanvasWithBothOptions">
                                            <img src="<?php echo esc_url( $menu_icon ); ?>" alt="svg">
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </nav>
                <!-- End Navbar Area -->

                <?php if($search_placeholder): ?>
                    <div class="search-popup">
                        <div class="search-popup-overlay search-toggler"></div>
                        <!-- /.search-popup__overlay -->
                        <div class="search-popup-content">
                            <form role="search" method="get" id="search1" action="<?php echo esc_url( home_url( '/' ) );?>" class="search-popup-form" >
                                <input type="text" class="form-control" value="<?php echo get_search_query(); ?>" name="s" id="s2" required  placeholder="<?php echo esc_attr( $search_placeholder ); ?>">
                                <button type="submit" aria-label="search submit" class="default-btn">
                                    <i class="ti ti-search"></i>
                                </button>
                            </form>
                        </div>
                        <!-- /.search-popup__content -->
                    </div>
                <?php endif; ?>

                <!-- Sidebar Area Start -->
                <div class="offcanvas offcanvas-end slide-bar-offcanvas" data-bs-scroll="true" tabindex="-1" id="offcanvasWithBothOptions">
                    <div class="offcanvas-body">
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"> <i class="flaticon-close"></i>
                        </button>
                        <div class="sidebar-warp">
                            <div class="join-luva-box" style="background-image:url(<?php echo esc_url($sidebar_top_bg); ?>);">
                                <?php if($sidebar_top_title): ?>
                                    <h3><?php echo esc_attr( $sidebar_top_title ); ?></h3>
                                <?php endif; ?>
                                <?php if($sidebar_top_content): ?>
                                    <p><?php echo esc_attr( $sidebar_top_content ); ?></p>
                                <?php endif; ?>
                                <?php if($sidebar_button_url): ?>
                                    <a href="<?php echo esc_attr( $sidebar_button_url ); ?>" class="default-btn">
                                        <?php echo esc_attr( $sidebar_button_text ); ?>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="directory-widget">
                                <?php if($directory_title): ?>
                                    <h3><?php echo esc_attr( $directory_title ); ?></h3>
                                <?php endif; ?>
                                <ul class="directory-list">
                                    <?php if($directory_list_url1): ?>
                                        <li>
                                            <a href="<?php echo esc_attr( $directory_list_url1 ); ?>"><?php echo esc_attr( $directory_list_text1 ); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($directory_list_url2): ?>
                                        <li>
                                            <a href="<?php echo esc_attr( $directory_list_url2 ); ?>"><?php echo esc_attr( $directory_list_text2 ); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($directory_list_url3): ?>
                                        <li>
                                            <a href="<?php echo esc_attr( $directory_list_url3 ); ?>"><?php echo esc_attr( $directory_list_text3 ); ?></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <?php if( $sidebar_blog_hideshow == false ): ?>
                                <div class="latest-side-news">
                                    <?php if($news_title): ?>
                                        <h3><?php echo esc_attr( $news_title ); ?></h3>
                                    <?php endif; ?>
                                    <?php
                                        $args = array(
                                            'posts_per_page' => 1, 
                                        );
                                        $recent_posts = new WP_Query($args);
                                    ?>

                                    <?php
                                        while ( $recent_posts->have_posts() ): $recent_posts->the_post();
                                        $id    = get_the_ID();
                                        $title = get_the_title( get_the_ID() );
                                    ?>
                                        <div class="blog-article-item">
                                            <?php
                                            $categories = get_the_category();
                                            if ($categories) {
                                                echo '<ul class="ps-0 mb-0 list-unstyled cat">';
                                                foreach ($categories as $category) {
                                                    echo '<li><a href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
                                                }
                                                echo '</ul>';
                                            }
                                            ?>
                                            <h3>
                                                <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="text-decoration-none">
                                                    <?php echo wp_kses_post($title); ?>
                                                </a>
                                            </h3>
                                            <ul class="article-list">
                                                <li><?php echo esc_html(get_the_date()); ?></li>
                                                <li><?php echo esc_html(falar_post_reading_time()); ?></li>
                                            </ul>
                                        </div>
                                    <?php endwhile; ?>
                                    <?php
                                        wp_reset_query();
                                    ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <!-- Sidebar Area End -->

                <!-- Start Responsive Navbar Area -->
                <div class="responsive-navbar offcanvas offcanvas-end border-0" data-bs-backdrop="static" tabindex="-1" id="navbarOffcanvas">
                    <div class="offcanvas-header">
                        <a class="logo d-inline-block" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <?php if( $logo != '' ): ?>
                                <img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                            <?php else: ?>
                                <h2 class="logo-option"><?php bloginfo( 'name' ); ?></h2>
                            <?php endif; ?>
                        </a>
                        <button type="button" class="close-btn bg-transparent position-relative lh-1 p-0 border-0" data-bs-dismiss="offcanvas" aria-label="Close">
                            <i class="ti ti-x"></i>
                        </button>
                    </div>
                    <div class="offcanvas-body">
                        <?php
                            $primary_nav_arg = [
                                'menu'            => 'primary',
                                'theme_location'  => 'primary',
                                'container'       => null,
                                'menu_class'      => 'navbar-nav',
                                'depth'           => 3,
                            ];

                            if(has_nav_menu('primary')){
                                wp_nav_menu($primary_nav_arg);
                            }
                        ?>
                        <div class="others-option d-flex align-items-center">
                            <?php if( $search_icon != '' ): ?>
                                <div class="option-item">
                                    <div class="search-bar main-menu__search search-toggler">
                                        <a href="#" class="search-btn">
                                            <img src="<?php echo esc_url( $search_icon ); ?>" alt="image">
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if( $menu_icon != '' ): ?>
                                <div class="option-item">
                                    <button class="btn side-bar-btn" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasWithBothOptions" aria-controls="offcanvasWithBothOptions">
                                        <img src="<?php echo esc_url( $menu_icon ); ?>" alt="svg">
                                    </button>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <!-- End Responsive Navbar Area -->
            <?php endif; ?>	
        <?php
    }
}