<?php
/**
 * Search Style
 * @package WordPress
 * @subpackage Falar
*/
if ( ! function_exists( 'falar_theme_search_content' ) ) {
	function falar_theme_search_content() {
        
        global $falar_opt;

        // Blog sidebar
        if(isset($falar_opt['falar_blog_sidebar'])) {
            if( $falar_opt['falar_blog_sidebar'] == 'falar_without_sidebar_center' ):
                $falar_sidebar_class = 'col-lg-12 col-md-12';
            elseif( $falar_opt['falar_blog_sidebar'] == 'falar_without_sidebar' ):
                $falar_sidebar_class = 'col-lg-12 col-md-12';
            else:
                if( is_active_sidebar( 'sidebar-1' ) ):
                    $falar_sidebar_class = 'col-lg-8 col-md-12';
                else:
                    $falar_sidebar_class = 'col-lg-8 col-md-12';
                endif;
            endif;
            $sidebar_hide = $falar_opt['falar_blog_sidebar'];
        } else {
            if( is_active_sidebar( 'sidebar-1' ) ):
                $falar_sidebar_class = 'col-lg-8 col-md-12';
                $sidebar_hide = 'falar_with_sidebar';
            else:
                $falar_sidebar_class = 'col-lg-12 col-md-12';
                $sidebar_hide = 'falar_without_sidebar';
            endif;
        }

        // Blog breadcrumb
        if( isset($falar_opt['blog_title']) ) {
            $title                  = $falar_opt['blog_title'];
            $top_title              = $falar_opt['blog_top_title'];
            $hide_page_title    	= $falar_opt['hide_page_title'];
            $hide_breadcrumb    	= $falar_opt['hide_breadcrumb'];
            $hide_blog_banner       = $falar_opt['hide_blog_banner'];
            $blog_banner_shape      = $falar_opt['blog_banner_shape']['url'];
        } else {
            $hide_page_title    	= false;
            $hide_breadcrumb    	= 	false;
            $hide_blog_banner       = false;
            $title           		= '';
            $top_title           	= '';
            $blog_banner_shape      = false;
        }

        // Blog page link
        if ( get_option( 'page_for_posts' ) ) {
            $blog_link = get_permalink( get_option( 'page_for_posts' ));
        }else{
            $blog_link = home_url( '/' );
        }

        $falar_blog_layout = !empty($falar_opt['falar_blog_layout']) ? $falar_opt['falar_blog_layout'] : 'container';
        if( isset($falar_opt['page_title_tag']) ):
            $tag = $falar_opt['page_title_tag'];
        else:
            $tag = 'h2';
        endif;
        ?>

        <?php if( $hide_blog_banner == false ): ?>
            <div class="inner-heros-warp">
                <div class="container-fluid">
                    <div class="inner-hero-content row">
                        <div class="col-lg-7">
                            <?php if( $hide_page_title == false ): ?>
                                <?php if( isset($tag) ): ?>
                                    <<?php echo esc_attr( $tag ); ?>><?php printf( esc_html__( 'Search Results for: %s', 'falar' ), '<span>' . get_search_query() . '</span>' ); ?></<?php echo esc_attr( $tag ); ?>>
                                <?php else: ?>
                                    <<?php echo esc_attr( $tag ); ?>><?php esc_html_e('No Title', 'falar'); ?></<?php echo esc_attr( $tag ); ?>>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <div class="col-lg-5 text-end">
                            <?php if( $hide_breadcrumb == false ): ?>
                                <?php
                                    if ( function_exists('yoast_breadcrumb') ) {
                                        yoast_breadcrumb( '<p class="falar-seo-breadcrumbs" id="breadcrumbs">','</p>' );
                                    } else { ?>
                                        <ul class="inner-hero-list">
                                        <li class="d-inline-block position-relative text-uppercase"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'falar' ); ?></a></li>
                                            <li class="d-inline-block position-relative text-uppercase active"><?php printf( esc_html__( 'Search Results for: %s', 'falar' ), '<span>' . get_search_query() . '</span>' ); ?></li>
                                        </ul>
                                    <?php
                                }
                            endif; 
                            ?>
                        </div>
                    </div>
                </div>
                <div class="all-shapes">
                    <?php if($blog_banner_shape):  ?>
                        <img src="<?php echo esc_url($blog_banner_shape) ?>" class="inner-page-shape1" alt="<?php echo esc_attr__( 'images', 'falar' ); ?>">
                        <?php else: ?>
                            <img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/inner-page-shape1.png') ?>" class="inner-page-shape1" alt="Shape">
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>

        <!-- Start Blog Area -->
        <div class="blog-area ptb-100">
            <div class="container">
                <div class="row">
                    <!-- Start Blog Content -->
                    <div class="<?php echo esc_attr( $falar_sidebar_class ); ?>">
                        <div class="row">
                            <?php
                            if ( have_posts() ) :
                                while ( have_posts() ) :
                                    the_post();
                                    get_template_part( 'template-parts/content', get_post_format());
                                endwhile;
                            else :
                                get_template_part( 'template-parts/content', 'none' );
                            endif;
                            ?>
                        </div>
                        <?php if(paginate_links()): ?>
                                <!-- Stat Pagination -->
                                <div class="col-lg-12 col-md-12">
                                    <div class="pagination-area">
                                        <?php echo paginate_links( array(
                                            'format'    => '?paged=%#%',
                                            'prev_text' => '<i class="ri-arrow-left-s-line"></i>',
                                            'end_size'  => 0,
                                            'mid_size'  => 1,
                                            'next_text' => '<i class="ri-arrow-right-s-line"></i>',
                                                )
                                            ) ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                    </div>
                    <!-- End Blog Content -->

                    <?php 
                        if( $sidebar_hide == 'falar_with_sidebar' ){
                            get_sidebar();
                        }
                    ?>
                </div>
            </div>
        </div>
        <!-- End Blog Area -->
        <?php
    }
}