<?php
/**
 * Single Program 
 * @package WordPress
 * @subpackage Falar
*/
if ( ! function_exists( 'falar_theme_single_program_content' ) ) {
	function falar_theme_single_program_content() {
        
        global $falar_opt;
        $title = get_the_title();

        // Single Program breadcrumb
        if( isset($falar_opt['hide_program_banner']) ) {
            $hide_program_title        = $falar_opt['hide_program_title'];
            $hide_program_breadcrumb   = $falar_opt['hide_program_breadcrumb'];
            $hide_program_banner       = $falar_opt['hide_program_banner'];
            $program_banner_shape      = $falar_opt['program_banner_shape']['url'];
        } else {
            $hide_program_title        = false;
            $hide_program_breadcrumb   = false;
            $hide_program_banner       = false;
            $program_banner_shape      = false;
        }
        
        // Single Program Tags
        if( isset($falar_opt['page_title_tag']) ):
            $tag = $falar_opt['page_title_tag'];
        else:
            $tag = 'h3';
        endif;
        ?>

        <?php if( $hide_program_banner == false ): ?>
            <div class="inner-heros-warp">
                <div class="container-fluid">
                    <div class="inner-hero-content">
                        <?php if( $hide_program_title == false ): ?>
                            <?php if( isset($tag) ): ?>
                                <<?php echo esc_attr( $tag ); ?>><?php echo esc_html( $title ); ?></<?php echo esc_attr( $tag ); ?>>
                                <?php else: ?>
                                    <<?php echo esc_attr( $tag ); ?>><?php esc_html_e('No TiTle', 'falar'); ?></<?php echo esc_attr( $tag ); ?>>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php if( $hide_program_breadcrumb == false ): ?>
                            <?php
                                if ( function_exists('yoast_breadcrumb') ) {
                                    yoast_breadcrumb( '<p class="falar-seo-breadcrumbs" id="breadcrumbs">','</p>' );
                                } else { ?>
                                    <ul class="inner-hero-list">
                                        <li class="d-inline-block position-relative"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'falar' ); ?></a></li>
                                            <li class="d-inline-block position-relative"><a href="<?php echo esc_url( home_url( '/all-programs/' ) ); ?>"><?php esc_html_e('Program', 'falar'); ?></a></li>
                                            <li class="d-inline-block position-relative active"><?php the_title(); ?></li>
                                        <?php ?>                        
                                    </ul>
                                <?php
                                }
                        endif; ?>
                    </div>
                </div>
                <div class="all-shapes">
				<?php if($program_banner_shape):  ?>
					<img src="<?php echo esc_url($program_banner_shape) ?>" class="inner-page-shape1" alt="<?php echo esc_attr__( 'images', 'falar' ); ?>">
					<?php else: ?>
						<img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/inner-page-shape1.png') ?>" class="inner-page-shape1" alt="Shape">
				<?php endif; ?>
                </div>
            </div>
        <?php endif; ?>

        <?php if( !falar_is_elementor()): ?><section class="program-details-area"><?php endif; ?>
            <?php 
                while ( have_posts() ) : the_post();
                    the_content();
                endwhile;
        if( !falar_is_elementor()): ?></section><?php endif;
    }
}