<?php
/**
 * Single Style
 * @package WordPress
 * @subpackage Falar
*/
if ( ! function_exists( 'falar_theme_single_content' ) ) {
	function falar_theme_single_content() {

        global $falar_opt;
		global $post;

        $title = get_the_title();

        // Blog Sidebar
        if(isset($falar_opt['falar_single_blog_sidebar'])) {
            if( $falar_opt['falar_single_blog_sidebar'] == 'falar_without_sidebar_center' ):
                $falar_sidebar_class = 'col-lg-8 col-md-12';
            elseif( $falar_opt['falar_single_blog_sidebar'] == 'falar_without_sidebar' ):
                $falar_sidebar_class = 'col-lg-12 col-md-12';
            else:
                if( is_active_sidebar( 'sidebar-1' ) ):
                    $falar_sidebar_class = 'col-lg-8 col-md-12';
                else:
                    $falar_sidebar_class = 'col-lg-8 col-md-12';
                endif;
            endif;
            $sidebar_hide = $falar_opt['falar_single_blog_sidebar'];
        } else {
            if( is_active_sidebar( 'sidebar-1' ) ):
                $falar_sidebar_class = 'col-lg-8 col-md-12';
                $sidebar_hide        = 'falar_with_sidebar';
            else:
                $falar_sidebar_class = 'col-lg-8 col-md-12';
                $sidebar_hide        = 'falar_without_sidebar';
            endif;
        }

        // Blog Breadcrumb
        if( isset($falar_opt['blog_title']) ) {
            $hide_page_title    	= $falar_opt['hide_page_title'];
            $hide_breadcrumb    	= $falar_opt['hide_breadcrumb'];
            $hide_blog_banner       = $falar_opt['hide_blog_banner'];
            $social_title           = $falar_opt['social_title'];
            $blog_banner_shape      = $falar_opt['blog_banner_shape']['url'];
        } else {
            $hide_page_title    	= false;
            $hide_breadcrumb    	= false;
            $hide_blog_banner       = false;
            $social_title           = '';
            $blog_banner_shape      = false;
        }

        // Blog Page Link
        if ( get_option( 'page_for_posts' ) ) {
            $blog_link = get_permalink( get_option( 'page_for_posts' ));
        }else{
            $blog_link = home_url( '/' );
        }

        $falar_blog_single_layout = !empty($falar_opt['falar_blog_single_layout']) ? $falar_opt['falar_blog_single_layout'] : 'container';

        if( isset($falar_opt['page_title_tag']) ):
            $tag = $falar_opt['page_title_tag'];
        else:
            $tag = 'h3';
        endif;

        if( isset( $falar_opt['single_blog_falar_social_target'] ) ) {
            $target = $falar_opt['single_blog_falar_social_target'];
        }else {
            $target = '_blank';
        }

        // Category 
        $falar_blog_category = get_the_terms(get_the_ID(), 'category');

        if($falar_blog_category && ! is_wp_error( $falar_blog_category )) {
            $blog_cat_list = array();
            
            foreach($falar_blog_category as $category) {
                $blog_cat_list[] = $category->name; 
                $category_link   = get_category_link($category);
                $category_ass    ='<a href="' . esc_url($category_link) .'">' . esc_html($category->name) . ' </a>';
            }
        } 
        ?>

        <?php if( $hide_blog_banner == false ): ?>
            <div class="inner-heros-warp">
                <div class="container-fluid">
                    <div class="inner-hero-content row">
                        <div class="col-lg-7">
                            <?php if( $hide_page_title == false ): ?>
                                <?php if( get_the_title() ): ?>
                                    <<?php echo esc_attr( $tag); ?> class="mb-0"><?php the_title(); ?></<?php echo esc_attr( $tag); ?>>
                                <?php else: ?>
                                    <<?php echo esc_attr( $tag); ?> class="mb-0"><?php esc_html_e('No Title', 'falar'); ?></<?php echo esc_attr( $tag); ?>>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <div class="col-lg-5 text-end">
                            <?php if( $hide_breadcrumb == false ): ?>
                                <?php
                                    if ( function_exists('yoast_breadcrumb') ) {
                                        yoast_breadcrumb( '<p class="falar-seo-breadcrumbs" id="breadcrumbs">','</p>' );
                                    } else { ?>
                                        <ul class="inner-hero-list">
                                            <li class="d-inline-block position-relative text-uppercase"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'falar' ); ?></a></li>
                                            <li class="d-inline-block position-relative text-uppercase">
                                                <?php
                                                    if( !empty(get_the_title()) ):
                                                        the_title();
                                                    else:
                                                        esc_html_e( 'No Title', 'falar' );
                                                    endif;
                                                ?>
                                            </li>
                                        </ul>
                                    <?php
                                    }
                                endif;	
                            ?>
                        </div>
                    </div>
                </div>
                <div class="all-shapes">
                    <?php if($blog_banner_shape):  ?>
                        <img src="<?php echo esc_url($blog_banner_shape) ?>" class="inner-page-shape1" alt="<?php echo esc_attr__( 'images', 'falar' ); ?>">
                        <?php else: ?>
                            <img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/inner-page-shape1.png') ?>" class="inner-page-shape1" alt="Shape">
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>

        <div class="blog-details-warp ptb-100">
            <div class="<?php echo esc_attr( $falar_blog_single_layout ); ?>"> 
                <div class="row justify-content-center">
                    <?php
                        while ( have_posts() ) :
                        the_post(); 
                    ?>

                    <div class="<?php echo esc_attr( $falar_sidebar_class ); ?>">
                        <div class="blog-details-big-widget">
                            <div class="blog-image-with-content">
                                <?php
                                    if( isset( $falar_opt['social_title'] )):
                                        $enable_post_meta 	= $falar_opt['enable_post_meta'];
                                    else:
                                        $enable_post_meta 	= true;
                                    endif;
                                ?>
                                <?php if( $enable_post_meta == true ):?>
                                    <ul class="blog-list">
                                        <li>
                                        <?php
                                            $categories = get_the_category();
                                            if ($categories) {
                                                echo '<ul class="ps-0 mb-0 list-unstyled cat">';
                                                foreach ($categories as $category) {
                                                    echo '<li><a href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
                                                }
                                                echo '</ul>';
                                            }
                                        ?>
                                        </li>
                                        <li><?php echo esc_html(get_the_date()); ?></li>
                                        <li><?php echo esc_html(falar_post_reading_time()); ?></li>
                                    </ul>
                                <?php endif; ?>
                                <?php if(get_the_post_thumbnail() != '' ): ?>
                                    <div class="image">
                                        <img class="mt-0 w-100" src="<?php the_post_thumbnail_url('falar_post_thumb') ?>" alt="<?php the_title_attribute(); ?>">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="blog-details-desc description">
                            <?php the_content();
                                wp_link_pages( array(
                                    'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'falar' ),
                                    'after'  => '</div>',
                                ) );
                            ?>
                        </div>
                        <?php if( get_the_tags() OR $social_title): ?>
                            <div class="article-footer tags-share d-md-flex align-items-center justify-content-between">
                                <?php
                                    if( isset( $falar_opt['social_title'] )):
                                        $enable_post_tags 	= $falar_opt['enable_post_tags'];
                                    else:
                                        $enable_post_tags 	= true;
                                    endif;
                                    ?>
                                <?php if( $enable_post_tags == true ):?>
                                    <?php if ( get_the_tags() ) {  ?>
                                        <ul class="tags tags-list ps-0 mb-0 list-unstyled fw-light">
                                            <li><h5><?php echo esc_attr__( 'Tags:', 'falar' ); ?></h5></li>
                                            <?php $tags = get_the_tags();
                                            foreach ($tags as $tag ) {  ?>
                                                <li class="d-inline-block">
                                                    <a href="<?php echo esc_url(get_tag_link($tag->term_id)); ?>" class="d-block text-decoration-none">
                                                    <?php echo esc_html($tag->name) ?></a>
                                                </li>
                                            <?php
                                            } ?>
                                        </ul>
                                    <?php } ?>
                                <?php endif; ?>
                                <?php
                                    if( isset( $falar_opt['social_title'] )):
                                        $enable_post_share 	= $falar_opt['enable_post_share'];
                                    else:
                                        $enable_post_share 	= true;
                                    endif;
                                    ?>
                                <?php if( $enable_post_share == true ):?>
                                    <ul class="share-list">
                                        <?php if($social_title): ?>
                                            <li><h5><?php echo esc_html($social_title); ?></h5></li>
                                        <?php endif; ?>
                                        <?php if (isset($falar_opt['single_blog_facebook_url'] ) && $falar_opt['single_blog_facebook_url']) { ?>
                                            <li>
                                                <a target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['single_blog_facebook_url']); ?>" class="text-decoration-none d-inline-block fw-medium"><i class="ri-facebook-fill"></i></a>
                                            </li>
                                        <?php  } ?>

                                        <?php if (isset($falar_opt['single_blog_instagram_url'] ) && $falar_opt['single_blog_instagram_url'] ) { ?>
                                            <li>
                                                <a target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['single_blog_instagram_url']); ?>" class="text-decoration-none d-inline-block fw-medium"> <i class="ri-instagram-line"></i></a>
                                            </li>
                                        <?php  } ?>

                                        <?php
                                        if (isset($falar_opt['single_blog_linkedin_url'] ) && $falar_opt['single_blog_linkedin_url'] ) { ?>
                                            <li>
                                                <a target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($falar_opt['single_blog_linkedin_url']);?>" class="text-decoration-none d-inline-block fw-medium"><i class="ri-linkedin-line"></i></a>
                                            </li>
                                        <?php  } ?>

                                        <?php
                                        if (isset($falar_opt['single_blog_twitter_url'] ) && $falar_opt['single_blog_twitter_url'] ) { ?>
                                            <li>
                                                <a target="<?php echo esc_attr($target); ?>" href="<?php echo esc_url($falar_opt['single_blog_twitter_url']);?>" class="text-decoration-none d-inline-block fw-medium"> <i class="ri-twitter-x-line"></i></a>
                                            </li>
                                        <?php  } ?>
                                        <?php
                                        if (isset($falar_opt['single_blog_tiktok_url'] ) && $falar_opt['single_blog_tiktok_url'] ) { ?>
                                            <li>
                                                <a target="<?php echo esc_attr($target); ?>" href="<?php echo esc_url($falar_opt['single_blog_tiktok_url']);?>" class="text-decoration-none d-inline-block fw-medium"> <i class="ri-tiktok-line"></i></a>
                                            </li>
                                        <?php  } ?>
                                    </ul>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>

                        <div class="previous-next-post falar-post-next-prev previous-next">
                            <?php
                                // Previous/next post navigation.
                                $falar_previous_label = esc_html__( 'Next Article', 'falar' );
                                $falar_next_label     = esc_html__( 'Previous Article', 'falar' );


                                the_post_navigation(
                                    array(
                                        'next_text' => '<span class="nav-next">' . $falar_next_label . '<i class="ri-arrow-right-line"></i></span>',
                                        'prev_text' => '<span class="nav-previous"><i class="ri-arrow-left-line"></i>' . $falar_previous_label . '</span>',
                                    )
                                );
                            ?>
                        </div>

                        
                        <?php
                            // If comments are open or we have at least one comment, load up the comment template.
                            if ( comments_open() || get_comments_number() ) :
                                comments_template();
                            endif;
                        ?>
                    </div>

                    <?php 
                    if( $sidebar_hide == 'falar_with_sidebar' ) {
                        get_sidebar();
                    }
                    endwhile; // End of the loop. 
                    
                    ?>
                </div>
            </div>
        </div>
        <?php
    }
}