<?php
/**
 * Events category Style
 * @package WordPress
 * @subpackage Falar
*/
if ( ! function_exists( 'falar_theme_events_category_content' ) ) {
	function falar_theme_events_category_content() {
        
        global $falar_opt;

	// Blog breadcrumb
	if( isset($falar_opt['blog_title']) ) {
		$title                  = $falar_opt['blog_title'];
        $top_title              = $falar_opt['blog_top_title'];
        $hide_page_title    	= $falar_opt['hide_page_title'];
		$hide_breadcrumb    	= $falar_opt['hide_breadcrumb'];
		$hide_blog_banner       = $falar_opt['hide_blog_banner'];
        $blog_banner_shape      = $falar_opt['blog_banner_shape']['url'];
	} else {
        $hide_page_title    	= false;
		$hide_breadcrumb    	= false;
		$hide_blog_banner       = false;
		$title           		= '';
		$top_title           	= '';
        $blog_banner_shape      = false;
	}

	// Blog page link
	if ( get_option( 'page_for_posts' ) ) {
		$blog_link = get_permalink( get_option( 'page_for_posts' ));
	}else{
		$blog_link = home_url( '/' );
	}

?>

    <?php if( $hide_blog_banner == false ): ?>
        <div class="inner-heros-warp">
            <div class="container-fluid">
				<div class="inner-hero-content">
                    <?php if( $hide_page_title == false ): ?>
                        <?php if( isset($tag) ): ?>
                            <h3><?php the_archive_title(); ?></h3>
                        <?php else: ?>
                            <h3><?php esc_html_e('Events Category', 'falar'); ?></h3>>
                        <?php endif; ?>
                    <?php endif; ?>

                    <?php if( $hide_breadcrumb == false ): ?>
                        <?php
                            if ( function_exists('yoast_breadcrumb') ) {
                                yoast_breadcrumb( '<p class="falar-seo-breadcrumbs" id="breadcrumbs">','</p>' );
                            } else { ?>
                                <ul class="inner-hero-list">
                                <li class="d-inline-block position-relative fw-medium"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'falar' ); ?></a></li>
                                <li class="d-inline-block position-relative active"><?php the_archive_title(); ?></li>
                                </ul>
                            <?php
                        }
                    endif; 
                    ?>
				</div>
            </div>
            <div class="all-shapes">
                <?php if($blog_banner_shape):  ?>
                    <img src="<?php echo esc_url($blog_banner_shape) ?>" class="inner-page-shape1" alt="<?php echo esc_attr__( 'images', 'falar' ); ?>">
                    <?php else: ?>
                        <img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/inner-page-shape1.png') ?>" class="inner-page-shape1" alt="Shape">
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- Start Blog Area -->
    <div class="blog-area ptb-100">
        <div class="container">
            <div class="row">
                <!-- Start Blog Content -->
                <div class="container">
                    <div class="row g-4">
                    <?php
                        $i=1;
                        $c=0;
                            while ( have_posts() ) :
                            the_post();
                            $id                =  get_the_ID();
                            $events_date       = get_field( 'events_date' );
                            $events_location   = get_field( 'events_location' );
                            $timestamp         = strtotime($events_date);

                            // Category 
                            $falar_events_category = get_the_terms(get_the_ID(), 'events_cat');
                        ?>
                            <div class="col-lg-6">
                                <div class="event-widget style2 bg-<?php echo esc_attr($i); ?>">
                                    <?php if('events_cat'): ?>
                                        <?php foreach($falar_events_category as $category): 
                                            $events_cat_list[] = $category->name; 
                                            $category_link = get_category_link($category);
                                        ?>        
                                        <a href="<?php echo esc_url($category_link); ?>"><span><?php echo wp_kses_post($category->name); ?></span></a>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                    <h3>
                                        <a href="<?php echo esc_url(get_the_permalink($id)); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </h3>
                                    <ul class="event-list">
                                        <?php if($events_date): ?>
                                            <li>
                                                <i class="ti ti-calendar"></i>
                                                <?php echo wp_kses_post($events_date); ?>
                                            </li>
                                        <?php endif; ?>
                                        <?php if($events_location): ?>
                                            <li>
                                                <i class="ti ti-map-pin"></i>
                                                <?php echo wp_kses_post($events_location); ?>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        <?php $i++; endwhile; wp_reset_postdata();?>       
                    </div>
                    <?php if(paginate_links()): ?>
                            <!-- Stat Pagination -->
                            <div class="col-lg-12 col-md-12">
                                <div class="pagination-area text-center">
                                    <?php echo paginate_links( array(
                                        'format'    => '?paged=%#%',
                                        'prev_text' => '<i class="ri-arrow-left-s-line"></i>',
                                        'end_size'  => 0,
                                        'mid_size'  => 1,
                                        'next_text' => '<i class="ri-arrow-right-s-line"></i>',
                                            )
                                        ) ?>
                                </div>
                            </div>
                        <?php endif; ?>
                </div>
                <!-- End Blog Content -->
            </div>
        </div>
    </div>
    <!-- End Blog Area -->
    <?php
    }
}