<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to falar/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 9.0.1
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

global $falar_opt;

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

do_action( 'woocommerce_before_main_content' );

$post_page_id       = get_option( 'woocommerce_shop_page_id' );
$product_sidebar    = isset( $falar_opt['product_sidebar']) ? $falar_opt['product_sidebar'] : '';

/**
 * Page Control
 */
/**
	 * Page Control
	*/
	// Blog breadcrumb
	if( isset($falar_opt['blog_title']) ) {
		$hide_breadcrumb    	= $falar_opt['hide_breadcrumb'];
		$hide_blog_banner       = $falar_opt['hide_blog_banner'];
        $hide_page_title    	= $falar_opt['hide_page_title'];
        $blog_banner_shape      = $falar_opt['blog_banner_shape']['url'];
	} else {
		$hide_breadcrumb    	= false;
		$hide_blog_banner       = false;
        $hide_page_title    	= false; 
        $blog_banner_shape      = false;
	}

	// Blog page link
	if ( get_option( 'page_for_posts' ) ) {
		$blog_link = get_permalink( get_option( 'page_for_posts' ));
	}else{
		$blog_link = home_url( '/' );
	}

	$falar_blog_layout = !empty($falar_opt['falar_blog_layout']) ? $falar_opt['falar_blog_layout'] : 'container';
	if( isset($falar_opt['page_title_tag']) ):
		$tag = $falar_opt['page_title_tag'];
	else:
		$tag = 'h2';
	endif;
?>

	<?php if( $hide_blog_banner == false ): ?>
		<div class="inner-heros-warp">
			<div class="container-fluid"> 
				<div class="inner-hero-content">
                    <?php if( $hide_page_title == false ): ?>
                        <?php if( isset($tag) ): ?>
                                <<?php echo esc_attr( $tag ); ?>><?php woocommerce_page_title(); ?></<?php echo esc_attr( $tag ); ?>>
                            <?php else: ?>
                                <<?php echo esc_attr( $tag ); ?>><?php esc_html_e('Shop', 'falar'); ?></<?php echo esc_attr( $tag ); ?>>
                        <?php endif; ?>
                    <?php endif; ?>

					<?php if( $hide_breadcrumb == false ): ?>
						<?php
							if ( function_exists('yoast_breadcrumb') ) {
								yoast_breadcrumb( '<p class="falar-seo-breadcrumbs" id="breadcrumbs">','</p>' );
							} else { ?>
								<ul class="inner-hero-list">
									<li class="d-inline-block position-relative text-uppercase"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'falar' ); ?></a></li>
										<li class="d-inline-block position-relative text-uppercase active"><?php woocommerce_page_title(); ?></li>
									<?php ?>                        
									
								</ul>
							<?php
							}
					endif; ?>
				</div>
			</div>
            <div class="all-shapes">
				<?php if($blog_banner_shape):  ?>
					<img src="<?php echo esc_url($blog_banner_shape) ?>" class="inner-page-shape1" alt="<?php echo esc_attr__( 'images', 'falar' ); ?>">
					<?php else: ?>
						<img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/inner-page-shape1.png') ?>" class="inner-page-shape1" alt="Shape">
				<?php endif; ?>
            </div>
		</div>
    <?php endif; ?>

    <div class="special-products-area ptb-100">
        <div class="container">
            <div class="row">
            <?php
                if ( is_active_sidebar( 'shop' ) ) {
                    if ( isset( $_GET['shop'] ) ) {
                        $falar_shop_cat_sidebar = $_GET['shop'];

                        if ( $falar_shop_cat_sidebar == 'none' ): ?>
                            <div class="col-lg-12 col-md-12">
                        <?php elseif ( $falar_shop_cat_sidebar == 'left' ): ?>
                            <?php do_action( 'woocommerce_sidebar' ); ?>
                            <div class="col-lg-8 col-md-12">
                        <?php elseif ( $falar_shop_cat_sidebar == 'right' ): ?>
                            <div class="col-lg-8 col-md-12">
                        <?php endif;

                    } else {
                        if( $product_sidebar == 'left-sidebar' ): ?>
                            <?php do_action( 'woocommerce_sidebar' ); ?>
                            <div class="col-lg-8 col-md-12">
                        <?php elseif ( $product_sidebar == 'right-sidebar' ): ?>
                            <div class="col-lg-8 col-md-12">
                        <?php elseif ( $product_sidebar == 'falar_product_no_sidebar' ): ?>
                            <div class="col-lg-12 col-md-12">
                        <?php else: ?>
                            <?php do_action( 'woocommerce_sidebar' ); ?>
                            <div class="col-lg-8 col-md-12">
                        <?php endif;
                    }
                } else { ?>
                    <div class="col-lg-12 col-md-12">
                <?php } ?>
                    <?php if ( woocommerce_product_loop() ) { ?>

                        <div class="woocommerce-topbar">
                            <?php do_action( 'woocommerce_before_shop_loop' ); ?>
                        </div>

                        <?Php
                        woocommerce_product_loop_start();

                        if ( wc_get_loop_prop( 'total' ) ) {
                            while ( have_posts() ) {
                                the_post();

                                /**
                                 * Hook: woocommerce_shop_loop.
                                 *
                                 * @hooked WC_Structured_Data::generate_product_data() - 10
                                 */
                                do_action( 'woocommerce_shop_loop' );

                                wc_get_template_part( 'content', 'product' );
                            }
                        }

                        woocommerce_product_loop_end();

                        /**
                         * Hook: woocommerce_after_shop_loop.
                         *
                         * @hooked woocommerce_pagination - 10
                         */
                        do_action( 'woocommerce_after_shop_loop' );
                    } else {
                        /**
                         * Hook: woocommerce_no_products_found.
                         *
                         * @hooked wc_no_products_found - 10
                         */
                        do_action( 'woocommerce_no_products_found' );
                    } ?>
                </div> <!-- end clo-8 -->

                <?php
                if ( isset( $_GET['shop'] ) ) {
                    if ( $falar_shop_cat_sidebar == 'right' ) {
                        do_action( 'woocommerce_sidebar' );
                    }
                } else {
                    if ( $product_sidebar == 'right-sidebar' ) {
                        do_action( 'woocommerce_sidebar' );
                    }
                } ?>
            </div>
        </div>
    </div>
<?php
/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );

/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */

get_footer( 'shop' ); ?>