<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 9.0.1
 */

defined( 'ABSPATH' ) || exit;

global $product;
global $falar_opt;

$price = $product->get_price_html();

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
} ?>

    <div class="col-lg-6 col-sm-6 col-md-6">
        <div class="single-products-card">
            <div class="products-image">
                <a href="<?php the_permalink(); ?>" class="d-block">
                    <?php the_post_thumbnail( 'falar_product_card' ); ?>
                </a>
                <?php if ( class_exists( 'YITH_WCWL' ) ) { ?>
                    <div class="heart-line">
                        <?php echo preg_replace("/<img[^>]+\>/i", " ", do_shortcode('[yith_wcwl_add_to_wishlist]')); ?>
                    </div>
                <?php } ?>
                <?php if($product->is_on_sale()): ?>
                    <span class="sale"><?php esc_html_e( 'SALE', 'falar' ); ?></span>
                <?php endif; ?>
            </div>
            <div class="products-content">
                <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                <?php woocommerce_template_loop_price(); ?>
                <div class="add-to-cart-btn">
                    <?php woocommerce_template_loop_add_to_cart(); ?>
                </div>
            </div>
        </div>
    </div>

