<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to falar/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version     9.0.1
 */
global $falar_opt;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' );
    $product_sidebar    = isset( $falar_opt['product_sidebar']) ? $falar_opt['product_sidebar'] : '';
    $title = get_the_title();

	// Blog breadcrumb
	// Single Product breadcrumb
	if( isset($falar_opt['hide_product_banner']) ) {
		$hide_product_breadcrumb    	= $falar_opt['hide_product_breadcrumb'];
		$hide_product_banner            = $falar_opt['hide_product_banner'];
        $hide_page_title    	        = $falar_opt['hide_page_title'];
        $blog_banner_shape              = $falar_opt['blog_banner_shape']['url'];
	} else {
		$hide_product_breadcrumb   	= 	false;
		$hide_product_banner        = false; 
        $hide_page_title    	    = false;
        $blog_banner_shape          = false;
	}
	

	// Blog page link
	if ( get_option( 'page_for_posts' ) ) {
		$product_link = get_permalink( get_option( 'page_for_posts' ));
	}else{
		$product_link = home_url( '/' );
	}

	$falar_product_single_layout = !empty($falar_opt['falar_product_single_layout']) ? $falar_opt['falar_product_single_layout'] : 'container';

	if( isset($falar_opt['page_title_tag']) ):
		$tag = $falar_opt['page_title_tag'];
	else:
		$tag = 'h2';
	endif;

remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
?>

    <?php if( $hide_product_banner == false ): ?>
        <div class="inner-heros-warp">
            <div class="container-fluid">
                <div class="inner-hero-content">
                    <?php if( $hide_page_title == false ): ?>
                        <?php if( isset($tag) ): ?>
                            <<?php echo esc_attr( $tag ); ?>><?php echo esc_html( $title ); ?></<?php echo esc_attr( $tag ); ?>>
                        <?php else: ?>
                            <<?php echo esc_attr( $tag ); ?>><?php esc_html_e('Blog Details', 'falar'); ?></<?php echo esc_attr( $tag ); ?>>
                        <?php endif; ?>
                    <?php endif; ?>

                    <?php if( $hide_product_breadcrumb == false ): ?>
                        <?php
                            if ( function_exists('yoast_breadcrumb') ) {
                                yoast_breadcrumb( '<p class="falar-seo-breadcrumbs" id="breadcrumbs">','</p>' );
                            } else { ?>
                                <ul class="inner-hero-list">
                                    <li class="d-inline-block position-relative text-uppercase"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'falar' ); ?></a></li>
                                        <li class="d-inline-block position-relative text-uppercase"><a href="<?php echo esc_url( home_url( '/shop/' ) ); ?>"><?php esc_html_e('Shop', 'falar'); ?></a></li>
                                        <li class="d-inline-block position-relative text-uppercase active"><?php the_title(); ?></li>
                                    <?php ?>                        
                                </ul>
                            <?php
                            }
                    endif; ?>
                </div>
            </div>
            <div class="all-shapes">
				<?php if($blog_banner_shape):  ?>
					<img src="<?php echo esc_url($blog_banner_shape) ?>" class="inner-page-shape1" alt="<?php echo esc_attr__( 'images', 'falar' ); ?>">
					<?php else: ?>
						<img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/inner-page-shape1.png') ?>" class="inner-page-shape1" alt="Shape">
				<?php endif; ?>
            </div>
        </div>
    <?php endif; ?>

    <div  class="products_details ptb-100">
        <div class="container">
            <div class="row">
                <?php if ( is_active_sidebar( 'shop' ) ): ?>
                    <?php if ( isset( $_GET['shop'] ) ): ?>
                        <?php  $falar_shop_cat_sidebar = $_GET['shop']; ?>
                        <?php if ( $falar_shop_cat_sidebar == 'none' ): ?>
                            <div class="col-lg-12 col-md-12">
                        <?php elseif ( $falar_shop_cat_sidebar == 'left' ): ?>
                            <?php do_action( 'woocommerce_sidebar' ); ?>
                            <div class="col-lg-8 col-md-12">
                        <?php elseif ( $falar_shop_cat_sidebar == 'right' ): ?>
                            <div class="col-lg-8 col-md-12">
                        <?php endif; ?>
                    <?php else: ?>
                        <?php if( $product_sidebar == 'left-sidebar' ): ?>
                            <?php do_action( 'woocommerce_sidebar' ); ?>
                            <div class="col-lg-8 col-md-12">
                        <?php elseif ( $product_sidebar == 'right-sidebar' ): ?>
                            <div class="col-lg-8 col-md-12">
                        <?php else: ?>
                            <div class="col-lg-12 col-md-12">
                        <?php endif; ?>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="col-lg-12 col-md-12">
                <?php endif; ?>

                    <?php
                    /**
                     * woocommerce_before_main_content hook.
                     *
                     * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
                     * @hooked woocommerce_breadcrumb - 20
                     */

                    do_action( 'woocommerce_before_main_content' );

                        while ( have_posts() ) : the_post();

                            wc_get_template_part( 'content', 'single-product' );

                        endwhile;

                        /**
                         * woocommerce_after_main_content hook.
                         *
                         * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
                         */
                        do_action( 'woocommerce_after_main_content' );
                    ?>
                </div>
                <?php
                if ( isset( $_GET['shop'] ) ):
                    if ( $falar_shop_cat_sidebar == 'right' ) :
                        do_action( 'woocommerce_sidebar' );
                    endif;
                else:
                    if ( $product_sidebar == 'right-sidebar' ):
                        do_action( 'woocommerce_sidebar' );
                    endif;
                endif;
                ?>
            </div>
        </div>
    </div>

    <?php get_footer( 'shop' );
    /* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
    ?>

