<?php
/**
 * Single Product Meta
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;
?>
	<?php do_action( 'woocommerce_product_meta_start' ); 
	global $falar_opt;
		if( isset( $falar_opt['copyright_text'] )):
			$enable_product_meta 	= $falar_opt['enable_product_meta'];
		else:
			$enable_product_meta 	= true;
		endif;
	?>
		<?php if( $enable_product_meta == true ):?>
			<ul class="products-info">
				<?php if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) : ?>
					<li><span><?php esc_html_e( 'SKU:',  'falar' ); ?></span> <?php echo esc_html( $product->get_sku() ); ?></li>
				<?php endif; ?>

				<?php if ( $product->get_stock_quantity() > 0 ) : ?>
					<li><span><?php esc_html_e( 'Availability:',  'falar' ); ?></span> <?php echo wc_get_stock_html( $product );  ?></li>
				<?php else: ?>
					<li><span><?php esc_html_e( 'Availability:',  'falar' ); ?></span> <?php esc_html_e( 'N/A',  'falar' ); ?></li>
				<?php endif; ?>

				<?php echo wc_get_product_category_list( $product->get_id(), ', ', '<li><span class="posted_in">' . _n( 'Category:', 'Categories:', count( $product->get_category_ids() ),  'falar' ) . ' ', '</span></li>' ); ?>

				<?php echo wc_get_product_tag_list( $product->get_id(), ', ', '<li><span class="tagged_as">' . _n( 'Tag:', 'Tags:', count( $product->get_tag_ids() ),  'falar' ) . ' ', '</span></li>' ); ?>
			</ul>
		<?php endif; ?>

	<?php do_action( 'woocommerce_product_meta_end' ); ?>