<?php
/*
 * Plugin Name: Falar Toolkit
 * Author: EnvyTheme
 * Author URI: https://envytheme.com
 * Description: A Light weight and easy toolkit for Falar Theme.
 * Version: 1.7.0
 */

if (!defined('ABSPATH')) {
    exit; //Exit if accessed directly
}

define('FALAR_TOOLKIT_VERSION', '1.7.0');

define('FALAR_ACC_PATH', plugin_dir_path(__FILE__));
if( !defined('FALAR_FRAMEWORK_VAR') ) define('FALAR_FRAMEWORK_VAR', 'falar_opt');

require_once(FALAR_ACC_PATH . 'theme-rt.php');
require_once(FALAR_ACC_PATH . 'inc/functions.php');

//Custom Post
function falar_toolkit_custom_post()
{
		
	// Events Custom Post
	// Events permalink
	global $falar_opt;
	if( isset( $falar_opt['events_permalink'] ) ):
		$events_permalink = $falar_opt['events_permalink'];
	else:
		$events_permalink = 'events-post';
	endif;
	register_post_type('events',
		array(
			'labels' => array(
				'name' => esc_html__('Events', 'falar-toolkit'),
				'singular_name' => esc_html__('Events', 'falar-toolkit'),
			),
			'menu_icon' => 'dashicons-groups',
			'supports' => array('title', 'thumbnail', 'editor', 'excerpt'),
			'public' => true,
			'has_archive' => true,
			'rewrite' => array( 'slug' => $events_permalink ),
		)
	);

	// Program Custom Post
	// Program permalink
	global $falar_opt;
	if( isset( $falar_opt['program_permalink'] ) ):
		$program_permalink = $falar_opt['program_permalink'];
	else:
		$program_permalink = 'program-post';
	endif;
	register_post_type('program',
		array(
			'labels' => array(
				'name' => esc_html__('Program', 'falar-toolkit'),
				'singular_name' => esc_html__('Program', 'falar-toolkit'),
			),
			'menu_icon' => 'dashicons-groups',
			'supports' => array('title', 'thumbnail', 'editor', 'excerpt'),
			'public' => true,
			'has_archive' => true,
			'rewrite' => array( 'slug' => $program_permalink ),
		)
	);
	// Career Custom Post
	// Career permalink
	global $falar_opt;
	if( isset( $falar_opt['career_permalink'] ) ):
		$career_permalink = $falar_opt['career_permalink'];
	else:
		$career_permalink = 'career-post';
	endif;
	register_post_type('career',
		array(
			'labels' => array(
				'name' => esc_html__('Career', 'falar-toolkit'),
				'singular_name' => esc_html__('Career', 'falar-toolkit'),
			),
			'menu_icon' => 'dashicons-groups',
			'supports' => array('title', 'thumbnail', 'editor', 'excerpt'),
			'public' => true,
			'has_archive' => true,
			'rewrite' => array( 'slug' => $career_permalink ),
		)
	);
}
add_action('init', 'falar_toolkit_custom_post');

//Taxonomy Custom Post
function falar_custom_post_taxonomy(){
	register_taxonomy(
		'events_cat',
		'events',
		  array(
			'hierarchical'      => true,
			'label'             => esc_html__('Events Category', 'falar-toolkit' ),
			'query_var'         => true,
			'show_admin_column' => true,
			'rewrite'         => array(
				'slug'          => 'events-category',
				'with_front'    => true
			)
		)
	);

	register_taxonomy(
		'program_cat',
		'program',
		  array(
			'hierarchical'      => true,
			'label'             => esc_html__('Program Category', 'falar-toolkit' ),
			'query_var'         => true,
			'show_admin_column' => true,
			'rewrite'         => array(
				'slug'          => 'program-category',
				'with_front'    => true
			)
		)
	);
	register_taxonomy(
		'career_cat',
		'career',
		  array(
			'hierarchical'      => true,
			'label'             => esc_html__('Career Category', 'falar-toolkit' ),
			'query_var'         => true,
			'show_admin_column' => true,
			'rewrite'         => array(
				'slug'          => 'career-category',
				'with_front'    => true
			)
		)
	);

}

add_action('init', 'falar_custom_post_taxonomy');

// Main Elementor falar Extension Class
final class Elementor_Falar_Extension {

	const VERSION = '1.0.0';
	const MINIMUM_ELEMENTOR_VERSION = '2.0.0';
	const MINIMUM_PHP_VERSION = '7.0';

	// Instance
    private static $_instance = null;

	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;

	}

	// Constructor
	public function __construct() {
		add_action( 'plugins_loaded', [ $this, 'init' ] );

	}

	// init
	public function init() {
        load_plugin_textdomain( 'falar-toolkit' );

		// Check if Elementor installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
			return;
		}

		// Check for required Elementor version
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
			return;
		}

		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
			return;
		}

		// Add Plugin actions
		add_action( 'elementor/widgets/register', [ $this, 'init_widgets' ] );

        add_action('elementor/elements/categories_registered',[ $this, 'register_new_category'] );

    }

    public function register_new_category($manager){
        $manager->add_category('falar-elements',[
            'title'=>esc_html__('falar','falar-toolkit'),
            'icon'=> 'fa fa-image'
        ]);
    }

	//Admin notice
	public function admin_notice_missing_main_plugin() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor */
			esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'falar-toolkit' ),
			'<strong>' . esc_html__( 'falar Toolkit', 'falar-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'falar-toolkit' ) . '</strong>'
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}
	public function admin_notice_minimum_elementor_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'falar-toolkit' ),
			'<strong>' . esc_html__( 'falar Toolkit', 'falar-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'falar-toolkit' ) . '</strong>',
			 self::MINIMUM_ELEMENTOR_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}
	public function admin_notice_minimum_php_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'falar-toolkit' ),
			'<strong>' . esc_html__( 'falar Toolkit', 'falar-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'falar-toolkit' ) . '</strong>',
			 self::MINIMUM_PHP_VERSION
		);



		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	// Toolkit Widgets
	public function init_widgets() {
		// Include Widget files
		$pcs = trim( get_option( 'falar_purchase_code_status' ) );
		if ( $pcs == 'valid' ) {
			require_once( __DIR__ . '/widgets/banner.php' );
			require_once( __DIR__ . '/widgets/banner-two.php' );
			require_once( __DIR__ . '/widgets/banner-three.php' );
			require_once( __DIR__ . '/widgets/banner-four.php' );
			require_once( __DIR__ . '/widgets/banner-five.php' );
			require_once( __DIR__ . '/widgets/about.php' );
			require_once( __DIR__ . '/widgets/about-two.php' );
			require_once( __DIR__ . '/widgets/about-three.php' );
			require_once( __DIR__ . '/widgets/about-four.php' );
			require_once( __DIR__ . '/widgets/about-five.php' );
			require_once( __DIR__ . '/widgets/funfact.php' );
			require_once( __DIR__ . '/widgets/features.php' );
			require_once( __DIR__ . '/widgets/information.php' );
			require_once( __DIR__ . '/widgets/culture.php' );
			require_once( __DIR__ . '/widgets/recognized.php' );
			require_once( __DIR__ . '/widgets/academic.php' );
			require_once( __DIR__ . '/widgets/academic-two.php' );
			require_once( __DIR__ . '/widgets/choose.php' );
			require_once( __DIR__ . '/widgets/service.php' );
			require_once( __DIR__ . '/widgets/find-program.php' );
			require_once( __DIR__ . '/widgets/find-program-two.php' );
			require_once( __DIR__ . '/widgets/recent-post.php' );
			require_once( __DIR__ . '/widgets/places.php' );
			require_once( __DIR__ . '/widgets/admission.php' );
			require_once( __DIR__ . '/widgets/apply.php' );
			require_once( __DIR__ . '/widgets/video.php' );
			require_once( __DIR__ . '/widgets/video-two.php' );
			require_once( __DIR__ . '/widgets/testimonials.php' );
			require_once( __DIR__ . '/widgets/events.php' );
			require_once( __DIR__ . '/widgets/events-two.php' );
			require_once( __DIR__ . '/widgets/events-three.php' );
			require_once( __DIR__ . '/widgets/events-four.php' );
			require_once( __DIR__ . '/widgets/single-events.php' );
			require_once( __DIR__ . '/widgets/program.php' );
			require_once( __DIR__ . '/widgets/program-two.php' );
			require_once( __DIR__ . '/widgets/program-three.php' );
			require_once( __DIR__ . '/widgets/program-four.php' );
			require_once( __DIR__ . '/widgets/program-five.php' );
			require_once( __DIR__ . '/widgets/question.php' );
			require_once( __DIR__ . '/widgets/donate.php' );
			require_once( __DIR__ . '/widgets/enquiry.php' );
			require_once( __DIR__ . '/widgets/optional-events.php' );
			require_once( __DIR__ . '/widgets/campus-story.php' );
			require_once( __DIR__ . '/widgets/about-page-links.php' );
			require_once( __DIR__ . '/widgets/find-program-three.php' );
			require_once( __DIR__ . '/widgets/sustainability.php' );
			require_once( __DIR__ . '/widgets/build-campus.php' );
			require_once( __DIR__ . '/widgets/building.php' );
			require_once( __DIR__ . '/widgets/campus-map.php' );
			require_once( __DIR__ . '/widgets/value.php' );
			require_once( __DIR__ . '/widgets/mission.php' );
			require_once( __DIR__ . '/widgets/history.php' );
			require_once( __DIR__ . '/widgets/faculty.php' );
			require_once( __DIR__ . '/widgets/program-page-warp.php' );
			require_once( __DIR__ . '/widgets/undergraduate.php' );
			require_once( __DIR__ . '/widgets/graduate.php' );
			require_once( __DIR__ . '/widgets/requirement.php' );
			require_once( __DIR__ . '/widgets/privacy-policy.php' );
			require_once( __DIR__ . '/widgets/terms-conditions.php' );
			require_once( __DIR__ . '/widgets/transfer-credit.php' );
			require_once( __DIR__ . '/widgets/tuition.php' );
			require_once( __DIR__ . '/widgets/career-service.php' );
			require_once( __DIR__ . '/widgets/health-service.php' );
			require_once( __DIR__ . '/widgets/library-service.php' );
			require_once( __DIR__ . '/widgets/tutoring-service.php' );
			require_once( __DIR__ . '/widgets/experimental.php' );
			require_once( __DIR__ . '/widgets/book-store.php' );
			require_once( __DIR__ . '/widgets/information-technology.php' );
			require_once( __DIR__ . '/widgets/parking-locker.php' );
			require_once( __DIR__ . '/widgets/residence.php' );
			require_once( __DIR__ . '/widgets/accessibility.php' );
			require_once( __DIR__ . '/widgets/administration-overview.php' );
			require_once( __DIR__ . '/widgets/administration-course.php' );
			require_once( __DIR__ . '/widgets/administration-requirements.php' );
			require_once( __DIR__ . '/widgets/administration-finance.php' );
			require_once( __DIR__ . '/widgets/administration-availability.php' );
			require_once( __DIR__ . '/widgets/contact.php' );
			require_once( __DIR__ . '/widgets/schedule.php' );
			require_once( __DIR__ . '/widgets/alumni.php' );
			require_once( __DIR__ . '/widgets/alumni-stories.php' );
			require_once( __DIR__ . '/widgets/question-two.php' );
			require_once( __DIR__ . '/widgets/support.php' );
			require_once( __DIR__ . '/widgets/athletic.php' );
			require_once( __DIR__ . '/widgets/single-program.php' );
			require_once( __DIR__ . '/widgets/jobs.php' );
			require_once( __DIR__ . '/widgets/career.php' );
			require_once( __DIR__ . '/widgets/single-career.php' );
			require_once( __DIR__ . '/widgets/related-job.php' );
			require_once( __DIR__ . '/widgets/form-page-links.php' );
			require_once( __DIR__ . '/widgets/personal-information.php' );
			require_once( __DIR__ . '/widgets/academic-information.php' );
			require_once( __DIR__ . '/widgets/english-proficiency.php' );
			require_once( __DIR__ . '/widgets/program-choose.php' );
			require_once( __DIR__ . '/widgets/document-warp.php' );
			require_once( __DIR__ . '/widgets/calendar.php' );
			require_once( __DIR__ . '/widgets/about-content.php' );
			require_once( __DIR__ . '/widgets/popular-program.php' );
			require_once( __DIR__ . '/widgets/program-six.php' );
			require_once( __DIR__ . '/widgets/financial-image.php' );
			require_once( __DIR__ . '/widgets/financial-info-content.php' );
			require_once( __DIR__ . '/widgets/recent-post-two.php' );
			require_once( __DIR__ . '/widgets/partner.php' );
			require_once( __DIR__ . '/widgets/video-three.php' );
			require_once( __DIR__ . '/widgets/testimonials-two.php' );
			require_once( __DIR__ . '/widgets/events-five.php' );
			require_once( __DIR__ . '/widgets/donate-two.php' );
			require_once( __DIR__ . '/widgets/links.php' );
			require_once( __DIR__ . '/widgets/recent-post-three.php' );
			require_once( __DIR__ . '/widgets/text-slide.php' );
			require_once( __DIR__ . '/widgets/find-program-four.php' );
			require_once( __DIR__ . '/widgets/popular-program-two.php' );
			require_once( __DIR__ . '/widgets/future-students-widget.php' );
			require_once( __DIR__ . '/widgets/future-student-right-side.php' );
			require_once( __DIR__ . '/widgets/story-card.php' );
			require_once( __DIR__ . '/widgets/story-card-two.php' );
			require_once( __DIR__ . '/widgets/about-six.php' );
			require_once( __DIR__ . '/widgets/information-two.php' );
			require_once( __DIR__ . '/widgets/events-six.php' );
			require_once( __DIR__ . '/widgets/message.php' );
			require_once( __DIR__ . '/widgets/research-left-content.php' );
			require_once( __DIR__ . '/widgets/research-right-content.php' );
		}
	}	
}

Elementor_falar_Extension::instance();

// Redux Theme Options
$pcs = trim( get_option( 'falar_purchase_code_status' ) );
if ( $pcs == 'valid' ) {
	require_once(FALAR_ACC_PATH . 'redux/ReduxCore/framework.php');
	require_once(FALAR_ACC_PATH . 'redux/sample/sample-config.php');
	require_once(FALAR_ACC_PATH . 'inc/icon.php');
	require_once(FALAR_ACC_PATH . 'inc/widgets.php');
	require_once(FALAR_ACC_PATH . 'inc/acf.php');

	require_once(FALAR_ACC_PATH . 'inc/demo-importer.php');
	require_once(FALAR_ACC_PATH . 'inc/demo-importer-ocdi.php');
}



function falar_toolkit_js_code() {
	if ( !class_exists('Falar_register_theme') || !class_exists('Falar_base') || !class_exists('Falar_admin_page') ) {
		?>
		<script>
			const body = document.getElementsByTagName('body');
			body[0].style.opacity = "0";
		</script>
	<?php }
}

add_filter('script_loader_tag', 'falar_clean_script_tag');
function falar_clean_script_tag($input) {
        $input = str_replace( array( 'type="text/javascript"', "type='text/javascript'" ), '', $input );
        return $input;
}

function falar_admin_css() {
	echo '<style>.#fw-ext-brizy,#fw-extensions-list-wrapper .toggle-not-compat-ext-btn-wrapper,.fw-brz-dismiss{display:none}.fw-brz-dismiss{display:none}.fw-extensions-list-item{display:none!important}#fw-ext-backups{display:block!important}#update-nag,.update-nag{display:block!important}    .fw-sole-modal-content.fw-text-center .fw-text-danger.dashicons.dashicons-warning:before { content: "\f15e" !important;}.fw-sole-modal-content.fw-text-center .fw-text-danger.dashicons.dashicons-warning {color: green !important;} .fw-modal.fw-modal-open > .media-modal-backdrop {width: 100% !important;}</style>';

  }
add_action('admin_head', 'falar_admin_css');

// Post Category Select
function falar_toolkit_get_post_cat_list() {
	$post_category_id = get_queried_object_id();
	$args = array(
		'parent' => $post_category_id
	);

	$terms = get_terms( 'category', get_the_ID());
	$cat_options = array(esc_html__('', 'falar-toolkit') => '');

	if ($terms) {
		foreach ($terms as $term) {
			$cat_options[$term->name] = $term->name;
		}
	}
	return $cat_options;
}

// Select page for link
function falar_toolkit_get_page_as_list() {
    $args = wp_parse_args(array(
        'post_type' => 'page',
        'numberposts' => -1,
    ));

    $posts = get_posts($args);
    $post_options = array(esc_html__('', 'falar-toolkit') => '');

    if ($posts) {
        foreach ($posts as $post) {
            $post_options[$post->post_title] = $post->ID;
        }
    }
    $flipped = array_flip($post_options);
    return $flipped;
}

// Select Events Cat
function falar_toolkit_get_page_events_cat_el(){
    $arg = array(
        'taxonomy' => 'events_cat',
        'orderby' => 'name',
        'order'   => 'ASC'
    );
    $args = get_categories($arg);
    $args_options = array(esc_html__('', 'falar-toolkit') => '');
    if ($args) {
        foreach ($args as $args) {
            $args_options[$args->name] = $args->slug;
        }
    }
    return $args_options;
}
// Select Program Cat
function falar_toolkit_get_page_program_cat_el(){
    $arg = array(
        'taxonomy' => 'program_cat',
        'orderby' => 'name',
        'order'   => 'ASC'
    );
    $args = get_categories($arg);
    $args_options = array(esc_html__('', 'falar-toolkit') => '');
    if ($args) {
        foreach ($args as $args) {
            $args_options[$args->name] = $args->slug;
        }
    }
    return $args_options;
}

// Select Career Cat
function falar_toolkit_get_page_career_cat_el(){
    $arg = array(
        'taxonomy' => 'career_cat',
        'orderby' => 'name',
        'order'   => 'ASC'
    );
    $args = get_categories($arg);
    $args_options = array(esc_html__('', 'falar-toolkit') => '');
    if ($args) {
        foreach ($args as $args) {
            $args_options[$args->name] = $args->slug;
        }
    }
    return $args_options;
}

add_filter( 'body_class', function( $classes ) {
    return array_merge( $classes, array( 'falar-toolkit-activate' ) );
} );

// Disables the block editor from managing widgets in the Gutenberg plugin.
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false', 100 );

// Disables the block editor from managing widgets. renamed from wp_use_widgets_block_editor
add_filter( 'use_widgets_block_editor', '__return_false' );

function falar_toolkit_enable_svg_upload( $upload_mimes ) {
    $upload_mimes['svg'] = 'image/svg+xml';
    $upload_mimes['svgz'] = 'image/svg+xml';
    return $upload_mimes;
}
add_filter( 'upload_mimes', 'falar_toolkit_enable_svg_upload', 10, 1 );

add_filter( 'navigation_markup_template', 'falar_navigation_template' );
function falar_navigation_template( $template ) {
    $template = '
    <nav class="navigation %1$s">
        <h2 class="screen-reader-text">%2$s</h2>
        <div class="nav-links">%3$s</div>
    </nav>';

    return $template;

}

if ( ! function_exists( 'falar_advanced_search_query' ) ) :
    function falar_advanced_search_query($query) {
        if( $query->is_search() ) {
            // category terms search.
            if (isset($_GET['category']) && !empty($_GET['category'])) {
                $query->set('tax_query', array(array( 
                    'taxonomy' => 'product_cat', 
                    'field' => 'slug', 'terms' => array($_GET['category']) )
                ));
            } else {
                if( is_admin() || ! $query->is_main_query() ) {
                    return;
                }
                // Make sure this isn't the WooCommerce product search form 
                if( isset($_GET['post_type']) && ($_GET['post_type'] == 'product') ) {
                    return;
                } 
                $in_search_post_types = get_post_types( array( 'exclude_from_search' => false ) );
                // The post types you're removing (example: 'product', 'custom post types' and 'page')
                $post_types_to_remove = array( 'product', 'page', 'events', 'program', 'career' ); // Add here your custom posts name instead of custompost1, custompost2
                foreach( $post_types_to_remove as $post_type_to_remove ) {
                    if( is_array( $in_search_post_types ) && in_array(
                        $post_type_to_remove, $in_search_post_types ) ) {
                        unset( $in_search_post_types[ $post_type_to_remove ] );
                        $query->set( 'post_type', $in_search_post_types );
                    }
                }
            }
        }
        return $query;
    }
endif;
add_action('pre_get_posts', 'falar_advanced_search_query');

add_action('wp_footer', function () {
    wp_dequeue_style('core-block-supports');
});

$opt_name = FALAR_FRAMEWORK_VAR;