<?php

use \FW_Ext_Backups_Demo as HB_FW_Ext_Backups_Demo;

if (! defined('ABSPATH')) {
    exit;
}

class Demo_Importer
{

    protected static $instance;

    public function __construct()
    {
        add_filter('plugin_action_links_envy-demo-importer/envy-demo-importer.php', array( $this, 'add_action_links' )); // Link from plugins page
        add_filter('rt_demo_installer_warning', array( $this, 'data_loss_warning' ));
        add_filter('fw:ext:backups-demo:demos', array( $this, 'demo_config' ));
        add_action('fw:ext:backups:tasks:success:id:demo-content-install', array( $this, 'after_demo_install' ));
    }

    public static function instance()
    {
        if (null == self::$instance) {
            self::$instance = new self;
        }
        return self::$instance;
    }

    public function add_action_links($links)
    {
        $mylinks = array(
            '<a href="' . esc_url(admin_url('tools.php?page=fw-backups-demo-content')) . '">'.__('Install Demo Contents', 'falar-toolkit').'</a>',
        );
        return array_merge($links, $mylinks);
    }

    public function data_loss_warning($links)
    {
        $html  = '<div style="margin-top:20px;color:#856404;font-size:18px;line-height:1.3;font-weight:600;margin-bottom:40px;background-color: #ffeeba;padding:10px 10px;border-radius: 10px;">';
        $html .= __('All of your existing data will be erased if you install/import One Click demo data from here, so we recommend importing demo data only for a new website.', 'falar-toolkit');
        $html .= '</div>';
        return $html;
    }

    public function demo_config($demos)
    {
        $demos_array = array(
            'falar-demo' => array(
                'title' => __('Home One', 'falar-toolkit'),
                'screenshot' => 'https://preview.envytheme.com/falar-wp/assets/img/demos/home1.jpg',
                'preview_link' => 'https://themes.envytheme.com/falar/',
            ),
            'falar-demo2' => array(
                'title' => __('Home Two', 'falar-toolkit'),
                'screenshot' => 'https://preview.envytheme.com/falar-wp/assets/img/demos/home2.jpg',
                'preview_link' => 'https://themes.envytheme.com/falar/home-two/',
            ),
            'falar-demo3' => array(
                'title' => __('Home Three', 'falar-toolkit'),
                'screenshot' => 'https://preview.envytheme.com/falar-wp/assets/img/demos/home3.jpg',
                'preview_link' => 'https://themes.envytheme.com/falar/home-three/',
            ),
            'falar-demo4' => array(
                'title' => __('Home Four', 'falar-toolkit'),
                'screenshot' => 'https://preview.envytheme.com/falar-wp/assets/img/demos/home4.jpg',
                'preview_link' => 'https://themes.envytheme.com/falar/home-four/',
            ),
            'falar-demo5' => array(
                'title' => __('Home Five', 'falar-toolkit'),
                'screenshot' => 'https://preview.envytheme.com/falar-wp/assets/img/demos/home5.jpg',
                'preview_link' => 'https://themes.envytheme.com/falar/home-five/',
            ),
        );

        $download_url	 = 'https://themes.envytheme.com/tools/falar';

        foreach ($demos_array as $id => $data) {
            $demo = new FW_Ext_Backups_Demo($id, 'piecemeal', array(
                'url' => $download_url,
                'file_id' => $id,
            ));
            $demo->set_title($data['title']);
            $demo->set_screenshot($data['screenshot']);
            $demo->set_preview_link($data['preview_link']);

            $demos[ $demo->get_id() ] = $demo;

            unset($demo);
        }

        return $demos;
    }

    public function after_demo_install($collection)
    {
        // Update front page id
        $demos = array(
            'falar-demo'  => 10,
            'falar-demo2'  => 290,
            'falar-demo3'  => 488,
            'falar-demo4'  => 2545,
            'falar-demo5'  => 2549,
        );

        $data = $collection->to_array();
        foreach ($data['tasks'] as $task) {
            if ($task['id'] == 'demo:demo-download') {
                $demo_id = $task['args']['demo_id'];
                $page_id = $demos[$demo_id];
                update_option('page_on_front', $page_id);
                flush_rewrite_rules();
                break;
            }
        }

        // Update WooCommerce email options //todo
        $email = get_option('admin_email');
        $name  = get_bloginfo('name', 'display');

        update_option('woocommerce_stock_email_recipient', $admin_email);
        update_option('woocommerce_email_from_address', $admin_email);
        update_option('woocommerce_email_from_name', $name);

        // Update post author id
        global $wpdb;
        $id = get_current_user_id();
        $query = "UPDATE $wpdb->posts SET post_author = $id";
        $wpdb->query($query);

        falar_function_pcs();
    }
}

Demo_Importer::instance();