<?php
/**
 * About Content Widget
 */

namespace Elementor;
class Falar_About_Content extends Widget_Base {

	public function get_name() {
        return 'Falar_About_content';
    }

	public function get_title() {
        return __( 'About Content', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_About_Content_Area',
			[
				'label' => __( 'About Content Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Explore how our university serves as a hub of excellence, bringing together top-tier education, cutting-edge research, and groundbreaking innovation to transform the world.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );


        $list_items = new Repeater();

        $list_items->add_control(
            'funfact_image',
            [
                'label'       => __( 'Funfact Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $list_items->add_control(
            'number',
            [
                'label'       => __( 'Number', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $list_items->add_control(
            'target',
            [
                'label'       => __( 'Target', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $list_items->add_control(
            'f_content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'funfact_item',
            [
                'label' => esc_html__('Add Funfact Item', 'falar-toolkit'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $list_items->get_controls(),
            ]
        );

        $this->add_control(
            'about_logo',
            [
                'label'       => __( 'Logo', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'text_shape',
            [
                'label'       => __( 'Text Shape', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'about_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-style2-content .content h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-style2-content .content h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-style2-content .content .title' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-style2-content .content .title',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $funfact_item = $settings['funfact_item'];
        ?>

            <div class="four-about-content">
                <?php if( $settings['content']): ?>
                    <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                <?php endif; ?>
                <?php $i = 1; foreach($funfact_item as $item_funfact): ?>
                    <div class="abot-item <?php if($i == 2): ?>style2<?php endif; ?>">
                        <div class="icon-content">
                            <?php if( $item_funfact['funfact_image']['url'] != '' ): ?>
                                <img src="<?php echo esc_url($item_funfact['funfact_image']['url'] ) ?>" class="about-icon" alt="image">
                            <?php endif; ?>
                            <h4 class="counter"><?php echo wp_kses_post( $item_funfact['number'] ); ?></h4>
                            <h4 class="plus"><?php echo wp_kses_post( $item_funfact['target'] ); ?></h4>
                        </div>
                        <h6><?php echo wp_kses_post( $item_funfact['f_content'] ); ?></h6>
                    </div>
                <?php $i++; endforeach; ?>
                <div class="round-shape">
                    <?php if( $settings['about_logo']['url'] != '' ): ?>
                        <img src="<?php echo esc_url($settings['about_logo']['url'] ) ?>" class="main-logo" alt="image">
                    <?php endif; ?>
                    <?php if( $settings['text_shape']['url'] != '' ): ?>
                        <img src="<?php echo esc_url($settings['text_shape']['url'] ) ?>" class="text-shape" alt="image">
                    <?php endif; ?>
                </div>
            </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_About_Content );