<?php
/**
 * Accessibility Widget
 */

namespace Elementor;
class Falar_Accessibility extends Widget_Base {

	public function get_name() {
        return 'Falar_Accessibility';
    }

	public function get_title() {
        return __( 'Accessibility', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Accessibility_Area',
			[
				'label' => __( 'Accessibility Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Our Commitment to Accessibility and the Accessibility for Ontarians with Disabilities Act (AODA)', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Falar at all times undertakes reasonable efforts to provide our educational goods, services or facilities in ways that:', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content2',
            [
                'label'       => __( 'Content Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title2',
            [
                'label'       => __( 'Title Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Let us know how we are doing!', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content3',
            [
                'label'       => __( 'Content Three', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('We welcome your accessibility feedback. All feedback, including complaints will be directed to the <span>Manager, Accessibility and Inclusion.</span> Please be sure to include your contact information and preferred method of communication (phone, email, virtual meeting, etc.) and we will respond in a timely manner. Appointments may also be scheduled.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'phone_title',
            [
                'label'       => __( 'Phone Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Phone:', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'phone_no',
            [
                'label'       => __( 'Phone No', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'mail_title',
            [
                'label'       => __( 'Mail Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Email:', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'email_address',
            [
                'label'       => __( 'Email Address', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content4',
            [
                'label'       => __( 'Content Four', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Mailing address: <span>Manager, Accessibility and Inclusion, Centre for Equity and Inclusion, Davis Campus 7899 McLaughlin Road, Brampton</span>', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title3',
            [
                'label'       => __( 'Title Three', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Important accessibility information', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        

        $list_items = new Repeater();

            $list_items->add_control(
				'link_text',
				[
					'label'       => __( 'Link Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'link_url',
				[
					'label'       => __( 'Link Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
                'active_style',
                [
                    'label' 	=> esc_html__( 'Active/Inactive Style', 'falar-toolkit' ),
                    'type' 		=> Controls_Manager::SELECT,
                    'options' 	=> [
                        '1'         => esc_html__( 'Inactive', 'falar-toolkit' ),
                        '2'         => esc_html__( 'Active', 'falar-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            $this->add_control(
                'link_item',
                [
                    'label' => esc_html__('Add Link Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );
            $list_item = new Repeater();
            $list_item->add_control(
                'question_title',
                [
                    'label' => __( 'Question Title', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $list_item->add_control(
                'question_content',
                [
                    'label' => __( 'Question Content', 'falar-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'question_item',
                [
                    'label' => esc_html__('Add Question Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_item->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'accessibility_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title p',
                ]
            );

            $this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .accessibility-content2 h4' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .accessibility-content2 h4',
                ]
            );
            $this->add_control(
				'title_color3',
				[
					'label'     => __( 'Title Color Three', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .accessibility-accordion-warp h4' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography3',
                    'label'    => __( 'Title Typography Three', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .accessibility-accordion-warp h4',
                ]
            );

            $this->add_control(
				'paragraph_color',
				[
					'label'     => __( 'Paragraph Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'paragraph_typography',
                    'label'    => __( 'Paragraph Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} p',
                ]
            );
            $this->add_control(
				'faq_title_color',
				[
					'label'     => __( 'Faq Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .accessibility-accordion-warp .accessibility-accordion .accordion-item .accordion-button' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'faq_title_typography',
                    'label'    => __( 'Faq Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .accessibility-accordion-warp .accessibility-accordion .accordion-item .accordion-button',
                ]
            );

            $this->add_control(
				'site_btn_color',
				[
					'label'     => __( 'Site Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .accessibility-link-widget .accessibility-link-list a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'site_btn_bg_color',
				[
					'label'     => __( 'Site Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .accessibility-link-widget .accessibility-link-list a' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'site_btn_typography',
                    'label'    => __( 'Site Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .accessibility-link-widget .accessibility-link-list a',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $question_item = $settings['question_item'];
        $link_item     = $settings['link_item'];
        ?>

        <!-- Student Accessibility Warp Start -->
        <div class="student-accessibility-warp ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="student-accessibility-content">
                            <div class="blog-title">
                                <?php if( $settings['title']): ?>
                                    <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                                <?php endif; ?>
                                <?php if( $settings['content']): ?>
                                    <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                                <?php endif; ?>
                                <?php if( $settings['content2']): ?>
                                    <ul class="accessibility-list">
                                        <?php echo wp_kses_post( $settings['content2'] ); ?>
                                    </ul>
                                <?php endif; ?>
                            </div>
                            <div class="accessibility-content2">
                                <?php if( $settings['title2']): ?>
                                    <h4><?php echo wp_kses_post( $settings['title2'] ); ?></h4>
                                <?php endif; ?>
                                <?php if( $settings['content3']): ?>
                                    <p><?php echo wp_kses_post( $settings['content3'] ); ?></p>
                                <?php endif; ?>
                                <ul class="accessibility-contact-list">
                                    <?php if( $settings['phone_no']): ?>
                                        <li>
                                            <?php echo wp_kses_post( $settings['phone_title'] ); ?> <a href="tel:<?php echo wp_kses_post( $settings['phone_no'] ); ?>"> <?php echo wp_kses_post( $settings['phone_no'] ); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if( $settings['email_address']): ?>
                                        <li>
                                            <?php echo wp_kses_post( $settings['mail_title'] ); ?> <a href="mailto:<?php echo wp_kses_post( $settings['email_address'] ); ?>"> <?php echo wp_kses_post( $settings['email_address'] ); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if( $settings['content4']): ?>
                                        <li><?php echo wp_kses_post( $settings['content4'] ); ?></li>
                                    <?php endif; ?>
                                </ul>

                                <div class="accessibility-accordion-warp">
                                    <?php if( $settings['title3']): ?>
                                        <h4><?php echo wp_kses_post( $settings['title3'] ); ?></h4>
                                    <?php endif; ?>
                                    <div class="accordion accessibility-accordion" id="faqAccordion">
                                        <?php $i = 1;  foreach( $question_item as $item_question ): 
                                            $cl='';
                                            if ($i == 1) {
                                                $cl='';
                                            }else {
                                                $cl='collapsed';
                                            }

                                            if($i <= 10):
                                        ?>
                                        <?php if( $item_question['question_title']): ?>
                                        <div class="accordion-item">
                                            <button class="accordion-button <?php echo esc_attr($cl); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1<?php echo $i; ?>" aria-expanded="true" aria-controls="collapse1<?php echo $i; ?>">
                                                <?php echo esc_attr( $item_question['question_title']) ?>
                                            </button>
                                            <div id="collapse1<?php echo $i; ?>" class="accordion-collapse collapse <?php if($i == 1): ?>show<?php endif; ?>" data-bs-parent="#faqAccordion">
                                                <div class="accordion-body">
                                                    <p><?php echo wp_kses_post( $item_question['question_content']) ?></p>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                        <?php endif; $i++; endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="accessibility-link-widget">
                            <div class="accessibility-link-list">
                                <?php foreach($link_item as $item_link): ?>
                                    <a href="<?php echo wp_kses_post( $item_link['link_url'] ); ?>" class="item <?php if ($item_link['active_style']=='1'): ?>inactive<?php elseif($item_link['active_style']=='2'): ?>active<?php endif; ?>"><?php echo wp_kses_post( $item_link['link_text'] ); ?>
                                        <div class="icon">
                                            <i class="ti ti-caret-right-filled"></i>
                                        </div>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Student Accessibility Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Accessibility );