<?php
/**
 * Alumni Widget
 */

namespace Elementor;
class Falar_Alumni extends Widget_Base {

	public function get_name() {
        return 'Falar_Alumni';
    }

	public function get_title() {
        return __( 'Alumni', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Alumni_Area',
			[
				'label' => __( 'Alumni Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Falar Alumni', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Welcome Falar alumni! Here, you can find out what your fellow classmates are up to, learn about alumni events, and get exclusive discounts and benefits. Join more than 215,000 graduates celebrating their Falar pride.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title2',
            [
                'label'       => __( 'Title Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('International: Thank you for having your say', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content2',
            [
                'label'       => __( 'Content Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Earlier this year, we conducted our second Falar Alumni survey. Thank you to everyone who took the time to fill out the survey. Your voices will guide us forward as we find more ways to benefit you.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_text',
            [
                'label'       => __( 'Button Text', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('View Falar Alumni Survey Result', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label'       => __( 'Button Url', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'link_text',
				[
					'label'       => __( 'Link Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'link_url',
				[
					'label'       => __( 'Link Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'link_item',
                [
                    'label' => esc_html__('Add Link Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'alumni_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title p',
                ]
            );

            $this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .international-content .survey-result h4' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .international-content .survey-result h4',
                ]
            );

            $this->add_control(
				'paragraph_color',
				[
					'label'     => __( 'Paragraph Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'paragraph_typography',
                    'label'    => __( 'Paragraph Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} p',
                ]
            );

            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .international-content .survey-result a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .international-content .survey-result a',
                ]
            );

            $this->add_control(
				'site_btn_color',
				[
					'label'     => __( 'Site Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .international-list-widget .international-list a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'site_btn_bg_color',
				[
					'label'     => __( 'Site Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .international-list-widget .international-list a' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'site_btn_typography',
                    'label'    => __( 'Site Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .international-list-widget .international-list a',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $link_item = $settings['link_item'];
        ?>

        <!-- International Warp Start -->
        <div class="international-warp ptb-100">
            <div class="container">
                <div class="row g-5">
                    <div class="col-lg-8">
                        <div class="international-content">
                            <div class="blog-title">
                                <?php if( $settings['title']): ?>
                                    <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                                <?php endif; ?>
                                <?php if( $settings['content']): ?>
                                    <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="survey-result">
                                <?php if( $settings['title2']): ?>
                                    <h4><?php echo wp_kses_post( $settings['title2'] ); ?></h4>
                                <?php endif; ?>
                                <?php if( $settings['content2']): ?>
                                    <p><?php echo wp_kses_post( $settings['content2'] ); ?></p>
                                <?php endif; ?>
                                <?php if( $settings['btn_text']): ?>
                                    <a href="<?php echo wp_kses_post( $settings['btn_url'] ); ?>" class="survey-link">
                                        <span><?php echo wp_kses_post( $settings['btn_text'] ); ?></span> 
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="international-list-widget">
                            <div class="international-list">
                                <?php foreach($link_item as $item_link): ?>
                                    <a class="item" href="<?php echo wp_kses_post( $item_link['link_url'] ); ?>">
                                        <?php echo wp_kses_post( $item_link['link_text'] ); ?>
                                        <i class="ti ti-caret-right-filled"></i>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- International Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Alumni );