<?php
/**
 * Banner Five Widget
 */

namespace Elementor;
class Falar_Banner_Five extends Widget_Base {

	public function get_name() {
        return 'Falar_Banner_Five';
    }

	public function get_title() {
        return __( 'Banner Five', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Banner_Five_Area',
			[
				'label' => __( 'Banner Five Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
            
            $list_items = new Repeater();

            $list_items->add_control(
				'top_title',
				[
					'label'       => __( 'Top Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('Leading Innovation for a Healthier World', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'title',
				[
					'label'       => __( 'Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('Faculty Of Medicine And Healthcare', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'content',
				[
					'label'       => __( 'Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('Experience a dynamic learning environment where medical excellence meets a passion for inspiring change.', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'btn_url1',
				[
					'label'       => __( 'Button Url One', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
				]
			);
            $list_items->add_control(
				'btn_text1',
				[
					'label'       => __( 'Button Text One', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('View Report', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'btn_url2',
				[
					'label'       => __( 'Button Url Two', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
				]
			);
            $list_items->add_control(
				'btn_text2',
				[
					'label'       => __( 'Button Text Two', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('View All Programs', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            
            $this->add_control(
                'banner_item',
                [
                    'label' => esc_html__('Add Banner Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
				'site_btn_text',
				[
					'label'       => __( 'Site Button Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('View all latest news updates of Falar', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $this->add_control(
				'site_btn_url',
				[
					'label'       => __( 'Site Button Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
				]
			);
            $this->add_control(
				'site_btn_icon',
				[
					'label'       => __( 'Site Button Icon', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('ti ti-arrow-narrow-right', 'falar-toolkit'),
                    'label_block' => true,
				]
			);

            $this->add_control(
                'banner_bg',
                [
                    'label' => __( 'Banner Background Image', 'falar-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'banner_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'top_title_color',
				[
					'label'     => __( 'Top Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-five-slider-widget .home-five-content .title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-five-slider-widget .home-five-content .title',
                ]
            );
			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-five-slider-widget .home-five-content h1' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-five-slider-widget .home-five-content h1',
                ]
            );

            $this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-five-slider-widget .home-five-content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-five-slider-widget .home-five-content p',
                ]
            );

			$this->add_control(
				'btn_text_color',
				[
					'label'     => __( 'Button Text Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-five-slider-widget .home-five-content .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-five-slider-widget .home-five-content .default-btn' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_bg_h_color',
				[
					'label'     => __( 'Button Background Hover Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-five-slider-widget .home-five-content .default-btn:hover' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-five-slider-widget .home-five-content .default-btn',
                ]
            );

            $this->add_control(
				'btn_text_color2',
				[
					'label'     => __( 'Button Two Text Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-five-slider-widget .home-five-content .default-btn.style2' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_control(
				'btn_bg_color2',
				[
					'label'     => __( 'Button Background Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-five-slider-widget .home-five-content .default-btn.style2' => 'background: {{VALUE}}',
					],
				]
			);
			
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn2_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-five-slider-widget .home-five-content .default-btn.style2',
                ]
            );

            $this->add_control(
				'update_btn_text_color',
				[
					'label'     => __( 'Update Button Text Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-five-hero-area .view-link' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'update_btn_bg_color',
				[
					'label'     => __( 'Update Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-five-hero-area .view-link' => 'background-color: {{VALUE}}',
					],
				]
			);
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'update_btn_text_typography',
                    'label'    => __( 'Update Button Text Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-five-hero-area .view-link',
                ]
            );


        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $banner_item = $settings['banner_item'];
        ?>

        <!-- Home Five Hero Area Start -->
        <div class="home-five-hero-area" style="background-image:url(<?php echo esc_url( $settings['banner_bg']['url'] ); ?>);">
            <div class="container-fluid">
                <div class="home-five-slider-widget">
                    <div class="swiper home-five-hero-slider">
                        <div class="swiper-wrapper">
                            <?php foreach($banner_item as $item_banner): ?>
                                <div class="swiper-slide">
                                    <div class="home-five-content">
                                        <?php if( $item_banner['top_title']): ?>
                                            <span class="title">
                                                <?php echo wp_kses_post( $item_banner['top_title'] ); ?>
                                            </span>
                                        <?php endif; ?>
                                        <?php if( $item_banner['title']): ?>
                                            <h1>
                                                <?php echo wp_kses_post( $item_banner['title'] ); ?>
                                            </h1>
                                        <?php endif; ?>
                                        <?php if( $item_banner['content']): ?>
                                            <p>
                                                <?php echo wp_kses_post( $item_banner['content'] ); ?>
                                            </p>
                                        <?php endif; ?>
                                        <div class="hero-btn">
                                            <?php if( $item_banner['btn_url1']): ?>
                                                <a href="<?php echo esc_url( $item_banner['btn_url1'] ); ?>" class="default-btn"><?php echo esc_attr( $item_banner['btn_text1'] ); ?>
                                                    <i class="ti ti-arrow-narrow-right"></i>
                                                </a>
                                            <?php endif; ?> 
                                            <?php if( $item_banner['btn_url2']): ?>
                                                <a href="<?php echo esc_url( $item_banner['btn_url2'] ); ?>" class="default-btn style2"><?php echo esc_attr( $item_banner['btn_text2'] ); ?>
                                                    <i class="ti ti-arrow-narrow-right"></i>
                                                </a>
                                            <?php endif; ?> 
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <div class="five-hero-buttons">
                        <div class="swiper-btn">
                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
                <?php if( $settings['site_btn_url']): ?>
                    <a href="<?php echo esc_attr( $settings['site_btn_url'] ); ?>" class="default-btn view-link">
                        <span><?php echo esc_attr( $settings['site_btn_text'] ); ?></span>
                        <i class="<?php echo esc_attr( $settings['site_btn_icon'] ); ?>"></i>
                    </a>
                <?php endif; ?> 
            </div>
        </div>
        <!-- Home Five Hero Area End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Banner_Five );