<?php
/**
 * Banner Four Widget
 */

namespace Elementor;
class Falar_Banner_Four extends Widget_Base {

	public function get_name() {
        return 'Falar_Banner_Four';
    }

	public function get_title() {
        return __( 'Banner Four', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Banner_Area',
			[
				'label' => __( 'Banner Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'top_title',
            [
                'label' => __( 'Top Title', 'falar-toolkit' ),
                'default' => __( 'Best Institute of science and technology', 'falar-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'falar-toolkit' ),
                'default' => __( 'Pioneering Future Technologies with the  Excellence and Innovation', 'falar-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'content',
            [
                'label' => __( 'Content', 'falar-toolkit' ),
                'default' => __( 'Experience a dynamic learning environment where engineering excellence meets a passion for inspiring change.', 'falar-toolkit' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'btn_text1',
            [
                'label'       => __( 'Button Text One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('View Report', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'btn_url1',
            [
                'label'       => __( 'Button Url One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'btn_icon1',
            [
                'type'    => Controls_Manager::ICON,
                'label'   => esc_html__( 'Button One Arrow Icon', 'falar-toolkit' ),
                'label_block' => true,
                'options' => falar_icons(),
            ]
        );

        $this->add_control(
            'btn_text2',
            [
                'label'       => __( 'Button Text Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('View All Programs', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'btn_url2',
            [
                'label'       => __( 'Button Url Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'btn_icon2',
            [
                'type'    => Controls_Manager::ICON,
                'label'   => esc_html__( 'Button Two Arrow Icon', 'falar-toolkit' ),
                'label_block' => true,
                'options' => falar_icons(),
            ]
        );

        $this->add_control(
            'btn_text3',
            [
                'label'       => __( 'Button Text Three', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('View all latest news updates of Falar', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'btn_url3',
            [
                'label'       => __( 'Button Url Three', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'btn_icon3',
            [
                'type'    => Controls_Manager::ICON,
                'label'   => esc_html__( 'Button Three Arrow Icon', 'falar-toolkit' ),
                'label_block' => true,
                'options' => falar_icons(),
            ]
        );
        $this->add_control(
            'shape',
            [
                'label'       => __( 'Shape', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'bg_img',
            [
                'label'       => __( 'Background Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'banner_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'top_title_color',
				[
					'label'     => __( 'Top Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-content .title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-four-content .title',
                ]
            );
			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-content h1' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-four-content h1',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-four-content p',
                ]
            );

			$this->add_control(
				'btn_text_color',
				[
					'label'     => __( 'Button Text Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_bg_h_color',
				[
					'label'     => __( 'Button Background Hover Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn:hover' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );

            $this->add_control(
				'btn_text_color2',
				[
					'label'     => __( 'Button Two Text Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-content .default-btn.style2' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_bg_color2',
				[
					'label'     => __( 'Button Two Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-content .default-btn.style2' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_b_color2',
				[
					'label'     => __( 'Button Two Border Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-content .default-btn.style2' => 'border-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_bg_h_color2',
				[
					'label'     => __( 'Button Two Background Hover Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-content .default-btn.style2:hover' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography2',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-four-content .default-btn.style2',
                ]
            );

            $this->add_control(
				'area_bg_color',
				[
					'label'     => __( 'Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-four-hero-area' => 'background: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Home Four Hero Area Start -->
        <div class="home-four-hero-area" style="background-image:url(<?php echo esc_url( $settings['bg_img']['url'] ); ?>);">
            <div class="container-fluid">
                <div class="home-four-content">
                    <?php if( $settings['top_title']): ?>
                        <span class="title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                    <?php endif; ?>
                    <?php if( $settings['title']): ?>
                        <h1><?php echo wp_kses_post( $settings['title'] ); ?></h1>
                    <?php endif; ?>
                    <?php if( $settings['content']): ?>
                        <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                    <?php endif; ?>
                    <div class="hero-btn">
                        <?php if( $settings['btn_url1']): ?>
                            <a href="<?php echo esc_attr( $settings['btn_url1'] ); ?>" class="default-btn"><?php echo esc_attr( $settings['btn_text1'] ); ?>
                                <i class="<?php echo esc_attr( $settings['btn_icon1']) ?>"></i>
                            </a>
                        <?php endif; ?>
                        <?php if( $settings['btn_url2']): ?>
                            <a href="<?php echo esc_attr( $settings['btn_url2'] ); ?>" class="default-btn style2"><?php echo esc_attr( $settings['btn_text2'] ); ?>
                                <i class="<?php echo esc_attr( $settings['btn_icon2']) ?>"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if( $settings['btn_url3']): ?>
                    <a href="<?php echo esc_attr( $settings['btn_url3'] ); ?>" class="default-btn view-link">
                        <span><?php echo esc_attr( $settings['btn_text3'] ); ?></span>
                        <i class="<?php echo esc_attr( $settings['btn_icon3']) ?>"></i>
                    </a>
                <?php endif; ?>
            </div>
            <?php if( $settings['shape']['url'] != '' ): ?>
                <div class="all-shapes">
                    <img src="<?php echo esc_url( $settings['shape']['url'] ); ?>" class="hero-text" alt="Word">
                </div>
            <?php endif; ?>
        </div>
        <!-- Home Four Hero Area End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Banner_Four );