<?php
/**
 * Banner Three Widget
 */

namespace Elementor;
class Falar_Banner_Three extends Widget_Base {

	public function get_name() {
        return 'Falar_Banner_Three';
    }

	public function get_title() {
        return __( 'Banner Three', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Banner_Area',
			[
				'label' => __( 'Banner Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
            
        $list_items = new Repeater();

        $list_items->add_control(
            'tab_title',
            [
                'label' => __( 'Tab Title', 'falar-toolkit' ),
                'default' => __( 'Start Career', 'falar-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $list_items->add_control(
            'bg_image',
            [
                'label' => __( 'Background Image', 'falar-toolkit' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $list_items->add_control(
            'title',
            [
                'label' => __( 'Title', 'falar-toolkit' ),
                'default' => __( 'Falar University', 'falar-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $list_items->add_control(
            'content',
            [
                'label' => __( 'Content', 'falar-toolkit' ),
                'default' => __( 'Welcome to Falar University, where knowledge meets innovation and where every student is journey to success begins.', 'falar-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $list_items->add_control(
            'btn_text',
            [
                'label' => __( 'Button Text', 'falar-toolkit' ),
                'default' => __( 'View Programs', 'falar-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $list_items->add_control(
            'btn_link',
            [
                'label' => __( 'Button Url', 'falar-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'tabs',
            [
                'label' => __('Tab Items', 'adin-toolkit'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $list_items->get_controls(),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'banner_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hero-style3-content h1' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .hero-style3-content h1',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hero-style3-content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .hero-style3-content p',
                ]
            );

			$this->add_control(
				'btn_text_color',
				[
					'label'     => __( 'Button Text Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_bg_h_color',
				[
					'label'     => __( 'Button Background Hover Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn:hover' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );
            $this->add_control(
				'tab_title_color',
				[
					'label'     => __( 'Tab Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hero-style3-warp .hero-nav .nav-item .nav-link' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'tab_title_typography',
                    'label'    => __( 'Tab Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .hero-style3-warp .hero-nav .nav-item .nav-link',
                ]
            );
            $this->add_control(
				'tab_title_bg_color',
				[
					'label'     => __( 'tab Title Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hero-style3-warp .hero-nav' => 'background: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Hero Style3 Warp Start -->
        <div class="hero-style3-warp">
            <div class="tab-content" id="pills-tabsContent">
                <?php $tab_i = 1; foreach($settings['tabs'] as $tab): ?>
                    <div class="tab-pane fade <?php if($tab_i == 1): ?>show active<?php endif; ?>" id="nz-tab<?php echo esc_attr($tab_i); ?>-pane" role="tabpanel" tabindex="0">
                        <div class="inner-hero2-style" style="background-image:url(<?php echo esc_url( $tab['bg_image']['url'] ); ?>);">
                            <div class="container-fluid">
                                <div class="hero-style3-content" data-cue="slideInUp">
                                    <h1><?php echo esc_html($tab['title']); ?></h1>
                                    <p><?php echo esc_html($tab['content']); ?></p>
                                    <?php if( $tab['btn_link']): ?>
                                        <a href="<?php echo esc_html($tab['btn_link']); ?>" class="default-btn"><?php echo esc_html($tab['btn_text']); ?>
                                            <i class="ti ti-arrow-narrow-right"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php $tab_i++; endforeach; ?>
            </div>
            <ul class="nav nav-pills hero-nav" id="pills-tabs" role="tablist">
                <?php $i = 1; foreach($settings['tabs'] as $tab): ?>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link  <?php if($i == 1): ?>active<?php endif; ?>" id="nz-tab<?php echo esc_attr($i); ?>" data-bs-toggle="tab" data-bs-target="#nz-tab<?php echo esc_attr($i); ?>-pane" role="tab" aria-controls="nz-tab<?php echo esc_attr($i); ?>-pane" aria-selected="true">
                            <?php echo esc_html($tab['tab_title']); ?>
                        </button>
                    </li>
                <?php $i++; endforeach; ?>
            </ul>
        </div>
        <!-- Hero Style3 Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Banner_Three );