<?php
/**
 * Banner One Widget
 */

namespace Elementor;
class Falar_Banner_One extends Widget_Base {

	public function get_name() {
        return 'Falar_Banner_One';
    }

	public function get_title() {
        return __( 'Banner One', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Banner_Area',
			[
				'label' => __( 'Banner Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
            
            $list_items = new Repeater();

            $list_items->add_control(
				'title',
				[
					'label'       => __( 'Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('Falar tops the best world higher education ranking in 2024', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'btn_url1',
				[
					'label'       => __( 'Button Url One', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
				]
			);
            $list_items->add_control(
				'btn_text1',
				[
					'label'       => __( 'Button Text One', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('View Report', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'btn_url2',
				[
					'label'       => __( 'Button Url Two', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
				]
			);
            $list_items->add_control(
				'btn_text2',
				[
					'label'       => __( 'Button Text Two', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('View All Programs', 'falar-toolkit'),
                    'label_block' => true,
				]
			);

            $list_items->add_control(
				'site_btn_url1',
				[
					'label'       => __( 'Site Button Url One', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
				]
			);
            $list_items->add_control(
				'site_btn_text1',
				[
					'label'       => __( 'Site Button Text One', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('View all latest news updates of Farol', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'site_btn_icon1',
				[
					'label'       => __( 'Site Button Icon One', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('ti ti-arrow-narrow-right', 'falar-toolkit'),
                    'label_block' => true,
				]
			);


            $list_items->add_control(
				'site_btn_url2',
				[
					'label'       => __( 'Site Button Url Two', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
				]
			);
            $list_items->add_control(
				'site_btn_text2',
				[
					'label'       => __( 'Site Button Text Two', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('Take A Tour', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'site_btn_icon2',
				[
					'label'       => __( 'Site Button Icon Two', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('ti ti-world', 'falar-toolkit'),
                    'label_block' => true,
				]
			);


            $list_items->add_control(
				'site_btn_url3',
				[
					'label'       => __( 'Site Button Url Three', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
				]
			);
            $list_items->add_control(
				'site_btn_text3',
				[
					'label'       => __( 'Site Button Text Three', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('Campus Information', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'site_btn_icon3',
				[
					'label'       => __( 'Site Button Icon Three', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('ti ti-info-hexagon', 'falar-toolkit'),
                    'label_block' => true,
				]
			);

            $list_items->add_control(
				'site_btn_url4',
				[
					'label'       => __( 'Site Button Url Four', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
				]
			);
            $list_items->add_control(
				'site_btn_text4',
				[
					'label'       => __( 'Site Button Text Four', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('Apply Now', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'site_btn_icon4',
				[
					'label'       => __( 'Site Button Icon Four', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => __('ti ti-ballpen', 'falar-toolkit'),
                    'label_block' => true,
				]
			);

            $list_items->add_control(
                'banner_bg',
                [
                    'label' => __( 'Banner Background Image', 'falar-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            
            $this->add_control(
                'banner_item',
                [
                    'label' => esc_html__('Add Banner Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'banner_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hero-slider-warp .content h1' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .hero-slider-warp .content h1',
                ]
            );

			$this->add_control(
				'btn_text_color',
				[
					'label'     => __( 'Button Text Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_bg_h_color',
				[
					'label'     => __( 'Button Background Hover Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn:hover' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn',
                ]
            );

            $this->add_control(
				'btn_text_color2',
				[
					'label'     => __( 'Button Two Text Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hero-slider-warp .content .default-btn.style2' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_border_color',
				[
					'label'     => __( 'Button Border Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .hero-slider-warp .content .default-btn.style2' => 'border-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn2_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .hero-slider-warp .content .default-btn.style2',
                ]
            );

            $this->add_control(
				'update_btn_text_color',
				[
					'label'     => __( 'Update Button Text Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .update-link' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'update_btn_text_typography',
                    'label'    => __( 'Update Button Text Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .update-link',
                ]
            );

            $this->add_control(
				'info_btn_text_color',
				[
					'label'     => __( 'Info Button Text Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .information li' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_btn_text_typography',
                    'label'    => __( 'Info Button Text Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .information li',
                ]
            );
            $this->add_control(
				'info_btn_bg_color1',
				[
					'label'     => __( 'Info Button Background Color One', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .information li:first-child' => 'background-color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'info_btn_bg_color2',
				[
					'label'     => __( 'Info Button Background Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .information li:nth-child(2)' => 'background-color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'info_btn_bg_color3',
				[
					'label'     => __( 'Info Button Background Color Three', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .information li:last-child' => 'background-color: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $banner_item = $settings['banner_item'];
        ?>

        <!-- Hero Warp Start -->
        <div class="hero-warp">
            <div class="swiper hero-slider">
                <div class="swiper-wrapper">
                    <?php foreach($banner_item as $item_banner): ?>
                        <div class="swiper-slide">
                            <div class="hero-slider-warp" style="background-image:url(<?php echo esc_url( $item_banner['banner_bg']['url'] ); ?>);">
                                <div class="container-fluid">
                                    <div class="content">
                                        <?php if( $item_banner['title']): ?>
                                            <h1 class="title">
                                                <?php echo wp_kses_post( $item_banner['title'] ); ?>
                                            </h1>
                                        <?php endif; ?>
                                        <div class="hero-btn">
                                            <?php if( $item_banner['btn_url1']): ?>
                                                <a href="<?php echo esc_url( $item_banner['btn_url1'] ); ?>" class="default-btn"><?php echo esc_attr( $item_banner['btn_text1'] ); ?>
                                                    <i class="ti ti-arrow-narrow-right"></i>
                                                </a>
                                            <?php endif; ?> 
                                            <?php if( $item_banner['btn_url2']): ?>
                                                <a href="<?php echo esc_url( $item_banner['btn_url2'] ); ?>" class="default-btn style2"><?php echo esc_attr( $item_banner['btn_text2'] ); ?>
                                                    <i class="ti ti-arrow-narrow-right"></i>
                                                </a>
                                            <?php endif; ?> 
                                        </div>
                                    </div>
                                    <ul class="information">
                                        <?php if( $item_banner['site_btn_url2']): ?>
                                            <li>
                                                <i class="<?php echo esc_attr( $item_banner['site_btn_icon2'] ); ?>"></i>
                                                <a href="<?php echo esc_attr( $item_banner['site_btn_url2'] ); ?>"><?php echo esc_attr( $item_banner['site_btn_text2'] ); ?></a>
                                            </li>
                                        <?php endif; ?> 
                                        <?php if( $item_banner['site_btn_url3']): ?>
                                            <li>
                                                <i class="<?php echo esc_attr( $item_banner['site_btn_icon3'] ); ?>"></i>
                                                <a href="<?php echo esc_attr( $item_banner['site_btn_url3'] ); ?>"><?php echo esc_attr( $item_banner['site_btn_text3'] ); ?></a>
                                            </li>
                                        <?php endif; ?> 
                                        <?php if( $item_banner['site_btn_url4']): ?>
                                            <li>
                                                <i class="<?php echo esc_attr( $item_banner['site_btn_icon4'] ); ?>"></i>
                                                <a href="<?php echo esc_attr( $item_banner['site_btn_url4'] ); ?>"><?php echo esc_attr( $item_banner['site_btn_text4'] ); ?></a>
                                            </li>
                                        <?php endif; ?> 
                                    </ul>
                                    <?php if( $item_banner['site_btn_url1']): ?>
                                        <a href="<?php echo esc_attr( $item_banner['site_btn_url1'] ); ?>" class="update-link">
                                            <span><?php echo esc_attr( $item_banner['site_btn_text1'] ); ?></span>
                                            <i class="<?php echo esc_attr( $item_banner['site_btn_icon1'] ); ?>"></i>
                                        </a>
                                    <?php endif; ?> 
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <div class="pagination-bullet-btn text-end">
                    <div class="swiper-pagination2"></div>
                </div>
            </div>
        </div>
        <!-- Hero Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Banner_One );