<?php
/**
 * Map Widget
 */

namespace Elementor;
class Falar_Capmpus_Map extends Widget_Base {

	public function get_name() {
        return 'Falar_Capmpus_Map';
    }

	public function get_title() {
        return __( 'Capmpus Map', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Capmpus_Map_Area',
			[
				'label' => __( 'Capmpus Map Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'map_link',
            [
                'label'       => __( 'Campus Map Link', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Get The Direction Of Our Campus', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Location', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('32/6, Western Hill, Canada', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'link',
            [
                'label'       => __( 'Link', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
			'map_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .map-content h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .map-content h2',
                ]
            );
            $this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .map-content .details-icon p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .map-content .details-icon p',
                ]
            );

            $this->add_control(
				'card_bg_color',
				[
					'label'     => __( 'Card Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .map-content .details-icon p' => 'background: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Campus Map Warp Start -->
        <div class="campus-map">
            <div class="container">
                <div class="inner-campus-map">
                    <?php if( $settings['map_link']): ?>
                        <iframe src="<?php echo wp_kses_post( $settings['map_link'] ); ?>" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    <?php endif; ?> 
                    <div class="row">
                        <div class="col-lg-6"></div>
                        <div class="col-lg-6">
                            <div class="map-content">
                                <?php if( $settings['title']): ?>
                                    <h2>
                                        <?php echo wp_kses_post( $settings['title'] ); ?>
                                    </h2>
                                <?php endif; ?>
                                <div class="details-icon">
                                    <?php if( $settings['content']): ?>
                                        <p>
                                            <i class="ti ti-map-pin"></i>
                                            <?php echo wp_kses_post( $settings['content'] ); ?>
                                        </p>
                                    <?php endif; ?>
                                    <?php if( $settings['link']): ?>
                                        <a href="<?php echo wp_kses_post( $settings['link'] ); ?>" target="_blank" class="icon">
                                            <i class="ti ti-arrow-narrow-right"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Campus Map Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Capmpus_Map );