<?php
/**
 * Campus Story Widget
 */

namespace Elementor;
class Falar_Campus_Story extends Widget_Base {

	public function get_name() {
        return 'Falar_Campus_Story';
    }

	public function get_title() {
        return __( 'Campus Story', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Campus_Story_Area',
			[
				'label' => __( 'Campus Story Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $list_items = new Repeater();

            $list_items->add_control(
				'campus_image',
				[
					'label'       => __( 'Card Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $list_items->add_control(
				'card_title',
				[
					'label'       => __( 'Card Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'card_link',
				[
					'label'       => __( 'card Link', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'campus_item',
                [
                    'label' => esc_html__('Add Campus Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'campus_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .campus-widget .content h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .campus-widget .content h3',
                ]
            );
			$this->add_control(
				'btn_color',
				[
					'label'     => __( 'Card Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .campus-widget .content .icon' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Card Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .campus-widget .content .icon' => 'background: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Card Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .campus-widget .content .icon',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $campus_item = $settings['campus_item'];
        ?>


        <!-- Campus Story Warp Story -->
        <div class="campus-story-warp pt-100">
            <div class="container-fluid">
                <div class="campus-slider-warp">
                    <div class="swiper campus-slider">
                        <div class="swiper-wrapper">
                            <?php $i=1; foreach($campus_item as $item_campus): ?>
                                <?php if($i % 2 == 0 ): ?>
                                    <div class="swiper-slide">
                                        <div class="campus-widget style2">
                                            <div class="content">
                                                <h3><?php echo wp_kses_post( $item_campus['card_title'] ); ?></h3>
                                                <?php if( $item_campus['card_link']): ?>
                                                    <a href="<?php echo wp_kses_post( $item_campus['card_link'] ); ?>" class="icon">
                                                        <i class="ti ti-arrow-narrow-right"></i>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                            <div class="image">
                                                <a href="<?php echo wp_kses_post( $item_campus['card_link'] ); ?>">
                                                    <?php if( $item_campus['campus_image']['url'] != '' ): ?>
                                                        <img src="<?php echo esc_url($item_campus['campus_image']['url'] ) ?>" alt="image">
                                                    <?php endif; ?>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php else: ?>
                                
                                <div class="swiper-slide">
                                    <div class="campus-widget style1">
                                        <div class="image">
                                            <a href="<?php echo wp_kses_post( $item_campus['card_link'] ); ?>">
                                                <?php if( $item_campus['campus_image']['url'] != '' ): ?>
                                                    <img src="<?php echo esc_url($item_campus['campus_image']['url'] ) ?>" alt="image">
                                                <?php endif; ?>
                                            </a>
                                        </div>
                                        <div class="content">
                                            <h3><?php echo wp_kses_post( $item_campus['card_title'] ); ?></h3>
                                            <?php if( $item_campus['card_link']): ?>
                                                <a href="<?php echo wp_kses_post( $item_campus['card_link'] ); ?>" class="icon">
                                                    <i class="ti ti-arrow-narrow-right"></i>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; $i++; endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Campus Story Warp End -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Campus_Story );