<?php
/**
 * Choose One Widget
 */

namespace Elementor;
class Falar_Choose extends Widget_Base {

	public function get_name() {
        return 'Falar_Choose';
    }

	public function get_title() {
        return __( 'Choose', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Choose_Area',
			[
				'label' => __( 'Choose Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $list_items = new Repeater();

            $list_items->add_control(
				'card_title',
				[
					'label'       => __( 'Card Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'content',
				[
					'label'       => __( 'Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'btn_text',
				[
					'label'       => __( 'Button text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'btn_url',
				[
					'label'       => __( 'Button Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'choose_item',
                [
                    'label' => esc_html__('Add Choose Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'choose_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .choose-card h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .choose-card h3',
                ]
            );
            $this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .choose-card p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .choose-card p',
                ]
            );
            $this->add_control(
				'content_btn_color',
				[
					'label'     => __( 'Card Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .choose-card .choose-link' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_btn_typography',
                    'label'    => __( 'Card Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .choose-card .choose-link',
                ]
            );
            $this->add_control(
				'card_bg_color1',
				[
					'label'     => __( 'Card Background Color One', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .choose-card.bg-1' => 'background-color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'card_bg_color2',
				[
					'label'     => __( 'Card Background Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .choose-card.bg-2' => 'background-color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'card_bg_color3',
				[
					'label'     => __( 'Card Background Color Three', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .choose-card.bg-3' => 'background-color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'card_bg_color4',
				[
					'label'     => __( 'Card Background Color Four', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .choose-card.bg-4' => 'background-color: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $choose_item = $settings['choose_item'];
        ?>

        <!-- Choose Warp Start -->
        <div class="choose-warp">
            <div class="container-fluid">
                <div class="row g-0">
                    <?php $i = 1; foreach($choose_item as $item_choose): ?>
                        <div class="col-lg-3 col-md-6">
                            <div class="choose-card bg-<?php echo esc_attr($i); ?>">
                                <h3><?php echo wp_kses_post( $item_choose['card_title'] ); ?></h3>
                                <p><?php echo wp_kses_post( $item_choose['content'] ); ?></p>
                                <?php if( $item_choose['btn_url']): ?>
                                    <a href="<?php echo wp_kses_post( $item_choose['btn_url'] ); ?>" class="choose-link">
                                        <span><?php echo wp_kses_post( $item_choose['btn_text'] ); ?></span>
                                        <i class="ti ti-arrow-narrow-right"></i>
                                    </a>
                                <?php endif; ?> 
                            </div>
                        </div>
                    <?php $i++; endforeach; ?>
                </div>
            </div>
        </div>
        <!-- Choose Warp End -->
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Choose );