<?php
/**
 * Enquiry Widget
 */

namespace Elementor;
class Falar_Enquiry extends Widget_Base {

	public function get_name() {
        return 'Falar_Enquiry';
    }

	public function get_title() {
        return __( 'Enquiry', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Enquiry_Area',
			[
				'label' => __( 'Enquiry Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('We Are A University Of Excellence!', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'enquiry_image1',
            [
                'label'       => __( 'Enquiry Image One', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'enquiry_image2',
            [
                'label'       => __( 'Enquiry Image Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'content1',
            [
                'label'       => __( 'Content One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('With over 100 years of history, the University of Luva is a leading teaching and scientific research institution in Canada and worldwide.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content2',
            [
                'label'       => __( 'Content Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Considered the best Canadian University and one of the best 100</span> European institutions according to the most important Higher Education rankings, U.Porto combines quality teaching and excellent research with the best academic experience. <span>We are waiting for you!', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'button_text',
            [
                'label'   => __( 'Button Text', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('See How To Apply', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'link_type',
            [
                'label' 		=> esc_html__( 'Button Link Type', 'falar-toolkit' ),
                'type' 			=> Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' => [
                    '1'  	=> esc_html__( 'Link To Page', 'falar-toolkit' ),
                    '2' 	=> esc_html__( 'External Link', 'falar-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'link_to_page',
            [
                'label' 		=> esc_html__( 'Button Link Page', 'falar-toolkit' ),
                'type' 			=> Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' 		=> falar_toolkit_get_page_as_list(),
                'condition' => [
                    'link_type' => '1',
                ]
            ]
        );

        $this->add_control(
            'ex_link',
            [
                'label'		=> esc_html__('Button External Link', 'falar-toolkit'),
                'type'		=> Controls_Manager:: TEXT,
                'condition' => [
                    'link_type' => '2',
                ]
            ]
        );

        $this->add_control(
            'phn_title',
            [
                'label'       => __( 'Phone Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default' => __('Call', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'phn_no',
            [
                'label'       => __( 'Phone Number', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'bottom_content',
            [
                'label'   => __( 'Bottom Content', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('For any kind of admission enquiry', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'shape',
            [
                'label'       => __( 'Shape', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'enquiry_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .enquiry-image h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .enquiry-image h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .enquiry-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .enquiry-content p',
                ]
            );
            $this->add_control(
				'btn_color',
				[
					'label'     => __( 'Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .enquiry-content .enquiry-link' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .enquiry-content .enquiry-link',
                ]
            );

            $this->add_control(
				'phone_icon_color',
				[
					'label'     => __( 'Phone Icon Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .enquiry-content .enquiry-content-style .icon' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'phone_icon_bg_color',
				[
					'label'     => __( 'Phone Icon Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .enquiry-content .enquiry-content-style .icon' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'phn_icon_typography',
                    'label'    => __( 'Phone Icon Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .enquiry-content .enquiry-content-style .icon',
                ]
            );
            $this->add_control(
				'num_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .enquiry-content .enquiry-content-style .content h4' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'num_typography',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .enquiry-content .enquiry-content-style .content h4',
                ]
            );
            $this->add_control(
				'area_bg_color',
				[
					'label'     => __( 'Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .enquiry-warp::before' => 'background: {{VALUE}}',
					],
				]
			);
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Get Button Link
        $link = '#';
        if( $settings['link_type'] == 1 ){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <!-- Enquiry Warp Start -->
        <div class="enquiry-warp ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="enquiry-image">
                            <?php if( $settings['title']): ?>
                                <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                            <?php endif; ?>
                            <div class="row">
                                <div class="col-lg-4 col-sm-4">
                                    <?php if( $settings['enquiry_image1']['url'] != '' ): ?>
                                        <div class="image">
                                            <img src="<?php echo esc_url($settings['enquiry_image1']['url'] ) ?>" alt="image">
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-8 col-sm-8">
                                    <?php if( $settings['enquiry_image2']['url'] != '' ): ?>
                                        <div class="image">
                                            <img src="<?php echo esc_url($settings['enquiry_image2']['url'] ) ?>" alt="image">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="enquiry-content">
                            <?php if( $settings['content1']): ?>
                                <p><?php echo wp_kses_post( $settings['content1'] ); ?></p>
                            <?php endif; ?>
                            <?php if( $settings['content2']): ?>
                                <p><?php echo wp_kses_post( $settings['content2'] ); ?></p>
                            <?php endif; ?>
                            <?php if( $settings['button_text']): ?>
                                <a href="<?php echo esc_url( $link ); ?>" class="enquiry-link">
                                    <?php echo esc_html( $settings['button_text'] ); ?>
                                    <i class="ti ti-arrow-narrow-right"></i>
                                </a>
                            <?php endif; ?>
                            <?php if( $settings['shape']['url'] != '' ): ?>
                                <div class="all-shapes">
                                    <img src="<?php echo esc_url($settings['shape']['url'] ) ?>" class="enquiry-shape" alt="image">
                                </div>
                            <?php endif; ?>
                            <div class="enquiry-content-style">
                                <?php if( $settings['phn_no']): ?>
                                    <div class="icon">
                                        <a href="tel:<?php echo wp_kses_post( $settings['phn_no'] ); ?>" class="icon">
                                            <i class="ti ti-phone-call"></i>
                                        </a>
                                    </div>
                                <?php endif; ?>
                                <div class="content">
                                    <?php if( $settings['phn_no']): ?>
                                        <h4>
                                        <?php echo wp_kses_post( $settings['phn_title'] ); ?> <a href="tel:<?php echo wp_kses_post( $settings['phn_no'] ); ?>"><?php echo wp_kses_post( $settings['phn_no'] ); ?></a>
                                        </h4>
                                    <?php endif; ?>
                                    <?php if( $settings['bottom_content']): ?>
                                        <p><?php echo wp_kses_post( $settings['bottom_content'] ); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Enquiry Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Enquiry );