<?php
/**
 * Events Four Widget
*/

namespace Elementor;
class Falar_Events_Four extends Widget_Base {

	public function get_name() {
        return 'Events_Four';
    }

	public function get_title() {
        return __( 'Events Four', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-person';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'events_section',
			[
				'label' => __( 'Events Four', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Upcoming Events', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => falar_toolkit_get_page_events_cat_el(),
                ]
            );

            $this->add_control(
                'order',
                [
                    'label' => __( 'Events Order By', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'falar-toolkit' ),
                        'ASC'       => __( 'ASC', 'falar-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label' => __( 'Post Per Page', 'falar-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 4,
                    'description' => __('If you want to see all post, type -1','falar-toolkit')
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'events_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .section-title h2',
            ]
        );
        $this->add_control(
            'card_top_color',
            [
                'label'     => __( 'Card Top Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-widget span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'card_top_bg_color',
            [
                'label'     => __( 'Card Top Title Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-widget span' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_content_typography',
                'label'    => __( 'Card top title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-widget span',
            ]
        );
        $this->add_control(
            'card_title_color',
            [
                'label'     => __( 'Card Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-widget h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_title_typography',
                'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-widget h3',
            ]
        );
        $this->add_control(
            'card_content_color',
            [
                'label'     => __( 'Card Content Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-widget .event-list li' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_content_typography',
                'label'    => __( 'Card Content Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-widget .event-list li',
            ]
        );
        $this->add_control(
            'card_bg_color',
            [
                'label'     => __( 'Card Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-widget' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Events Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'events',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'events_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'events',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order']
            );
        }

        $events_array = new \WP_Query( $args );

        ?>

        <!-- International Event Warp Start -->
        <div class="international-event-warp pb-100">
            <div class="container">
                <div class="section-title">
                    <?php if( $settings['title']): ?>
                        <h2 class="reveal3"><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                    <?php endif; ?>
                </div>
                <div class="row g-4">
                    <?php
                        $i=1;
                        $c=0;
                        while($events_array->have_posts()):
                            $events_array->the_post();
                            $id                =  get_the_ID();
                            $events_date       = get_field( 'events_date' );
                            $events_location   = get_field( 'events_location' );
                            $timestamp         = strtotime($events_date);
                        ?>
                    <?php if ($timestamp > time()):
                        $c++; ?>
                        <div class="col-lg-6">
                            <div class="event-widget style2 bg-<?php echo esc_attr($i); ?>">
                                <?php
                                    $post_categories = get_the_terms(get_the_ID(), 'events_cat');

                                    if ($post_categories && !is_wp_error($post_categories)) {
                                        foreach ($post_categories as $category) {
                                            ?>
                                            <a href="<?php echo esc_url(get_term_link($category)); ?>">
                                                <span><?php echo esc_html($category->name); ?></span>
                                            </a>
                                            <?php
                                        }
                                    }
                                ?>
                                <h3>
                                    <a href="<?php echo esc_url(get_the_permalink($id)); ?>">
                                        <?php the_title(); ?>
                                    </a>
                                </h3>
                                <ul class="event-list">
                                    <?php if($events_date): ?>
                                        <li>
                                            <i class="ti ti-calendar"></i>
                                            <?php echo wp_kses_post($events_date); ?>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($events_location): ?>
                                        <li>
                                            <i class="ti ti-map-pin"></i>
                                            <?php echo wp_kses_post($events_location); ?>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    <?php endif;  ?>
                    <?php $i++; endwhile; wp_reset_postdata();?>
                </div>
                <?php if($c == 0): ?>
                    <div class="no-upcoming">
                        <h3><?php echo wp_kses_post( $settings['expired_date'] ); ?></h3>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <!-- International Event Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Events_Four );