<?php
/**
 * Events Six Widget
*/

namespace Elementor;
class Falar_Events_Six extends Widget_Base {

	public function get_name() {
        return 'Events_Six';
    }

	public function get_title() {
        return __( 'Events Six', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-person';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'events_Six_section',
			[
				'label' => __( 'Events Six', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'event_img',
            [
                'label'       => __( 'Event Image', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Upcoming Events', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'expired_date',
            [
                'label'       => __( 'Upcoming Events Not Available', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Upcoming  Events Not Available!', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => falar_toolkit_get_page_events_cat_el(),
                ]
            );

            $this->add_control(
                'order',
                [
                    'label' => __( 'Events Order By', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'falar-toolkit' ),
                        'ASC'       => __( 'ASC', 'falar-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label' => __( 'Post Per Page', 'falar-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 4,
                    'description' => __('If you want to see all post, type -1','falar-toolkit')
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'events_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .inner-home-five-upcoming-event .five-event-heading h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .inner-home-five-upcoming-event .five-event-heading h2',
            ]
        );
        $this->add_control(
            'card_top_color',
            [
                'label'     => __( 'Card Top Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .five-event-card .tags' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'card_top_bg_color',
            [
                'label'     => __( 'Card Top Title Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .five-event-card .tags' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_content_typography',
                'label'    => __( 'Card top title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-contest-card .tags',
            ]
        );
        $this->add_control(
            'card_title_color',
            [
                'label'     => __( 'Card Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .five-event-card h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_title_typography',
                'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .five-event-card h3',
            ]
        );
        $this->add_control(
            'card_content_color',
            [
                'label'     => __( 'Card Content Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .five-event-card ul li' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_content_typography',
                'label'    => __( 'Card Content Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .five-event-card ul li',
            ]
        );
        $this->add_control(
            'card_bg_color',
            [
                'label'     => __( 'Card Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .five-event-card' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'area_bg_color',
            [
                'label'     => __( 'Area Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .five-event-card' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Events Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'events',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'events_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'events',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order']
            );
        }
        $events_array = new \WP_Query( $args );

        ?>

        <!-- Home Five Upcoming Event Artea Start -->
        <div class="home-five-upcoming-events">
            <div class="container-fluid inner-home-five-upcoming-event pt-100">
                <div class="container">
                    <div class="five-event-heading">
                        <?php if( $settings['title']): ?>
                            <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                        <?php endif; ?>
                    </div>
                    <div class="row g-4">
                        <div class="col-lg-4">
                            <?php if( $settings['event_img']['url'] != '' ): ?>
                                <div class="five-upcoming-image">
                                    <img src="<?php echo esc_url($settings['event_img']['url'] ) ?>" alt="image">
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-lg-8">
                            <div class="five-upcoming-events-slider-widget">
                                <div class="swiper five-upcoming-slider">
                                    <div class="swiper-wrapper">
                                    <?php
                                        $i=1;
                                        $c=0;
                                        while($events_array->have_posts()):
                                            $events_array->the_post();
                                            $id                =  get_the_ID();
                                            $events_date       = get_field( 'events_date' );
                                            $events_location   = get_field( 'events_location' );
                                            $timestamp         = strtotime($events_date);
                                        ?>
                                            <div class="swiper-slide">
                                                <div class="five-event-card">
                                                    <?php
                                                        $post_categories = get_the_terms(get_the_ID(), 'events_cat');

                                                        if ($post_categories && !is_wp_error($post_categories)) {
                                                            foreach ($post_categories as $category) {
                                                                ?>
                                                                <a class="tags" href="<?php echo esc_url(get_term_link($category)); ?>">
                                                                    <?php echo esc_html($category->name); ?>
                                                                </a>
                                                                <?php
                                                            }
                                                        }
                                                    ?>
                                                    <h3>
                                                        <a href="<?php echo esc_url(get_the_permalink($id)); ?>">
                                                        <?php the_title(); ?>
                                                        </a>
                                                    </h3>
                                                    <ul>
                                                        <?php if($events_date): ?>
                                                            <li>
                                                                <i class="ti ti-calendar"></i>
                                                                <?php echo wp_kses_post($events_date); ?>
                                                            </li>
                                                        <?php endif; ?>
                                                        <?php if($events_location): ?>
                                                            <li>
                                                                <i class="ti ti-map-pin"></i>
                                                                <?php echo wp_kses_post($events_location); ?>
                                                            </li>
                                                        <?php endif; ?>
                                                    </ul>
                                                </div>
                                            </div>
                                        <?php $i++; endwhile; wp_reset_postdata();?>
                                    </div>
                                </div>
                                <div class="swiper-btn">
                                    <div class="swiper-button-next"></div>
                                    <div class="swiper-button-prev"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Home Five Upcoming Event Artea End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Events_Six );