<?php
/**
 * Events Two Widget
*/

namespace Elementor;
class Falar_Events_Two extends Widget_Base {

	public function get_name() {
        return 'Events_Two';
    }

	public function get_title() {
        return __( 'Events Two', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-person';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'events_section',
			[
				'label' => __( 'Events', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Upcoming Events', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'expired_date',
            [
                'label'       => __( 'Expired Date', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('The date is expired !', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => falar_toolkit_get_page_events_cat_el(),
                ]
            );

            $this->add_control(
                'order',
                [
                    'label' => __( 'Events Order By', 'falar-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'falar-toolkit' ),
                        'ASC'       => __( 'ASC', 'falar-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label' => __( 'Post Per Page', 'falar-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 4,
                    'description' => __('If you want to see all post, type -1','falar-toolkit')
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'events_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-warp h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .section-warp h2',
            ]
        );
        $this->add_control(
            'card_top_color',
            [
                'label'     => __( 'Card Top Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-plan-widget .content span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'card_top_bg_color',
            [
                'label'     => __( 'Card Top Title Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-plan-widget .content span' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_content_typography',
                'label'    => __( 'Card top title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-plan-widget .content span',
            ]
        );
        $this->add_control(
            'card_title_color',
            [
                'label'     => __( 'Card Title Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-plan-widget .content h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_title_typography',
                'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-plan-widget .content h3',
            ]
        );
        $this->add_control(
            'card_content_color',
            [
                'label'     => __( 'Card Content Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .event-plan-widget .content .event-plan-list li' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'card_content_typography',
                'label'    => __( 'Card Content Typography', 'falar-toolkit' ),
                'selector' => '{{WRAPPER}} .event-plan-widget .content .event-plan-list li',
            ]
        );
        $this->add_control(
            'card_bg_color',
            [
                'label'     => __( 'Area Background Color', 'falar-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bg-EEEEF5' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Events Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'events',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'events_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'events',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order']
            );
        }

        $events_array = new \WP_Query( $args );

        ?>
        
        <!-- Event Plan Warp Start -->
        <div class="event-plan-warp ptb-100 bg-EEEEF5">
            <div class="container">
                <div class="section-warp">
                    <?php if( $settings['title']): ?>
                        <h2 class="reveal3"><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                    <?php endif; ?>
                </div>
                
                <div class="event-plan-slider-warp">
                    <div class="swiper event-plan-slider">
                        <div class="swiper-wrapper">
                            <?php
                                $i=1;
                                $c=0;
                                while($events_array->have_posts()):
                                    $events_array->the_post();
                                    $id                =  get_the_ID();
                                    $events_date       = get_field( 'events_date' );
                                    $events_location   = get_field( 'events_location' );
                                    $timestamp         = strtotime($events_date);
                                ?>
                                <?php if ($timestamp > time()):
                                    $c++; ?>
                                    <div class="swiper-slide">
                                        <div class="event-plan-widget">
                                            <?php if(get_the_post_thumbnail_url() != ''): ?>
                                                <div class="image">
                                                    <div class="image">
                                                        <a href="<?php echo esc_url(get_the_permalink($id)); ?>"><img src="<?php echo get_the_post_thumbnail_url( get_the_ID() ); ?>" alt="image"></a>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <div class="content">
                                                <?php
                                                    $post_categories = get_the_terms(get_the_ID(), 'events_cat');

                                                    if ($post_categories && !is_wp_error($post_categories)) {
                                                        foreach ($post_categories as $category) {
                                                            ?>
                                                            <a href="<?php echo esc_url(get_term_link($category)); ?>">
                                                                <span><?php echo esc_html($category->name); ?></span>
                                                            </a>
                                                            <?php
                                                        }
                                                    }
                                                ?>
                                                <h3>
                                                    <a href="<?php echo esc_url(get_the_permalink($id)); ?>">
                                                        <?php the_title(); ?>
                                                    </a>
                                                </h3>
                                                <ul class="event-plan-list">
                                                    <?php if($events_location): ?>
                                                        <li>
                                                            <i class="ti ti-map-pin"></i>
                                                            <?php echo wp_kses_post($events_location); ?>
                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if($events_date): ?>
                                                        <li>
                                                            <i class="ti ti-calendar"></i>
                                                            <?php echo wp_kses_post($events_date); ?>
                                                        </li>
                                                    <?php endif; ?>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif;  ?>
                               
                            <?php $i++; endwhile; wp_reset_postdata();?>
                        </div>
                    </div>

                    <?php if($c == 0): ?>
                        <div class="no-upcoming">
                            <h3><?php echo wp_kses_post( $settings['expired_date'] ); ?></h3>
                        </div>
                    <?php endif; ?>
                    
                    <div class="swiper-btn style2">
                        <div class="sswiper-button-next"></div>
                        <div class="sswiper-button-prev"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Event Plan Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Events_Two );