<?php
/**
 * Feature One Widget
 */

namespace Elementor;
class Falar_Feature extends Widget_Base {

	public function get_name() {
        return 'Falar_Feature';
    }

	public function get_title() {
        return __( 'Feature', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Feature_Area',
			[
				'label' => __( 'Feature Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Future Students Of Falar', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'video_link',
            [
                'label'       => __( 'Video Link', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'f_card_top_title',
            [
                'label'       => __( 'Card Top Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Freshers’ Guideline', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'f_card_top_title_link',
            [
                'label'       => __( 'Card Top Title Link', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('#', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'f_card_title',
            [
                'label'       => __( 'Card Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Bring your talent, drive and everything that makes you to come Falar', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'f_card_link',
            [
                'label'       => __( 'Card Link', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'feature_image',
				[
					'label'       => __( 'Feature Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $list_items->add_control(
				'card_top_title',
				[
					'label'       => __( 'Card Top Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'top_title_link',
				[
					'label'       => __( 'Card Top Title Link', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'card_title',
				[
					'label'       => __( 'Card Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'card_link',
				[
					'label'       => __( 'Card Link', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'button_text',
				[
					'label'       => __( 'Button Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'default'     => __('See Guideline', 'falar-toolkit'),
                    'label_block' => true,
				]
			);
            $this->add_control(
                'feature_item',
                [
                    'label' => esc_html__('Add Feature Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
				'feature_icon',
				[
					'label'       => __( 'Feature Icon', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $this->add_control(
                'feature_content',
                [
                    'label'       => __( 'Feature Content', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('You could win $5,000* toward your tuition fees.', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'view_btn',
                [
                    'label'       => __( 'View Buutton Text', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('View Details', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'view_link',
                [
                    'label'       => __( 'View Buutton Link', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'feature_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .section-title h2, .section-title .h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .section-title h2, .section-title .h2',
                ]
            );
            $this->add_control(
				'card_title_color',
				[
					'label'     => __( 'Card Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .features-box .content h3 a, .features-box .content .h3 a, .features-item .content h3 a, .features-item .content .h3 a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_title_typography',
                    'label'    => __( 'Card Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .features-box .content h3, .features-box .content .h3, .features-item .content h3, .features-item .content .h3',
                ]
            );
            $this->add_control(
				'card_btn_color',
				[
					'label'     => __( 'Card Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .features-box .content .features-link, .features-item .content .features-link, .features-item-link .content .features-link' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'card_btn_typography',
                    'label'    => __( 'Card Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .features-box .content .features-link, .features-item .content .features-link, .features-item-link .content .features-link',
                ]
            );
            $this->add_control(
				'feature_content_color',
				[
					'label'     => __( 'Feature Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .features-item-link .content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'feature_content_typography',
                    'label'    => __( 'Feature Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .features-item-link .content p',
                ]
            );

            $this->add_control(
				'area_bg_color',
				[
					'label'     => __( 'Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .bg-F8F8F9' => 'background-color: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $feature_item = $settings['feature_item'];
        ?>

        <!-- Features Warp Start -->
        <div class="features-warp">
            <div class="container-fluid">
                <div class="inner-features-warp ptb-100 bg-F8F8F9">
                    <div class="container">
                        <div class="section-title">
                            <?php if( $settings['title']): ?>
                                <h2 class="reveal2">
                                    <?php echo wp_kses_post( $settings['title'] ); ?>
                                </h2>
                            <?php endif; ?> 
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="features-box">
                                    <?php if( $settings['video_link']): ?>
                                        <div class="image">
                                            <video  autoplay muted loop id="video">
                                                <source src="<?php echo wp_kses_post( $settings['video_link'] ); ?>" type="video/mp4">
                                            </video>
                                        </div>
                                    <?php endif; ?> 
                                    <div class="content">
                                        <?php if( $settings['f_card_top_title']): ?>
                                            <a href="<?php echo wp_kses_post( $settings['f_card_top_title_link'] ); ?>"><span class="title bg1"><?php echo wp_kses_post( $settings['f_card_top_title'] ); ?></span></a>
                                        <?php endif; ?> 
                                        <?php if( $settings['f_card_title']): ?>
                                            <h3>
                                                <a href="<?php echo wp_kses_post( $settings['f_card_link'] ); ?>"><?php echo wp_kses_post( $settings['f_card_title'] ); ?></a>
                                            </h3>
                                        <?php endif; ?>
                                        <?php if( $settings['f_card_link']): ?>
                                            <a href="<?php echo wp_kses_post( $settings['f_card_link'] ); ?>" class="features-link"><span><?php echo wp_kses_post( $settings['f_button_text'] ); ?></span>
                                                <i class="ti ti-arrow-narrow-right"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6" data-cue="slideInLeft">
                                <?php $i = 1; foreach($feature_item as $item_feature): ?>
                                    <div class="features-item">
                                        <div class="image">
                                            <div class="image">
                                                <?php if( $item_feature['feature_image']['url'] != '' ): ?>
                                                    <a href="<?php echo wp_kses_post( $item_feature['card_link'] ); ?>">
                                                        <img src="<?php echo esc_url($item_feature['feature_image']['url'] ) ?>" class="mission-shape" alt="image">
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="content">
                                            <a href="<?php echo wp_kses_post( $item_feature['top_title_link'] ); ?>"><span class="title bg1 <?php if($i == 2): ?>bg2<?php endif; ?>"><?php echo wp_kses_post( $item_feature['card_top_title'] ); ?></span></a>
                                            <h3>
                                                <a href="<?php echo wp_kses_post( $item_feature['card_link'] ); ?>">
                                                    <?php echo wp_kses_post( $item_feature['card_title'] ); ?>
                                                </a>
                                            </h3>
                                            <a href="<?php echo wp_kses_post( $item_feature['card_link'] ); ?>" class="features-link"><span><?php echo wp_kses_post( $item_feature['button_text'] ); ?></span>
                                                <i class="ti ti-arrow-narrow-right"></i>
                                            </a>
                                        </div>
                                    </div>
                                <?php $i++; endforeach; ?>
                                <div class="features-item-link">
                                    <div class="icon">
                                        <div class="icon">
                                            <?php if( $settings['feature_icon']['url'] != '' ): ?>
                                                <a href="#">
                                                    <img src="<?php echo esc_url($settings['feature_icon']['url'] ) ?>" alt="image">
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="content">
                                        <?php if( $settings['feature_content']): ?>
                                            <p><?php echo wp_kses_post( $settings['feature_content'] ); ?></p>
                                        <?php endif; ?>
                                        <?php if( $settings['view_link']): ?>
                                            <a href="<?php echo wp_kses_post( $settings['view_link'] ); ?>" class="features-link"><span><?php echo wp_kses_post( $settings['view_btn'] ); ?></span>
                                                <i class="ti ti-arrow-narrow-right"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Features Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Feature );