<?php
/**
 * Financial Info_Content Widget
 */

namespace Elementor;
class Falar_Financial_Info_Content extends Widget_Base {

	public function get_name() {
        return 'Falar_Financial_Info_Content';
    }

	public function get_title() {
        return __( 'Financial Info Content', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Financial_Image_Area',
			[
				'label' => __( 'Financial Image Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'top_title',
            [
                'label'       => __( 'Top Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('5. admission & aid', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('You Will Get All Admission Information At Once', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('At Falar University, we prepare you to launch your career by providing a supportive, creative, and professional.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'financial_info_text',
				[
					'label'       => __( 'Financial Info Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'financial_info_url',
				[
					'label'       => __( 'Financial Info Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
                'arrow_icon',
                [
                    'type'    => Controls_Manager::ICON,
                    'label'   => esc_html__( 'Arrow Icon', 'falar-toolkit' ),
                    'label_block' => true,
                    'options' => falar_icons(),
                ]
            );
            $this->add_control(
                'financial_item',
                [
                    'label' => esc_html__('Add Financial Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'financial_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

            $this->add_control(
                'top_title_color',
                [
                    'label'     => __( 'Top Title Color', 'falar-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .financial-info-content .title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .financial-info-content .title',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Title Color', 'falar-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .financial-info-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .financial-info-content h3',
                ]
            );

			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .financial-info-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .financial-info-content p',
                ]
            );

            $this->add_control(
				'info_color',
				[
					'label'     => __( 'Info Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .financial-info-content ul li a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'info_typography',
                    'label'    => __( 'Info Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .financial-info-content ul li a',
                ]
            );

            $this->add_control(
				'card_bg_color',
				[
					'label'     => __( 'Card Active Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .financial-info-content ul li a.active, .financial-info-content ul li a:hover' => 'background: {{VALUE}}',
					],
				]
			);
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $financial_item = $settings['financial_item'];
        ?>

            <div class="financial-info-content">
                <?php if( $settings['top_title']): ?>
                    <span class="title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                <?php endif; ?>
                <?php if( $settings['title']): ?>
                    <h3><?php echo wp_kses_post( $settings['title'] ); ?></h3>
                <?php endif; ?>
                <?php if( $settings['content']): ?>
                    <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                <?php endif; ?>
                <ul>
                    <?php $i = 1; foreach($financial_item as $item_financial): ?>
                        <li>
                            <a href="<?php echo wp_kses_post( $item_financial['financial_info_url'] ); ?>" class="item <?php if($i == 2): ?>active<?php endif; ?>">
                                <?php echo wp_kses_post( $item_financial['financial_info_text'] ); ?>
                                <i class="<?php echo wp_kses_post( $item_financial['arrow_icon'] ); ?>"></i>
                            </a>
                        </li>
                    <?php $i++; endforeach; ?>
                </ul>
            </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Financial_Info_Content );