<?php
/**
 * Find Program Three Widget
 */

namespace Elementor;
class Falar_Find_Program_Three extends Widget_Base {

	public function get_name() {
        return 'Falar_Find_Program_Three';
    }

	public function get_title() {
        return __( 'Find Program Three', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Program_Area',
			[
				'label' => __( 'Program Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Visiting At Faral', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content1',
            [
                'label'       => __( 'Content One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Here you’ll find all the information about the reasons why the University of Luva is a unique institution. Get to know why over 200 thousand people a year visit us.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content2',
            [
                'label'       => __( 'Content Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Welcome to Faral, where knowledge meets innovation and where every student is journey to success begins.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'phn_title',
            [
                'label'       => __( 'Phone Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default' => __('Call', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'phn_no',
            [
                'label'       => __( 'Phone Number', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'bottom_content',
            [
                'label'   => __( 'Bottom Content', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('For any kind of admission enquiry', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label'   => __( 'Button Text', 'falar-toolkit' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('Book A Visit Today', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'link_type',
            [
                'label' 		=> esc_html__( 'Button Link Type', 'falar-toolkit' ),
                'type' 			=> Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' => [
                    '1'  	=> esc_html__( 'Link To Page', 'falar-toolkit' ),
                    '2' 	=> esc_html__( 'External Link', 'falar-toolkit' ),
                ],
            ]
        );

        $this->add_control(
            'link_to_page',
            [
                'label' 		=> esc_html__( 'Button Link Page', 'falar-toolkit' ),
                'type' 			=> Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' 		=> falar_toolkit_get_page_as_list(),
                'condition' => [
                    'link_type' => '1',
                ]
            ]
        );

        $this->add_control(
            'ex_link',
            [
                'label'		=> esc_html__('Button External Link', 'falar-toolkit'),
                'type'		=> Controls_Manager:: TEXT,
                'condition' => [
                    'link_type' => '2',
                ]
            ]
        );

        $this->add_control(
            'program_img1',
            [
                'label'       => __( 'Program Image One', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'program_img2',
            [
                'label'       => __( 'Program Image Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'campus_logo',
            [
                'label'       => __( 'campus Logo', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );
        
        $this->add_control(
            'number',
            [
                'label'       => __( 'Number', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('156', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'target',
            [
                'label'       => __( 'Target', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('+', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'funfact_content',
            [
                'label'       => __( 'Funfacts Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Programs Available For Students', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'shape',
            [
                'label'       => __( 'Shape', 'falar-toolkit' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'program_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'num_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-images .logo-content .content h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'num_typography',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-images .logo-content .content h2',
                ]
            );
			$this->add_control(
				'fun_color',
				[
					'label'     => __( 'Funfact Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-images .logo-content .content p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'fun_typography',
                    'label'    => __( 'Funfact Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-images .logo-content .content p',
                ]
            );
			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-content h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-content h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .program-content p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .program-content p',
                ]
            );

            $this->add_control(
				'phone_icon_color',
				[
					'label'     => __( 'Phone Icon Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .visiting-content .visiting-content-style .icon' => 'color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'phone_icon_bg_color',
				[
					'label'     => __( 'Phone Icon Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .visiting-content .visiting-content-style .icon' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'phn_icon_typography',
                    'label'    => __( 'Phone Icon Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .visiting-content .visiting-content-style .icon',
                ]
            );


            $this->add_control(
				'num_color1',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .visiting-content .visiting-content-style .content h4' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'num_typography1',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .visiting-content .visiting-content-style .content h4',
                ]
            );
            $this->add_control(
				'program_btn_color',
				[
					'label'     => __( 'Program Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .visiting-content .default-btn' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'program_btn_typography',
                    'label'    => __( 'Program Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .visiting-content .default-btn',
                ]
            );

            $this->add_control(
				'program_btn_bg_color',
				[
					'label'     => __( 'Program Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .visiting-content .default-btn' => 'background-color: {{VALUE}}',
					],
				]
			);
            $this->add_control(
				'area_bg_color',
				[
					'label'     => __( 'Area Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .bg-FAFAFA' => 'background-color: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Get Button Link
        $link = '#';
        if( $settings['link_type'] == 1 ){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        ?>

        <div class="find-program-warp style2 pb-100 bg-FAFAFA">
            <div class="container">
                <div class="row g-4">
                    <div class="col-lg-6">
                        <div class="visiting-content">
                            <?php if( $settings['title']): ?>
                                <h2 class="reveal2"><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                            <?php endif; ?>
                            <?php if( $settings['content1']): ?>
                                <p><?php echo wp_kses_post( $settings['content1'] ); ?></p>
                            <?php endif; ?>
                            <?php if( $settings['content2']): ?>
                                <p><?php echo wp_kses_post( $settings['content2'] ); ?></p>
                            <?php endif; ?>
                            <div class="visiting-content-style">
                                <?php if( $settings['phn_no']): ?>
                                    <div class="icon">
                                        <a href="tel:<?php echo wp_kses_post( $settings['phn_no'] ); ?>" class="icon">
                                            <i class="ti ti-phone-call"></i>
                                        </a>
                                    </div>
                                <?php endif; ?>
                                <div class="content">
                                    <?php if( $settings['phn_no']): ?>
                                        <h4>
                                        <?php echo wp_kses_post( $settings['phn_title'] ); ?> <a href="tel:<?php echo wp_kses_post( $settings['phn_no'] ); ?>"><?php echo wp_kses_post( $settings['phn_no'] ); ?></a>
                                        </h4>
                                    <?php endif; ?>
                                    <?php if( $settings['bottom_content']): ?>
                                        <p><?php echo wp_kses_post( $settings['bottom_content'] ); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php if( $settings['button_text']): ?>
                                <a href="<?php echo esc_url( $link ); ?>" class="default-btn">
                                    <?php echo esc_html( $settings['button_text'] ); ?>
                                    <i class="ti ti-arrow-narrow-right"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-6" data-cue="slideInUp">
                        <div class="program-images style2">
                            <div class="row g-4">
                                <div class="col-lg-5 col-md-6">
                                    <?php if( $settings['program_img1']['url'] != '' ): ?>
                                        <div class="image reveal2">
                                            <img src="<?php echo esc_url($settings['program_img1']['url'] ) ?>" alt="image">
                                        </div>
                                    <?php endif; ?>
                                    <div class="logo-content">
                                        <div class="logo">
                                            <?php if( $settings['campus_logo']['url'] != '' ): ?>
                                                <div class="logo">
                                                    <img src="<?php echo esc_url($settings['campus_logo']['url'] ) ?>" alt="image">
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="content">
                                            <div class="d-flex">
                                                <?php if( $settings['number']): ?>
                                                    <h2 class="counter"><?php echo wp_kses_post( $settings['number'] ); ?></h2>
                                                <?php endif; ?>
                                                <?php if( $settings['target']): ?>
                                                    <h2 class="plus"><?php echo wp_kses_post( $settings['target'] ); ?></h2>
                                                <?php endif; ?>
                                            </div>
                                            <?php if( $settings['funfact_content']): ?>
                                                <p><?php echo wp_kses_post( $settings['funfact_content'] ); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-7 col-md-6">
                                    <?php if( $settings['program_img2']['url'] != '' ): ?>
                                        <div class="big-image reveal3">
                                            <img src="<?php echo esc_url($settings['program_img2']['url'] ) ?>" alt="image">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="all-shapes">
                <?php if( $settings['shape']['url'] != '' ): ?>
                    <img src="<?php echo esc_url($settings['shape']['url'] ) ?>" class="program-shape" alt="image">
                <?php endif; ?>
            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Find_Program_Three );