<?php
/**
 * Funfact One Widget
 */

namespace Elementor;
class Falar_Funfact extends Widget_Base {

	public function get_name() {
        return 'Falar_Funfact';
    }

	public function get_title() {
        return __( 'Funfact', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Funfact_Area',
			[
				'label' => __( 'Funfact Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $list_items = new Repeater();

            $list_items->add_control(
				'funfact_image',
				[
					'label'       => __( 'Funfact Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $list_items->add_control(
				'number',
				[
					'label'       => __( 'Number', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'target',
				[
					'label'       => __( 'Target', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'content',
				[
					'label'       => __( 'Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'funfact_item',
                [
                    'label' => esc_html__('Add Funfact Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'funfact_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Number Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .fun-fact-card h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Number Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .fun-fact-card h2',
                ]
            );
            $this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .fun-fact-card p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .fun-fact-card p',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $funfact_item = $settings['funfact_item'];
        ?>

        <div class="fun-fact-warp ptb-100">
            <div class="container">
                <div class="row justify-content-center g-4">
                    <?php foreach($funfact_item as $item_funfact): ?>
                        <div class="col-lg-3  col-sm-6 col-md-6" data-cue="slideInUp">
                            <div class="fun-fact-card">
                                <div class="d-flex align-items-center">
                                    <div class="icon">
                                        <?php if( $item_funfact['funfact_image']['url'] != '' ): ?>
                                            <div class="icon style">
                                                <img src="<?php echo esc_url($item_funfact['funfact_image']['url'] ) ?>" class="mission-shape" alt="image">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <h2 class="counter"><?php echo wp_kses_post( $item_funfact['number'] ); ?></h2>
                                    <h2 class="plus"><?php echo wp_kses_post( $item_funfact['target'] ); ?></h2>
                                </div>
                                <p><?php echo wp_kses_post( $item_funfact['content'] ); ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Funfact );