<?php
/**
 * History Widget
 */

namespace Elementor;
class Falar_History extends Widget_Base {

	public function get_name() {
        return 'Falar_History';
    }

	public function get_title() {
        return __( 'History', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_History_Area',
			[
				'label' => __( 'History Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title1',
            [
                'label'       => __( 'Title One', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('University History', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'content1',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('The University of Luva, with more than 110 years of history, is an institution that is proud of its past, which is the foundation for the present and for what we project in the future.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );

        $list_items = new Repeater();

            $list_items->add_control(
				'history_image',
				[
					'label'       => __( 'History Image', 'falar-toolkit' ),
					'type'        => Controls_Manager::MEDIA,
				]
			);
            $this->add_control(
                'history_item',
                [
                    'label' => esc_html__('Add History Image Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
                'title2',
                [
                    'label'       => __( 'Title Two', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __('The Origins Of Falar University', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
    
            $this->add_control(
                'content2',
                [
                    'label'       => __( 'Content Two', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('The University of Luva was officially established on 22 March 1911, shortly after the proclamation of the Portuguese Republic. Its historical roots date back to the 18th century when a combination of training experiences would be transformed into a university.', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'content3',
                [
                    'label'       => __( 'Content Two', 'falar-toolkit' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => __('The University of Falar is a public foundation regulated by private law and with statutory, educational, scientific, cultural, administrative, financial, patrimonial and disciplinary autonomy.', 'falar-toolkit'),
                    'label_block' => true,
                ]
            );
        
        $this->end_controls_section();

        $this->start_controls_section(
			'history_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-campus-title h2' => 'color: {{HISTORY}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-campus-title h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-history-content .big-paragraph' => 'color: {{HISTORY}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-history-content .big-paragraph',
                ]
            );
            $this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-history-title h2' => 'color: {{HISTORY}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-history-title h2',
                ]
            );
            $this->add_control(
				'content_color2',
				[
					'label'     => __( 'Content Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .about-history-content p' => 'color: {{HISTORY}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography2',
                    'label'    => __( 'Content Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-history-content p',
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $history_item = $settings['history_item'];
        ?>

        <!-- Inner Style2 Image Warp Start -->
        <div class="about-style2-image-warp ptb-100">
            <div class="container">
                <div class="row g-4">
                    <div class="col-lg-6">
                        <div class="about-campus-title">
                            <?php if( $settings['title1']): ?>
                                <h2><?php echo wp_kses_post( $settings['title1'] ); ?></h2>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="about-history-content">
                            <?php if( $settings['content1']): ?>
                                <p class="big-paragraph"><?php echo wp_kses_post( $settings['content1'] ); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Inner Style2 Image Warp End -->

        <!-- History Images Warp Start -->
        <div class="history-images-warp">
            <div class="container">
                <div class="history-slider-warp">
                    <div class="swiper history-slider">
                        <div class="swiper-wrapper">
                            <?php foreach($history_item as $item_history): ?>
                                <div class="swiper-slide">
                                    <?php if( $item_history['history_image']['url'] != '' ): ?>
                                        <div class="history-widget">
                                            <img src="<?php echo esc_url($item_history['history_image']['url'] ) ?>" alt="image">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- History Images Warp End -->

        <!-- Inner Style2 Image Warp Start -->
        <div class="about-style2-image-warp pt-100">
            <div class="container">
                <div class="row g-4">
                    <div class="col-lg-6">
                        <div class="about-history-title">
                            <?php if( $settings['title2']): ?>
                                <h2><?php echo wp_kses_post( $settings['title2'] ); ?></h2>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="about-history-content">
                            <?php if( $settings['content2']): ?>
                                <p><?php echo wp_kses_post( $settings['content2'] ); ?></p>
                            <?php endif; ?>
                            <?php if( $settings['content3']): ?>
                                <p><?php echo wp_kses_post( $settings['content3'] ); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Inner Style2 Image Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_History );