<?php
/**
 * Information Technology Widget
 */

namespace Elementor;
class Falar_Information_Technology extends Widget_Base {

	public function get_name() {
        return 'Falar_Information_Technology';
    }

	public function get_title() {
        return __( 'Information Technology', 'falar-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'falar-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Falar_Information_Technology_Area',
			[
				'label' => __( 'Information Technology Controls', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('About IT at Falar', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'label'       => __( 'Content', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Information Technology fosters the spirit of innovation through technology and provides the resources and infrastructure to connect Sheridan students and staff to their goals.', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_two',
            [
                'label'       => __( 'Title Two', 'falar-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Overview of IT Services at Falar', 'falar-toolkit'),
                'label_block' => true,
            ]
        );
        $list_item = new Repeater();

            $list_item->add_control(
				'feature_title',
				[
					'label'       => __( 'Feature Title', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_item->add_control(
				'feature_content',
				[
					'label'       => __( 'Feature Content', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $this->add_control(
                'technology_item',
                [
                    'label' => esc_html__('Add Technology Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_item->get_controls(),
                ]
            );

            $this->add_control(
                'content_box',
                [
                    'label'       => __( 'Content Box', 'falar-toolkit' ),
                    'type'        => Controls_Manager::WYSIWYG,
                    'label_block' => true,
                ]
            );

        $list_items = new Repeater();

            $list_items->add_control(
				'link_text',
				[
					'label'       => __( 'Link Text', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
				'link_url',
				[
					'label'       => __( 'Link Url', 'falar-toolkit' ),
					'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
			);
            $list_items->add_control(
                'active_style',
                [
                    'label' 	=> esc_html__( 'Active/Inactive Style', 'falar-toolkit' ),
                    'type' 		=> Controls_Manager::SELECT,
                    'options' 	=> [
                        '1'         => esc_html__( 'Inactive', 'falar-toolkit' ),
                        '2'         => esc_html__( 'Active', 'falar-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            $this->add_control(
                'link_item',
                [
                    'label' => esc_html__('Add Link Item', 'falar-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'information_style',
			[
				'label' => __( 'Style', 'falar-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title h2' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title h2',
                ]
            );
			$this->add_control(
				'content_color',
				[
					'label'     => __( 'Content Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .blog-title p' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .blog-title p',
                ]
            );

            $this->add_control(
				'title_color2',
				[
					'label'     => __( 'Title Color Two', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .information-teach-content-widget h4' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography2',
                    'label'    => __( 'Title Typography Two', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .information-teach-content-widget h4',
                ]
            );
            $this->add_control(
				'title_color3',
				[
					'label'     => __( 'Title Color Three', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .information-teach-content-widget .content1 h5' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography3',
                    'label'    => __( 'Title Typography Three', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .information-teach-content-widget .content1 h5',
                ]
            );

            $this->add_control(
				'paragraph_color',
				[
					'label'     => __( 'Paragraph Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'paragraph_typography',
                    'label'    => __( 'Paragraph Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} p',
                ]
            );

            $this->add_control(
				'site_btn_color',
				[
					'label'     => __( 'Site Button Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .accessibility-link-widget .accessibility-link-list a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'site_btn_bg_color',
				[
					'label'     => __( 'Site Button Background Color', 'falar-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .accessibility-link-widget .accessibility-link-list a' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'site_btn_typography',
                    'label'    => __( 'Site Button Typography', 'falar-toolkit' ),
                    'selector' => '{{WRAPPER}} .accessibility-link-widget .accessibility-link-list a',
                ]
            );
            
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $technology_item = $settings['technology_item'];
        $link_item    = $settings['link_item'];
        ?>

        <!--  Information Teach Warp Start -->
        <div class="information-teach-warp ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="information-teach-content-widget">
                            <div class="blog-title">
                                <?php if( $settings['title']): ?>
                                    <h2><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                                <?php endif; ?>
                                <?php if( $settings['content']): ?>
                                    <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="information-teach-content">
                                <?php if( $settings['title_two']): ?>
                                    <h4><?php echo wp_kses_post( $settings['title_two'] ); ?></h4>
                                <?php endif; ?>
                                <?php foreach($technology_item as $item_technology): ?>
                                    <div class="content1">
                                        <h5><?php echo wp_kses_post( $item_technology['feature_title'] ); ?></h5>
                                        <p><?php echo wp_kses_post( $item_technology['feature_content'] ); ?></p>
                                    </div>
                                <?php endforeach; ?>
                                <?php if( $settings['content_box']): ?>
                                    <div class="content2">
                                        <?php echo wp_kses_post($settings['content_box']); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="accessibility-link-widget">
                            <div class="accessibility-link-list">
                                <?php foreach($link_item as $item_link): ?>
                                    <a href="<?php echo wp_kses_post( $item_link['link_url'] ); ?>" class="item <?php if ($item_link['active_style']=='1'): ?>inactive<?php elseif($item_link['active_style']=='2'): ?>active<?php endif; ?>"><?php echo wp_kses_post( $item_link['link_text'] ); ?>
                                        <div class="icon">
                                            <i class="ti ti-caret-right-filled"></i>
                                        </div>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--  Information Teach Warp End -->
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Falar_Information_Technology );